/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.SingletonIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SingletonIteratorTest<E>
extends AbstractIteratorTest<E> {
    private static final Object testValue = "foo";

    public SingletonIteratorTest() {
        super(SingletonIteratorTest.class.getSimpleName());
    }

    @Override
    public SingletonIterator<E> makeEmptyIterator() {
        SingletonIterator<E> iter = this.makeObject();
        iter.next();
        iter.remove();
        iter.reset();
        return iter;
    }

    @Override
    public SingletonIterator<E> makeObject() {
        return new SingletonIterator(testValue);
    }

    @Override
    public boolean supportsEmptyIterator() {
        return true;
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Test
    public void testIterator() {
        SingletonIterator<E> iter = this.makeObject();
        Assertions.assertTrue((boolean)iter.hasNext(), (String)"Iterator has a first item");
        Object iterValue = iter.next();
        Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should now be empty");
        try {
            iter.next();
        }
        catch (Exception e) {
            Assertions.assertEquals(e.getClass(), new NoSuchElementException().getClass(), (String)"NoSuchElementException must be thrown");
        }
    }

    @Test
    public void testReset() {
        SingletonIterator<E> it = this.makeObject();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)testValue, (Object)it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        it.reset();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)testValue, (Object)it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        it.reset();
        it.reset();
        Assertions.assertTrue((boolean)it.hasNext());
    }

    @Test
    public void testSingletonIteratorRemove() {
        SingletonIterator iter = new SingletonIterator((Object)"xyzzy");
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"xyzzy", (Object)iter.next());
        iter.remove();
        iter.reset();
        Assertions.assertFalse((boolean)iter.hasNext());
    }
}

