/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ArrayIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayIteratorTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three"};

    public ArrayIteratorTest() {
        super(ArrayIteratorTest.class.getSimpleName());
    }

    @Override
    public ArrayIterator<E> makeEmptyIterator() {
        return new ArrayIterator((Object)new Object[0]);
    }

    @Override
    public ArrayIterator<E> makeObject() {
        return new ArrayIterator((Object)this.testArray);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testIterator() {
        ArrayIterator<E> iter = this.makeObject();
        for (String testValue : this.testArray) {
            Object iterValue = iter.next();
            Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        }
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should now be empty");
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.next(), (String)"NoSuchElementException must be thrown");
    }

    @Test
    public void testNullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> new ArrayIterator(null));
    }

    @Test
    public void testReset() {
        ArrayIterator<E> it = this.makeObject();
        it.next();
        it.reset();
        Assertions.assertEquals((Object)"One", (Object)it.next());
    }
}

