/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.comparators;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections4.comparators.AbstractComparatorTest;
import org.apache.commons.collections4.comparators.FixedOrderComparator;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FixedOrderComparatorTest
extends AbstractComparatorTest<String> {
    private static final String[] topCities = new String[]{"Tokyo", "Mexico City", "Mumbai", "Sao Paulo", "New York", "Shanghai", "Lagos", "Los Angeles", "Calcutta", "Buenos Aires"};

    public FixedOrderComparatorTest() {
        super(FixedOrderComparatorTest.class.getSimpleName());
    }

    private void assertComparatorYieldsOrder(String[] orderedObjects, Comparator<String> comparator) {
        int i;
        String[] keys = (String[])orderedObjects.clone();
        boolean isInNewOrder = false;
        Random rand = new Random();
        block0: while (keys.length > 1 && !isInNewOrder) {
            for (i = keys.length - 1; i > 0; --i) {
                String swap = keys[i];
                int j = rand.nextInt(i + 1);
                keys[i] = keys[j];
                keys[j] = swap;
            }
            for (i = 0; i < keys.length; ++i) {
                if (orderedObjects[i].equals(keys[i])) continue;
                isInNewOrder = true;
                continue block0;
            }
        }
        Arrays.sort(keys, comparator);
        for (i = 0; i < orderedObjects.length; ++i) {
            Assertions.assertEquals((Object)orderedObjects[i], (Object)keys[i]);
        }
    }

    @Override
    public List<String> getComparableObjectsOrdered() {
        return Arrays.asList(topCities);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public Comparator<String> makeObject() {
        return new FixedOrderComparator((Object[])topCities);
    }

    @Test
    public void testAddAsEqual() {
        FixedOrderComparator comparator = new FixedOrderComparator((Object[])topCities);
        comparator.addAsEqual((Object)"New York", (Object)"Minneapolis");
        Assertions.assertEquals((int)0, (int)comparator.compare((Object)"New York", (Object)"Minneapolis"));
        Assertions.assertEquals((int)-1, (int)comparator.compare((Object)"Tokyo", (Object)"Minneapolis"));
        Assertions.assertEquals((int)1, (int)comparator.compare((Object)"Shanghai", (Object)"Minneapolis"));
    }

    @Test
    public void testArrayConstructor() {
        String[] keys = (String[])topCities.clone();
        Object[] topCitiesForTest = (String[])topCities.clone();
        FixedOrderComparator comparator = new FixedOrderComparator(topCitiesForTest);
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
        topCitiesForTest[0] = "Brighton";
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
    }

    @Test
    public void testConstructorPlusAdd() {
        FixedOrderComparator comparator = new FixedOrderComparator();
        for (String topCity : topCities) {
            comparator.add((Object)topCity);
        }
        String[] keys = (String[])topCities.clone();
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
    }

    @Test
    public void testListConstructor() {
        String[] keys = (String[])topCities.clone();
        LinkedList<String> topCitiesForTest = new LinkedList<String>(Arrays.asList(topCities));
        FixedOrderComparator comparator = new FixedOrderComparator(topCitiesForTest);
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
        topCitiesForTest.set(0, "Brighton");
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
    }

    @Test
    public void testLock() {
        FixedOrderComparator comparator = new FixedOrderComparator((Object[])topCities);
        Assertions.assertFalse((boolean)comparator.isLocked());
        comparator.compare((Object)"New York", (Object)"Tokyo");
        Assertions.assertTrue((boolean)comparator.isLocked());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> comparator.add((Object)"Minneapolis"), (String)"Should have thrown an UnsupportedOperationException");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> comparator.addAsEqual((Object)"New York", (Object)"Minneapolis"), (String)"Should have thrown an UnsupportedOperationException");
    }

    @Test
    public void testUnknownObjectBehavior() {
        FixedOrderComparator comparator;
        FixedOrderComparator finalComparator = comparator = new FixedOrderComparator((Object[])topCities);
        Assertions.assertThrows(IllegalArgumentException.class, () -> finalComparator.compare((Object)"New York", (Object)"Minneapolis"), (String)"Should have thrown a IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> finalComparator.compare((Object)"Minneapolis", (Object)"New York"), (String)"Should have thrown a IllegalArgumentException");
        Assertions.assertEquals((Object)FixedOrderComparator.UnknownObjectBehavior.EXCEPTION, (Object)comparator.getUnknownObjectBehavior());
        comparator = new FixedOrderComparator((Object[])topCities);
        comparator.setUnknownObjectBehavior(FixedOrderComparator.UnknownObjectBehavior.BEFORE);
        Assertions.assertEquals((Object)FixedOrderComparator.UnknownObjectBehavior.BEFORE, (Object)comparator.getUnknownObjectBehavior());
        LinkedList<String> keys = new LinkedList<String>(Arrays.asList(topCities));
        keys.addFirst("Minneapolis");
        this.assertComparatorYieldsOrder(keys.toArray(ArrayUtils.EMPTY_STRING_ARRAY), (Comparator<String>)comparator);
        Assertions.assertEquals((int)-1, (int)comparator.compare((Object)"Minneapolis", (Object)"New York"));
        Assertions.assertEquals((int)1, (int)comparator.compare((Object)"New York", (Object)"Minneapolis"));
        Assertions.assertEquals((int)0, (int)comparator.compare((Object)"Minneapolis", (Object)"St Paul"));
        comparator = new FixedOrderComparator((Object[])topCities);
        comparator.setUnknownObjectBehavior(FixedOrderComparator.UnknownObjectBehavior.AFTER);
        keys = new LinkedList<String>(Arrays.asList(topCities));
        keys.add("Minneapolis");
        this.assertComparatorYieldsOrder(keys.toArray(ArrayUtils.EMPTY_STRING_ARRAY), (Comparator<String>)comparator);
        Assertions.assertEquals((int)1, (int)comparator.compare((Object)"Minneapolis", (Object)"New York"));
        Assertions.assertEquals((int)-1, (int)comparator.compare((Object)"New York", (Object)"Minneapolis"));
        Assertions.assertEquals((int)0, (int)comparator.compare((Object)"Minneapolis", (Object)"St Paul"));
    }

    @Nested
    class Equals {
        Equals() {
        }

        @Test
        void expectFalseWhenBothComparatorsWithDifferentItems() {
            FixedOrderComparator comparator1 = new FixedOrderComparator((Object[])new Integer[]{1, 2, 3});
            FixedOrderComparator comparator2 = new FixedOrderComparator((Object[])new Integer[]{2, 3, 4});
            Assertions.assertFalse((boolean)comparator1.equals((Object)comparator2));
        }

        @Test
        void expectFalseWhenBothComparatorsWithDifferentUnknownObjectBehavior() {
            FixedOrderComparator comparator1 = new FixedOrderComparator();
            comparator1.setUnknownObjectBehavior(FixedOrderComparator.UnknownObjectBehavior.BEFORE);
            FixedOrderComparator comparator2 = new FixedOrderComparator();
            comparator2.setUnknownObjectBehavior(FixedOrderComparator.UnknownObjectBehavior.AFTER);
            Assertions.assertFalse((boolean)comparator1.equals((Object)comparator2));
        }

        @Test
        void expectFalseWhenFixedOrderComparatorIsComparedWithNull() {
            FixedOrderComparator comparator = new FixedOrderComparator();
            Assertions.assertFalse((boolean)comparator.equals(null));
        }

        @Test
        void expectFalseWhenFixedOrderComparatorIsComparedWithOtherObject() {
            FixedOrderComparator comparator = new FixedOrderComparator();
            Assertions.assertFalse((boolean)comparator.equals(new Object()));
        }

        @Test
        void expectFalseWhenOneComparatorIsLocked() {
            FixedOrderComparator comparator1 = new FixedOrderComparator((Object[])new Integer[]{1, 2, 3});
            FixedOrderComparator comparator2 = new FixedOrderComparator((Object[])new Integer[]{1, 2, 3});
            comparator2.compare((Object)1, (Object)2);
            Assertions.assertFalse((boolean)comparator1.equals((Object)comparator2));
        }

        @Test
        void expectFalseWhenOneComparatorsWithDuplicateItems() {
            FixedOrderComparator comparator1 = new FixedOrderComparator((Object[])new Integer[]{1, 2, 3});
            FixedOrderComparator comparator2 = new FixedOrderComparator((Object[])new Integer[]{1, 2, 3, 3});
            Assertions.assertFalse((boolean)comparator1.equals((Object)comparator2));
        }

        @Test
        void expectTrueWhenBothComparatorsAreLocked() {
            FixedOrderComparator comparator1 = new FixedOrderComparator((Object[])new Integer[]{1, 2, 3});
            FixedOrderComparator comparator2 = new FixedOrderComparator((Object[])new Integer[]{1, 2, 3});
            comparator1.compare((Object)1, (Object)2);
            comparator2.compare((Object)1, (Object)2);
            Assertions.assertTrue((boolean)comparator1.equals((Object)comparator2));
        }

        @Test
        void expectTrueWhenBothComparatorsWithoutAnyItems() {
            FixedOrderComparator comparator1 = new FixedOrderComparator();
            FixedOrderComparator comparator2 = new FixedOrderComparator();
            Assertions.assertTrue((boolean)comparator1.equals((Object)comparator2));
        }

        @Test
        void expectTrueWhenBothObjectsAreSame() {
            FixedOrderComparator comparator = new FixedOrderComparator();
            Assertions.assertTrue((boolean)comparator.equals((Object)comparator));
        }
    }
}

