/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.apache.commons.collections4.bloomfilter.SparseBloomFilter;
import org.apache.commons.collections4.bloomfilter.TestingHashers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SparseBloomFilterTest
extends AbstractBloomFilterTest<SparseBloomFilter> {
    @Override
    protected SparseBloomFilter createEmptyFilter(Shape shape) {
        return new SparseBloomFilter(shape);
    }

    @Test
    public void testBitMapProducerEdgeCases() {
        int[] values = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 65, 66, 67, 68, 69, 70, 71};
        Object bf = this.createFilter(this.getTestShape(), IndexProducer.fromIndexArray((int[])values));
        int[] passes = new int[1];
        Assertions.assertFalse((boolean)bf.forEachBitMap(l -> {
            passes[0] = passes[0] + 1;
            return false;
        }));
        Assertions.assertEquals((int)1, (int)passes[0]);
        bf = this.createFilter(this.getTestShape(), IndexProducer.fromIndexArray((int[])values));
        passes[0] = 0;
        Assertions.assertFalse((boolean)bf.forEachBitMap(l -> {
            boolean result;
            boolean bl = result = passes[0] == 0;
            if (result) {
                passes[0] = passes[0] + 1;
            }
            return result;
        }));
        Assertions.assertEquals((int)1, (int)passes[0]);
        values = new int[]{1, 2, 3, 4};
        bf = this.createFilter(this.getTestShape(), IndexProducer.fromIndexArray((int[])values));
        passes[0] = 0;
        Assertions.assertTrue((boolean)bf.forEachBitMap(l -> {
            passes[0] = passes[0] + 1;
            return true;
        }));
        Assertions.assertEquals((int)2, (int)passes[0]);
        values = new int[]{1, 2, 3, 4};
        bf = this.createFilter(this.getTestShape(), IndexProducer.fromIndexArray((int[])values));
        passes[0] = 0;
        Assertions.assertFalse((boolean)bf.forEachBitMap(l -> {
            boolean result;
            boolean bl = result = passes[0] == 0;
            if (result) {
                passes[0] = passes[0] + 1;
            }
            return result;
        }));
        Assertions.assertEquals((int)1, (int)passes[0]);
    }

    @Test
    public void testBloomFilterBasedMergeEdgeCases() {
        SparseBloomFilter bf1 = this.createEmptyFilter(this.getTestShape());
        SimpleBloomFilter bf2 = new SimpleBloomFilter(this.getTestShape());
        bf2.merge(TestingHashers.FROM1);
        bf1.merge((BloomFilter)bf2);
        Assertions.assertTrue((boolean)bf2.forEachBitMapPair((BitMapProducer)bf1, (x, y) -> x == y));
    }
}

