/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.TreeSet;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.AbstractBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.BitMap;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.apache.commons.collections4.bloomfilter.TestingHashers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultBloomFilterTest
extends AbstractBloomFilterTest<AbstractDefaultBloomFilter> {
    @Override
    protected AbstractDefaultBloomFilter createEmptyFilter(Shape shape) {
        return new SparseDefaultBloomFilter(shape);
    }

    @Test
    public void testDefaultBloomFilterSimpleSpecificMerge() {
        SparseDefaultBloomFilter filter = new SparseDefaultBloomFilter(Shape.fromKM((int)3, (int)150));
        IncrementingHasher hasher = new IncrementingHasher(0L, 1L);
        Assertions.assertTrue((boolean)filter.merge(hasher));
        Assertions.assertEquals((int)3, (int)((AbstractDefaultBloomFilter)filter).cardinality());
    }

    @Test
    public void testDefaultBloomFilterSparseSpecificMerge() {
        Shape shape = Shape.fromKM((int)3, (int)150);
        SparseDefaultBloomFilter filter = new SparseDefaultBloomFilter(shape);
        AbstractDefaultBloomFilter filter2 = (AbstractDefaultBloomFilter)this.createFilter(shape, new IncrementingHasher(0L, 1L));
        BloomFilter newFilter = filter.copy();
        newFilter.merge((BloomFilter)filter2);
        Assertions.assertEquals((int)3, (int)newFilter.cardinality());
    }

    @Test
    public void testEstimateLargeN() {
        Shape s = Shape.fromKM((int)1, (int)Integer.MAX_VALUE);
        SimpleBloomFilter bf1 = new SimpleBloomFilter(s);
        bf1.merge(predicate -> {
            int limit;
            for (limit = 0x7FFFFFFE; limit > 64; limit -= 64) {
                predicate.test(-1L);
            }
            long last = 0L;
            for (int i = 0; i < limit; ++i) {
                last |= BitMap.getLongBit((int)i);
            }
            predicate.test(last);
            return true;
        });
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)bf1.estimateN());
    }

    @Test
    public void testEstimateNWithBrokenCardinality() {
        BrokenCardinality filter1 = TestingHashers.populateEntireFilter(new BrokenCardinality(this.getTestShape()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> filter1.estimateN());
    }

    @Test
    public void testHasherBasedMergeWithDifferingSparseness() {
        IncrementingHasher hasher = new IncrementingHasher(1L, 1L);
        AbstractDefaultBloomFilter bf1 = new NonSparseDefaultBloomFilter(this.getTestShape());
        bf1.merge(hasher);
        Assertions.assertTrue((boolean)BitMapProducer.fromIndexProducer((IndexProducer)hasher.indices(this.getTestShape()), (int)this.getTestShape().getNumberOfBits()).forEachBitMapPair((BitMapProducer)bf1, (x, y) -> x == y));
        bf1 = new SparseDefaultBloomFilter(this.getTestShape());
        bf1.merge(hasher);
        Assertions.assertTrue((boolean)BitMapProducer.fromIndexProducer((IndexProducer)hasher.indices(this.getTestShape()), (int)this.getTestShape().getNumberOfBits()).forEachBitMapPair((BitMapProducer)bf1, (x, y) -> x == y));
    }

    @Test
    public void testIntersectionLimit() {
        Shape s = Shape.fromKM((int)1, (int)Integer.MAX_VALUE);
        SimpleBloomFilter bf1 = new SimpleBloomFilter(s);
        bf1.merge(predicate -> {
            int limit;
            for (limit = 0x7FFFFFFE; limit > 64; limit -= 64) {
                predicate.test(-1L);
            }
            long last = 0L;
            for (int i = 0; i < limit; ++i) {
                last |= BitMap.getLongBit((int)i);
            }
            predicate.test(last);
            return true;
        });
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)bf1.estimateIntersection((BloomFilter)bf1));
    }

    @Test
    public void testSparseNonSparseMerging() {
        SparseDefaultBloomFilter bf1 = new SparseDefaultBloomFilter(this.getTestShape());
        bf1.merge(TestingHashers.FROM1);
        NonSparseDefaultBloomFilter bf2 = new NonSparseDefaultBloomFilter(this.getTestShape());
        bf2.merge(TestingHashers.FROM11);
        BloomFilter result = bf1.copy();
        result.merge((BloomFilter)bf2);
        Assertions.assertEquals((int)27, (int)result.cardinality());
        result = bf2.copy();
        result.merge((BloomFilter)bf1);
        Assertions.assertEquals((int)27, (int)result.cardinality());
    }

    public static class SparseDefaultBloomFilter
    extends AbstractDefaultBloomFilter {
        public SparseDefaultBloomFilter(Shape shape) {
            super(shape);
        }

        public int characteristics() {
            return 1;
        }

        public AbstractDefaultBloomFilter copy() {
            SparseDefaultBloomFilter result = new SparseDefaultBloomFilter(this.getShape());
            result.indices.addAll(this.indices);
            return result;
        }
    }

    static abstract class AbstractDefaultBloomFilter
    implements BloomFilter {
        private final Shape shape;
        protected TreeSet<Integer> indices;

        AbstractDefaultBloomFilter(Shape shape) {
            this.shape = shape;
            this.indices = new TreeSet();
        }

        public int cardinality() {
            return this.indices.size();
        }

        private void checkIndicesRange() {
            if (!this.indices.isEmpty()) {
                if (this.indices.last() >= this.shape.getNumberOfBits()) {
                    throw new IllegalArgumentException(String.format("Value in list %s is greater than maximum value (%s)", this.indices.last(), this.shape.getNumberOfBits()));
                }
                if (this.indices.first() < 0) {
                    throw new IllegalArgumentException(String.format("Value in list %s is less than 0", this.indices.first()));
                }
            }
        }

        public void clear() {
            this.indices.clear();
        }

        public boolean contains(BitMapProducer bitMapProducer) {
            return this.contains(IndexProducer.fromBitMapProducer((BitMapProducer)bitMapProducer));
        }

        public boolean contains(IndexProducer indexProducer) {
            return indexProducer.forEachIndex(this.indices::contains);
        }

        public boolean forEachBitMap(LongPredicate consumer) {
            return BitMapProducer.fromIndexProducer((IndexProducer)this, (int)this.shape.getNumberOfBits()).forEachBitMap(consumer);
        }

        public boolean forEachIndex(IntPredicate consumer) {
            for (Integer i : this.indices) {
                if (consumer.test(i)) continue;
                return false;
            }
            return true;
        }

        public Shape getShape() {
            return this.shape;
        }

        public boolean merge(BitMapProducer bitMapProducer) {
            return this.merge(IndexProducer.fromBitMapProducer((BitMapProducer)bitMapProducer));
        }

        public boolean merge(IndexProducer indexProducer) {
            boolean result = indexProducer.forEachIndex(x -> {
                this.indices.add(x);
                return true;
            });
            this.checkIndicesRange();
            return result;
        }
    }

    static class BrokenCardinality
    extends NonSparseDefaultBloomFilter {
        BrokenCardinality(Shape shape) {
            super(shape);
        }

        @Override
        public int cardinality() {
            return super.cardinality() + 1;
        }
    }

    public static class NonSparseDefaultBloomFilter
    extends AbstractDefaultBloomFilter {
        public NonSparseDefaultBloomFilter(Shape shape) {
            super(shape);
        }

        public int characteristics() {
            return 0;
        }

        public AbstractDefaultBloomFilter copy() {
            NonSparseDefaultBloomFilter result = new NonSparseDefaultBloomFilter(this.getShape());
            result.indices.addAll(this.indices);
            return result;
        }
    }
}

