/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.AbstractBitMapProducerTest;
import org.apache.commons.collections4.bloomfilter.BitMap;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.DefaultIndexProducerTest;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultBitMapProducerTest
extends AbstractBitMapProducerTest {
    long[] values = DefaultBitMapProducerTest.generateLongArray(5);

    static long[] generateLongArray(int size) {
        return ThreadLocalRandom.current().longs(size).toArray();
    }

    @Override
    protected BitMapProducer createEmptyProducer() {
        return new DefaultBitMapProducer(new long[0]);
    }

    @Override
    protected BitMapProducer createProducer() {
        return new DefaultBitMapProducer(this.values);
    }

    @Override
    protected boolean emptyIsZeroLength() {
        return true;
    }

    @Test
    public void testAsBitMapArrayLargeArray() {
        long[] expected = DefaultBitMapProducerTest.generateLongArray(32);
        BitMapProducer producer = predicate -> {
            for (long l : expected) {
                if (predicate.test(l)) continue;
                return false;
            }
            return true;
        };
        long[] ary = producer.asBitMapArray();
        Assertions.assertArrayEquals((long[])expected, (long[])ary);
    }

    @Test
    public void testFromBitMapArray() {
        int nOfBitMaps = BitMap.numberOfBitMaps((int)256);
        long[] expected = DefaultBitMapProducerTest.generateLongArray(nOfBitMaps);
        long[] ary = BitMapProducer.fromBitMapArray((long[])expected).asBitMapArray();
        Assertions.assertArrayEquals((long[])expected, (long[])ary);
    }

    @Test
    public void testFromIndexProducer() {
        int[] expected = DefaultIndexProducerTest.generateIntArray(10, 256);
        IndexProducer ip = IndexProducer.fromIndexArray((int[])expected);
        long[] ary = BitMapProducer.fromIndexProducer((IndexProducer)ip, (int)256).asBitMapArray();
        for (int idx : expected) {
            Assertions.assertTrue((boolean)BitMap.contains((long[])ary, (int)idx));
        }
    }

    class DefaultBitMapProducer
    implements BitMapProducer {
        long[] bitMaps;

        DefaultBitMapProducer(long[] bitMaps) {
            this.bitMaps = bitMaps;
        }

        public boolean forEachBitMap(LongPredicate predicate) {
            for (long bitmap : this.bitMaps) {
                if (predicate.test(bitmap)) continue;
                return false;
            }
            return true;
        }
    }
}

