/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import org.apache.commons.collections4.bloomfilter.AbstractBitMapProducerTest;
import org.apache.commons.collections4.bloomfilter.BitMap;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BitMapProducerFromIndexProducerTest
extends AbstractBitMapProducerTest {
    @Override
    protected BitMapProducer createEmptyProducer() {
        IndexProducer iProducer = consumer -> true;
        return BitMapProducer.fromIndexProducer((IndexProducer)iProducer, (int)200);
    }

    @Override
    protected BitMapProducer createProducer() {
        IndexProducer iProducer = consumer -> consumer.test(0) && consumer.test(1) && consumer.test(63) && consumer.test(64) && consumer.test(127) && consumer.test(128);
        return BitMapProducer.fromIndexProducer((IndexProducer)iProducer, (int)200);
    }

    @Test
    public final void testFromIndexProducer() {
        ArrayList lst = new ArrayList();
        this.createProducer().forEachBitMap(lst::add);
        long[] buckets = lst.stream().mapToLong(Long::longValue).toArray();
        Assertions.assertTrue((boolean)BitMap.contains((long[])buckets, (int)0));
        Assertions.assertTrue((boolean)BitMap.contains((long[])buckets, (int)1));
        Assertions.assertTrue((boolean)BitMap.contains((long[])buckets, (int)63));
        Assertions.assertTrue((boolean)BitMap.contains((long[])buckets, (int)64));
        Assertions.assertTrue((boolean)BitMap.contains((long[])buckets, (int)127));
        Assertions.assertTrue((boolean)BitMap.contains((long[])buckets, (int)128));
    }
}

