/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.collections4.SortedBidiMap;
import org.apache.commons.collections4.bidimap.AbstractSortedBidiMapTest;
import org.apache.commons.collections4.bidimap.DualTreeBidiMap;
import org.apache.commons.collections4.comparators.ComparableComparator;
import org.apache.commons.collections4.comparators.ReverseComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DualTreeBidiMap2Test<K extends Comparable<K>, V extends Comparable<V>>
extends AbstractSortedBidiMapTest<K, V> {
    public DualTreeBidiMap2Test() {
        super(DualTreeBidiMap2Test.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.Test2";
    }

    @Override
    public String[] ignoredTests() {
        String recursiveTest = "DualTreeBidiMap2Test.bulkTestInverseMap.bulkTestInverseMap";
        return new String[]{"DualTreeBidiMap2Test.bulkTestInverseMap.bulkTestInverseMap"};
    }

    @Override
    public TreeMap<K, V> makeConfirmedMap() {
        return new TreeMap(new ReverseComparator((Comparator)ComparableComparator.comparableComparator()));
    }

    @Override
    public DualTreeBidiMap<K, V> makeObject() {
        return new DualTreeBidiMap((Comparator)new ReverseComparator((Comparator)ComparableComparator.comparableComparator()), (Comparator)new ReverseComparator((Comparator)ComparableComparator.comparableComparator()));
    }

    @Test
    public void testCollections364() throws Exception {
        DualTreeBidiMap original = new DualTreeBidiMap(String.CASE_INSENSITIVE_ORDER, (Comparator)new IntegerComparator());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(original);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        DualTreeBidiMap deserialized = (DualTreeBidiMap)in.readObject();
        in.close();
        Assertions.assertNotNull((Object)original.comparator());
        Assertions.assertNotNull((Object)deserialized.comparator());
        Assertions.assertEquals(original.comparator().getClass(), deserialized.comparator().getClass());
        Assertions.assertEquals(original.valueComparator().getClass(), deserialized.valueComparator().getClass());
    }

    @Test
    public void testComparator() {
        this.resetEmpty();
        SortedBidiMap bidi = (SortedBidiMap)this.map;
        Assertions.assertNotNull((Object)bidi.comparator());
        Assertions.assertTrue((boolean)(bidi.comparator() instanceof ReverseComparator));
    }

    @Test
    public void testComparator2() {
        DualTreeBidiMap dtbm = new DualTreeBidiMap(String.CASE_INSENSITIVE_ORDER, null);
        dtbm.put((Object)"two", (Object)0);
        dtbm.put((Object)"one", (Object)1);
        Assertions.assertEquals((Object)"one", (Object)dtbm.firstKey());
        Assertions.assertEquals((Object)"two", (Object)dtbm.lastKey());
    }

    @Test
    public void testSerializeDeserializeCheckComparator() throws Exception {
        DualTreeBidiMap<K, V> obj = this.makeObject();
        if (obj instanceof Serializable && this.isTestSerialization()) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(obj);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            Object dest = in.readObject();
            in.close();
            SortedBidiMap bidi = (SortedBidiMap)dest;
            Assertions.assertNotNull((Object)obj.comparator());
            Assertions.assertNotNull((Object)bidi.comparator());
            Assertions.assertTrue((boolean)(bidi.comparator() instanceof ReverseComparator));
        }
    }

    @Test
    public void testSortOrder() throws Exception {
        SortedBidiMap sm = this.makeFullMap();
        List newSortedKeys = this.getAsList(this.getSampleKeys());
        newSortedKeys.sort(new ReverseComparator((Comparator)ComparableComparator.comparableComparator()));
        newSortedKeys = Collections.unmodifiableList(newSortedKeys);
        Iterator mapIter = sm.keySet().iterator();
        for (Comparable expectedKey : newSortedKeys) {
            Comparable mapKey = (Comparable)mapIter.next();
            Assertions.assertNotNull((Object)expectedKey, (String)"key in sorted list may not be null");
            Assertions.assertNotNull((Object)mapKey, (String)"key in map may not be null");
            Assertions.assertEquals((Object)expectedKey, (Object)mapKey, (String)"key from sorted list and map must be equal");
        }
    }

    private static final class IntegerComparator
    implements Comparator<Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private IntegerComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    }
}

