/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.ExceptionClosure;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.apache.commons.collections4.functors.NOPClosure;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ClosureUtilsTest {
    private static final Object cString = "Hello";

    @Test
    public void testChainedClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = new MockClosure();
        ClosureUtils.chainedClosure((Closure[])new Closure[]{a, b}).execute(null);
        Assertions.assertEquals((int)1, (int)a.count);
        Assertions.assertEquals((int)1, (int)b.count);
        a = new MockClosure();
        b = new MockClosure();
        ClosureUtils.chainedClosure((Closure[])new Closure[]{a, b, a}).execute(null);
        Assertions.assertEquals((int)2, (int)a.count);
        Assertions.assertEquals((int)1, (int)b.count);
        a = new MockClosure();
        b = new MockClosure();
        ArrayList coll = new ArrayList();
        coll.add(b);
        coll.add(a);
        coll.add(b);
        ClosureUtils.chainedClosure(coll).execute(null);
        Assertions.assertEquals((int)1, (int)a.count);
        Assertions.assertEquals((int)2, (int)b.count);
        Assertions.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.chainedClosure((Closure[])new Closure[0]));
        Assertions.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.chainedClosure(Collections.emptyList()));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.chainedClosure((Closure[])new Closure[]{null, null})), () -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.chainedClosure((Closure[])null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.chainedClosure((Collection)null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.chainedClosure((Closure[])new Closure[]{null, null})), () -> {
            ArrayList<Object> finalColl = new ArrayList<Object>();
            finalColl.add(null);
            finalColl.add(null);
            Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.chainedClosure((Collection)finalColl));
        }});
    }

    @Test
    public void testDoWhileClosure() {
        MockClosure cmd = new MockClosure();
        ClosureUtils.doWhileClosure(cmd, (Predicate)FalsePredicate.falsePredicate()).execute(null);
        Assertions.assertEquals((int)1, (int)cmd.count);
        cmd = new MockClosure();
        ClosureUtils.doWhileClosure(cmd, (Predicate)PredicateUtils.uniquePredicate()).execute(null);
        Assertions.assertEquals((int)2, (int)cmd.count);
        Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.doWhileClosure(null, null));
    }

    @Test
    public void testExceptionClosure() {
        Assertions.assertNotNull((Object)ClosureUtils.exceptionClosure());
        Assertions.assertSame((Object)ClosureUtils.exceptionClosure(), (Object)ClosureUtils.exceptionClosure());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(FunctorException.class, () -> ClosureUtils.exceptionClosure().execute(null)), () -> Assertions.assertThrows(FunctorException.class, () -> ClosureUtils.exceptionClosure().execute(cString))});
    }

    @Test
    public void testForClosure() {
        MockClosure cmd = new MockClosure();
        ClosureUtils.forClosure((int)5, cmd).execute(null);
        Assertions.assertEquals((int)5, (int)cmd.count);
        Assertions.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)0, new MockClosure()));
        Assertions.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)-1, new MockClosure()));
        Assertions.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)1, null));
        Assertions.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)3, null));
        Assertions.assertSame(cmd, (Object)ClosureUtils.forClosure((int)1, cmd));
    }

    @Test
    public void testIfClosure() {
        MockClosure a = new MockClosure();
        ClosureUtils.ifClosure((Predicate)TruePredicate.truePredicate(), a).execute(null);
        Assertions.assertEquals((int)1, (int)a.count);
        a = new MockClosure();
        ClosureUtils.ifClosure((Predicate)FalsePredicate.falsePredicate(), a).execute(null);
        Assertions.assertEquals((int)0, (int)a.count);
        a = new MockClosure();
        MockClosure b = new MockClosure();
        ClosureUtils.ifClosure((Predicate)TruePredicate.truePredicate(), a, b).execute(null);
        Assertions.assertEquals((int)1, (int)a.count);
        Assertions.assertEquals((int)0, (int)b.count);
        a = new MockClosure();
        b = new MockClosure();
        ClosureUtils.ifClosure((Predicate)FalsePredicate.falsePredicate(), a, b).execute(null);
        Assertions.assertEquals((int)0, (int)a.count);
        Assertions.assertEquals((int)1, (int)b.count);
    }

    @Test
    public void testInvokeClosure() {
        StringBuilder buf = new StringBuilder("Hello");
        ClosureUtils.invokerClosure((String)"reverse").execute((Object)buf);
        Assertions.assertEquals((Object)"olleH", (Object)buf.toString());
        buf = new StringBuilder("Hello");
        ClosureUtils.invokerClosure((String)"setLength", (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{2}).execute((Object)buf);
        Assertions.assertEquals((Object)"He", (Object)buf.toString());
    }

    @Test
    public void testNopClosure() {
        StringBuilder buf = new StringBuilder("Hello");
        ClosureUtils.nopClosure().execute(null);
        Assertions.assertEquals((Object)"Hello", (Object)buf.toString());
        ClosureUtils.nopClosure().execute((Object)"Hello");
        Assertions.assertEquals((Object)"Hello", (Object)buf.toString());
    }

    @Test
    public void testSingletonPatternInSerialization() {
        Object[] singletons;
        for (Object original : singletons = new Object[]{ExceptionClosure.INSTANCE, NOPClosure.INSTANCE}) {
            TestUtils.assertSameAfterSerialization("Singleton pattern broken for " + original.getClass(), original);
        }
    }

    @Test
    public void testSwitchClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = new MockClosure();
        ClosureUtils.switchClosure((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Closure[])new Closure[]{a, b}).execute((Object)"WELL");
        Assertions.assertEquals((int)0, (int)a.count);
        Assertions.assertEquals((int)0, (int)b.count);
        a.reset();
        b.reset();
        ClosureUtils.switchClosure((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Closure[])new Closure[]{a, b}).execute((Object)"HELLO");
        Assertions.assertEquals((int)1, (int)a.count);
        Assertions.assertEquals((int)0, (int)b.count);
        a.reset();
        b.reset();
        MockClosure c = new MockClosure();
        ClosureUtils.switchClosure((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Closure[])new Closure[]{a, b}, c).execute((Object)"WELL");
        Assertions.assertEquals((int)0, (int)a.count);
        Assertions.assertEquals((int)0, (int)b.count);
        Assertions.assertEquals((int)1, (int)c.count);
        a.reset();
        b.reset();
        HashMap map = new HashMap();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        ClosureUtils.switchClosure(map).execute(null);
        Assertions.assertEquals((int)0, (int)a.count);
        Assertions.assertEquals((int)0, (int)b.count);
        a.reset();
        b.reset();
        map.clear();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        ClosureUtils.switchClosure(map).execute((Object)"THERE");
        Assertions.assertEquals((int)0, (int)a.count);
        Assertions.assertEquals((int)1, (int)b.count);
        a.reset();
        b.reset();
        c.reset();
        map.clear();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        map.put(null, c);
        ClosureUtils.switchClosure(map).execute((Object)"WELL");
        Assertions.assertEquals((int)0, (int)a.count);
        Assertions.assertEquals((int)0, (int)b.count);
        Assertions.assertEquals((int)1, (int)c.count);
        Assertions.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchClosure((Predicate[])new Predicate[0], (Closure[])new Closure[0]));
        Assertions.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchClosure(new HashMap()));
        map.clear();
        map.put(null, null);
        Assertions.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchClosure(map));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.switchClosure(null, null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.switchClosure((Predicate[])null, (Closure[])null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.switchClosure((Map)null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.switchClosure((Predicate[])new Predicate[2], (Closure[])new Closure[2])), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> ClosureUtils.switchClosure((Predicate[])new Predicate[]{TruePredicate.truePredicate()}, (Closure[])new Closure[]{a, b}))});
    }

    @Test
    public void testSwitchMapClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = new MockClosure();
        HashMap map = new HashMap();
        map.put("HELLO", a);
        map.put("THERE", b);
        ClosureUtils.switchMapClosure(map).execute(null);
        Assertions.assertEquals((int)0, (int)a.count);
        Assertions.assertEquals((int)0, (int)b.count);
        a.reset();
        b.reset();
        map.clear();
        map.put("HELLO", a);
        map.put("THERE", b);
        ClosureUtils.switchMapClosure(map).execute((Object)"THERE");
        Assertions.assertEquals((int)0, (int)a.count);
        Assertions.assertEquals((int)1, (int)b.count);
        a.reset();
        b.reset();
        map.clear();
        MockClosure c = new MockClosure();
        map.put("HELLO", a);
        map.put("THERE", b);
        map.put(null, c);
        ClosureUtils.switchMapClosure(map).execute((Object)"WELL");
        Assertions.assertEquals((int)0, (int)a.count);
        Assertions.assertEquals((int)0, (int)b.count);
        Assertions.assertEquals((int)1, (int)c.count);
        Assertions.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchMapClosure(new HashMap()));
        Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.switchMapClosure(null));
    }

    @Test
    public void testTransformerClosure() {
        MockTransformer mock = new MockTransformer();
        Closure closure = ClosureUtils.asClosure(mock);
        closure.execute(null);
        Assertions.assertEquals((int)1, (int)mock.count);
        closure.execute(null);
        Assertions.assertEquals((int)2, (int)mock.count);
        Assertions.assertEquals((Object)ClosureUtils.nopClosure(), (Object)ClosureUtils.asClosure(null));
    }

    @Test
    public void testWhileClosure() {
        MockClosure cmd = new MockClosure();
        ClosureUtils.whileClosure((Predicate)FalsePredicate.falsePredicate(), cmd).execute(null);
        Assertions.assertEquals((int)0, (int)cmd.count);
        cmd = new MockClosure();
        ClosureUtils.whileClosure((Predicate)PredicateUtils.uniquePredicate(), cmd).execute(null);
        Assertions.assertEquals((int)1, (int)cmd.count);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.whileClosure(null, (Closure)ClosureUtils.nopClosure())), () -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.whileClosure((Predicate)FalsePredicate.falsePredicate(), null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ClosureUtils.whileClosure(null, null))});
    }

    static class MockClosure<T>
    implements Closure<T> {
        int count;

        MockClosure() {
        }

        public void execute(T object) {
            ++this.count;
        }

        public void reset() {
            this.count = 0;
        }
    }

    static class MockTransformer<T>
    implements Transformer<T, T> {
        int count;

        MockTransformer() {
        }

        public T transform(T object) {
            ++this.count;
            return object;
        }
    }
}

