/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.collections4.BulkTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractObjectTest
extends BulkTest {
    public static final int COLLECTIONS_MAJOR_VERSION = 4;

    public AbstractObjectTest(String testName) {
        super(testName);
    }

    protected String getCanonicalEmptyCollectionName(Object object) {
        StringBuilder retval = new StringBuilder();
        retval.append("src/test/resources/org/apache/commons/collections4/data/test/");
        String colName = object.getClass().getName();
        colName = colName.substring(colName.lastIndexOf(".") + 1);
        retval.append(colName);
        retval.append(".emptyCollection.version");
        retval.append(this.getCompatibilityVersion());
        retval.append(".obj");
        return retval.toString();
    }

    protected String getCanonicalFullCollectionName(Object object) {
        StringBuilder retval = new StringBuilder();
        retval.append("src/test/resources/org/apache/commons/collections4/data/test/");
        String colName = object.getClass().getName();
        colName = colName.substring(colName.lastIndexOf(".") + 1);
        retval.append(colName);
        retval.append(".fullCollection.version");
        retval.append(this.getCompatibilityVersion());
        retval.append(".obj");
        return retval.toString();
    }

    public String getCompatibilityVersion() {
        return "4";
    }

    public boolean isEqualsCheckable() {
        return true;
    }

    public boolean isTestSerialization() {
        return true;
    }

    public abstract Object makeObject();

    protected Object readExternalFormFromBytes(byte[] b) throws IOException, ClassNotFoundException {
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        return this.readExternalFormFromStream(stream);
    }

    protected Object readExternalFormFromDisk(String path) throws IOException, ClassNotFoundException {
        try (FileInputStream stream = new FileInputStream(path);){
            Object object = this.readExternalFormFromStream(stream);
            return object;
        }
    }

    private Object readExternalFormFromStream(InputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream oStream = new ObjectInputStream(stream);
        return oStream.readObject();
    }

    protected Object serializeDeserialize(Object obj) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(obj);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        Object dest = in.readObject();
        in.close();
        return dest;
    }

    protected boolean skipSerializedCanonicalTests() {
        return Boolean.getBoolean("org.apache.commons.collections:with-clover");
    }

    public boolean supportsEmptyCollections() {
        return true;
    }

    public boolean supportsFullCollections() {
        return true;
    }

    @Test
    public void testCanonicalEmptyCollectionExists() {
        Object object;
        if (this.supportsEmptyCollections() && this.isTestSerialization() && !this.skipSerializedCanonicalTests() && (object = this.makeObject()) instanceof Serializable) {
            String name = this.getCanonicalEmptyCollectionName(object);
            Assertions.assertTrue((boolean)new File(name).exists(), (String)("Canonical empty collection (" + name + ") is not in SCM"));
        }
    }

    @Test
    public void testCanonicalFullCollectionExists() {
        Object object;
        if (this.supportsFullCollections() && this.isTestSerialization() && !this.skipSerializedCanonicalTests() && (object = this.makeObject()) instanceof Serializable) {
            String name = this.getCanonicalFullCollectionName(object);
            Assertions.assertTrue((boolean)new File(name).exists(), (String)("Canonical full collection (" + name + ") is not in SCM"));
        }
    }

    @Test
    public void testEqualsNull() {
        Object obj = this.makeObject();
        Assertions.assertFalse((boolean)obj.equals(null));
    }

    @Test
    public void testObjectEqualsSelf() {
        Object obj = this.makeObject();
        Assertions.assertEquals((Object)obj, (Object)obj, (String)"A Object should equal itself");
    }

    @Test
    public void testObjectHashCodeEqualsContract() {
        Object obj2;
        Object obj1 = this.makeObject();
        if (obj1.equals(obj1)) {
            Assertions.assertEquals((int)obj1.hashCode(), (int)obj1.hashCode(), (String)"[1] When two objects are equal, their hashCodes should be also.");
        }
        if (obj1.equals(obj2 = this.makeObject())) {
            Assertions.assertEquals((int)obj1.hashCode(), (int)obj2.hashCode(), (String)"[2] When two objects are equal, their hashCodes should be also.");
            Assertions.assertEquals((Object)obj2, (Object)obj1, (String)"When obj1.equals(obj2) is true, then obj2.equals(obj1) should also be true");
        }
    }

    @Test
    public void testObjectHashCodeEqualsSelfHashCode() {
        Object obj = this.makeObject();
        Assertions.assertEquals((int)obj.hashCode(), (int)obj.hashCode(), (String)"hashCode should be repeatable");
    }

    @Test
    public void testSerializeDeserializeThenCompare() throws Exception {
        Object obj = this.makeObject();
        if (obj instanceof Serializable && this.isTestSerialization()) {
            Object dest = this.serializeDeserialize(obj);
            if (this.isEqualsCheckable()) {
                Assertions.assertEquals((Object)obj, (Object)dest, (String)"obj != deserialize(serialize(obj))");
            }
        }
    }

    @Test
    public void testSimpleSerialization() throws Exception {
        Object o = this.makeObject();
        if (o instanceof Serializable && this.isTestSerialization()) {
            byte[] object = this.writeExternalFormToBytes((Serializable)o);
            this.readExternalFormFromBytes(object);
        }
    }

    protected byte[] writeExternalFormToBytes(Serializable o) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        this.writeExternalFormToStream(o, byteStream);
        return byteStream.toByteArray();
    }

    protected void writeExternalFormToDisk(Serializable o, String path) throws IOException {
        try (FileOutputStream fileStream = new FileOutputStream(path);){
            this.writeExternalFormToStream(o, fileStream);
        }
    }

    private void writeExternalFormToStream(Serializable o, OutputStream stream) throws IOException {
        ObjectOutputStream oStream = new ObjectOutputStream(stream);
        oStream.writeObject(o);
    }
}

