/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.CompositeMap;
import org.apache.commons.collections4.map.EmptyMapMutator;

public class CompositeMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    private boolean pass = false;

    public CompositeMapTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.pass = false;
    }

    @Override
    public CompositeMap<K, V> makeObject() {
        CompositeMap map = new CompositeMap();
        map.addComposited(new HashMap());
        map.setMutator(new EmptyMapMutator());
        return map;
    }

    private Map<K, V> buildOne() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "one");
        map.put("2", "two");
        return map;
    }

    public Map<K, V> buildTwo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("3", "three");
        map.put("4", "four");
        return map;
    }

    public void testGet() {
        CompositeMap map = new CompositeMap(this.buildOne(), this.buildTwo());
        CompositeMapTest.assertEquals((Object)"one", (Object)map.get((Object)"1"));
        CompositeMapTest.assertEquals((Object)"four", (Object)map.get((Object)"4"));
    }

    public void testAddComposited() {
        CompositeMap map = new CompositeMap(this.buildOne(), this.buildTwo());
        HashMap<String, String> three = new HashMap<String, String>();
        three.put("5", "five");
        map.addComposited(null);
        map.addComposited(three);
        CompositeMapTest.assertTrue((boolean)map.containsKey((Object)"5"));
        try {
            map.addComposited(three);
            CompositeMapTest.fail((String)"Expecting IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveComposited() {
        CompositeMap map = new CompositeMap(this.buildOne(), this.buildTwo());
        HashMap<String, String> three = new HashMap<String, String>();
        three.put("5", "five");
        map.addComposited(null);
        map.addComposited(three);
        CompositeMapTest.assertTrue((boolean)map.containsKey((Object)"5"));
        map.removeComposited(three);
        CompositeMapTest.assertFalse((boolean)map.containsKey((Object)"5"));
        map.removeComposited(this.buildOne());
        CompositeMapTest.assertFalse((boolean)map.containsKey((Object)"2"));
    }

    public void testRemoveFromUnderlying() {
        CompositeMap map = new CompositeMap(this.buildOne(), this.buildTwo());
        HashMap<String, String> three = new HashMap<String, String>();
        three.put("5", "five");
        map.addComposited(null);
        map.addComposited(three);
        CompositeMapTest.assertTrue((boolean)map.containsKey((Object)"5"));
        three.remove("5");
        CompositeMapTest.assertFalse((boolean)map.containsKey((Object)"5"));
    }

    public void testRemoveFromComposited() {
        CompositeMap map = new CompositeMap(this.buildOne(), this.buildTwo());
        HashMap<String, String> three = new HashMap<String, String>();
        three.put("5", "five");
        map.addComposited(null);
        map.addComposited(three);
        CompositeMapTest.assertTrue((boolean)map.containsKey((Object)"5"));
        map.remove((Object)"5");
        CompositeMapTest.assertFalse((boolean)three.containsKey("5"));
    }

    public void testResolveCollision() {
        CompositeMap map = new CompositeMap(this.buildOne(), this.buildTwo(), new CompositeMap.MapMutator<K, V>(){
            private static final long serialVersionUID = 1L;

            public void resolveCollision(CompositeMap<K, V> composite, Map<K, V> existing, Map<K, V> added, Collection<K> intersect) {
                CompositeMapTest.this.pass = true;
            }

            public V put(CompositeMap<K, V> map, Map<K, V>[] composited, K key, V value) {
                throw new UnsupportedOperationException();
            }

            public void putAll(CompositeMap<K, V> map, Map<K, V>[] composited, Map<? extends K, ? extends V> t) {
                throw new UnsupportedOperationException();
            }
        });
        map.addComposited(this.buildOne());
        CompositeMapTest.assertTrue((boolean)this.pass);
    }

    public void testPut() {
        CompositeMap map = new CompositeMap(this.buildOne(), this.buildTwo(), new CompositeMap.MapMutator<K, V>(){
            private static final long serialVersionUID = 1L;

            public void resolveCollision(CompositeMap<K, V> composite, Map<K, V> existing, Map<K, V> added, Collection<K> intersect) {
                throw new UnsupportedOperationException();
            }

            public V put(CompositeMap<K, V> map, Map<K, V>[] composited, K key, V value) {
                CompositeMapTest.this.pass = true;
                return "foo";
            }

            public void putAll(CompositeMap<K, V> map, Map<K, V>[] composited, Map<? extends K, ? extends V> t) {
                throw new UnsupportedOperationException();
            }
        });
        map.put((Object)"willy", (Object)"wonka");
        CompositeMapTest.assertTrue((boolean)this.pass);
    }

    public void testPutAll() {
        CompositeMap map = new CompositeMap(this.buildOne(), this.buildTwo(), new CompositeMap.MapMutator<K, V>(){
            private static final long serialVersionUID = 1L;

            public void resolveCollision(CompositeMap<K, V> composite, Map<K, V> existing, Map<K, V> added, Collection<K> intersect) {
                throw new UnsupportedOperationException();
            }

            public V put(CompositeMap<K, V> map, Map<K, V>[] composited, K key, V value) {
                throw new UnsupportedOperationException();
            }

            public void putAll(CompositeMap<K, V> map, Map<K, V>[] composited, Map<? extends K, ? extends V> t) {
                CompositeMapTest.this.pass = true;
            }
        });
        map.putAll(null);
        CompositeMapTest.assertTrue((boolean)this.pass);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

