/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.LazyIteratorChain;

public class LazyIteratorChainTest
extends AbstractIteratorTest<String> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    protected List<String> list1 = null;
    protected List<String> list2 = null;
    protected List<String> list3 = null;

    public LazyIteratorChainTest(String testName) {
        super(testName);
    }

    public void setUp() {
        this.list1 = new ArrayList<String>();
        this.list1.add("One");
        this.list1.add("Two");
        this.list1.add("Three");
        this.list2 = new ArrayList<String>();
        this.list2.add("Four");
        this.list3 = new ArrayList<String>();
        this.list3.add("Five");
        this.list3.add("Six");
    }

    @Override
    public LazyIteratorChain<String> makeEmptyIterator() {
        return new LazyIteratorChain<String>(){

            protected Iterator<String> nextIterator(int count) {
                return null;
            }
        };
    }

    @Override
    public LazyIteratorChain<String> makeObject() {
        LazyIteratorChain<String> chain = new LazyIteratorChain<String>(){

            protected Iterator<String> nextIterator(int count) {
                switch (count) {
                    case 1: {
                        return LazyIteratorChainTest.this.list1.iterator();
                    }
                    case 2: {
                        return LazyIteratorChainTest.this.list2.iterator();
                    }
                    case 3: {
                        return LazyIteratorChainTest.this.list3.iterator();
                    }
                }
                return null;
            }
        };
        return chain;
    }

    public void testIterator() {
        LazyIteratorChain<String> iter = this.makeObject();
        for (String testValue : this.testArray) {
            Object iterValue = iter.next();
            LazyIteratorChainTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
        LazyIteratorChainTest.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            LazyIteratorChainTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testRemoveFromFilteredIterator() {
        Predicate<Integer> myPredicate = new Predicate<Integer>(){

            public boolean evaluate(Integer i) {
                return i.compareTo(4) < 0;
            }
        };
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        list1.add(1);
        list1.add(2);
        list2.add(3);
        list2.add(4);
        Iterator it1 = IteratorUtils.filteredIterator(list1.iterator(), (Predicate)myPredicate);
        Iterator it2 = IteratorUtils.filteredIterator(list2.iterator(), (Predicate)myPredicate);
        Iterator it = IteratorUtils.chainedIterator((Iterator)it1, (Iterator)it2);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        LazyIteratorChainTest.assertEquals((int)0, (int)list1.size());
        LazyIteratorChainTest.assertEquals((int)1, (int)list2.size());
    }

    @Override
    public void testRemove() {
        LazyIteratorChain<String> iter = this.makeObject();
        try {
            iter.remove();
            LazyIteratorChainTest.fail((String)"Calling remove before the first call to next() should throw an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        for (String testValue : this.testArray) {
            String iterValue = (String)iter.next();
            LazyIteratorChainTest.assertEquals((String)"Iteration value is correct", (String)testValue, (String)iterValue);
            if (iterValue.equals("Four")) continue;
            iter.remove();
        }
        LazyIteratorChainTest.assertTrue((String)"List is empty", (this.list1.size() == 0 ? 1 : 0) != 0);
        LazyIteratorChainTest.assertTrue((String)"List is empty", (this.list2.size() == 1 ? 1 : 0) != 0);
        LazyIteratorChainTest.assertTrue((String)"List is empty", (this.list3.size() == 0 ? 1 : 0) != 0);
    }

    public void testFirstIteratorIsEmptyBug() {
        final ArrayList empty = new ArrayList();
        final ArrayList<String> notEmpty = new ArrayList<String>();
        notEmpty.add("A");
        notEmpty.add("B");
        notEmpty.add("C");
        LazyIteratorChain<String> chain = new LazyIteratorChain<String>(){

            protected Iterator<String> nextIterator(int count) {
                switch (count) {
                    case 1: {
                        return empty.iterator();
                    }
                    case 2: {
                        return notEmpty.iterator();
                    }
                }
                return null;
            }
        };
        LazyIteratorChainTest.assertTrue((String)"should have next", (boolean)chain.hasNext());
        LazyIteratorChainTest.assertEquals((String)"A", (String)((String)chain.next()));
        LazyIteratorChainTest.assertTrue((String)"should have next", (boolean)chain.hasNext());
        LazyIteratorChainTest.assertEquals((String)"B", (String)((String)chain.next()));
        LazyIteratorChainTest.assertTrue((String)"should have next", (boolean)chain.hasNext());
        LazyIteratorChainTest.assertEquals((String)"C", (String)((String)chain.next()));
        LazyIteratorChainTest.assertTrue((String)"should not have next", (!chain.hasNext() ? 1 : 0) != 0);
    }

    public void testEmptyChain() {
        LazyIteratorChain<String> chain = this.makeEmptyIterator();
        LazyIteratorChainTest.assertEquals((boolean)false, (boolean)chain.hasNext());
        try {
            chain.next();
            LazyIteratorChainTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            chain.remove();
            LazyIteratorChainTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

