/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.IterableSortedMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.MultiMap;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.junit.AbstractAvailableLocalesTest;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.map.LazyMap;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.collections4.map.PredicatedMap;
import org.junit.Assert;
import org.junit.Test;

public class MapUtilsTest
extends AbstractAvailableLocalesTest {
    public MapUtilsTest(Locale locale) {
        super(locale);
    }

    public Predicate<Object> getPredicate() {
        return new Predicate<Object>(){

            public boolean evaluate(Object o) {
                return o instanceof String;
            }
        };
    }

    @Test
    public void testPredicatedMap() {
        Predicate<Object> p = this.getPredicate();
        IterableMap map = MapUtils.predicatedMap(new HashMap(), p, p);
        Assert.assertTrue((String)"returned object should be a PredicatedMap", (boolean)(map instanceof PredicatedMap));
        try {
            MapUtils.predicatedMap(null, p, p);
            Assert.fail((String)"Expecting NullPointerException for null map.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testLazyMapFactory() {
        Factory factory = FactoryUtils.constantFactory((Object)5);
        IterableMap map = MapUtils.lazyMap(new HashMap(), (Factory)factory);
        Assert.assertTrue((boolean)(map instanceof LazyMap));
        try {
            map = MapUtils.lazyMap(new HashMap(), (Factory)null);
            Assert.fail((String)"Expecting NullPointerException for null factory");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            map = MapUtils.lazyMap((Map)null, (Factory)factory);
            Assert.fail((String)"Expecting NullPointerException for null map");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Transformer transformer = TransformerUtils.asTransformer((Factory)factory);
        map = MapUtils.lazyMap(new HashMap(), (Transformer)transformer);
        Assert.assertTrue((boolean)(map instanceof LazyMap));
        try {
            map = MapUtils.lazyMap(new HashMap(), (Transformer)null);
            Assert.fail((String)"Expecting NullPointerException for null transformer");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            map = MapUtils.lazyMap((Map)null, (Transformer)transformer);
            Assert.fail((String)"Expecting NullPointerException for null map");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testLazyMapTransformer() {
        IterableMap map = MapUtils.lazyMap(new HashMap(), (Transformer)new Transformer<Object, Object>(){

            public Object transform(Object mapKey) {
                if (mapKey instanceof String) {
                    return Integer.valueOf((String)mapKey);
                }
                return null;
            }
        });
        Assert.assertEquals((long)0L, (long)map.size());
        Integer i1 = (Integer)map.get("5");
        Assert.assertEquals((Object)5, (Object)i1);
        Assert.assertEquals((long)1L, (long)map.size());
        Integer i2 = (Integer)map.get(new String(new char[]{'5'}));
        Assert.assertEquals((Object)5, (Object)i2);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertSame((Object)i1, (Object)i2);
    }

    @Test
    public void testInvertMap() {
        HashMap<String, String> in = new HashMap<String, String>(5, 1.0f);
        in.put("1", "A");
        in.put("2", "B");
        in.put("3", "C");
        in.put("4", "D");
        in.put("5", "E");
        HashSet inKeySet = new HashSet(in.keySet());
        HashSet inValSet = new HashSet(in.values());
        Map out = MapUtils.invertMap(in);
        HashSet outKeySet = new HashSet(out.keySet());
        HashSet outValSet = new HashSet(out.values());
        Assert.assertTrue((boolean)inKeySet.equals(outValSet));
        Assert.assertTrue((boolean)inValSet.equals(outKeySet));
        Assert.assertEquals((Object)"1", out.get("A"));
        Assert.assertEquals((Object)"2", out.get("B"));
        Assert.assertEquals((Object)"3", out.get("C"));
        Assert.assertEquals((Object)"4", out.get("D"));
        Assert.assertEquals((Object)"5", out.get("E"));
    }

    @Test
    public void testPutAll_Map_array() {
        try {
            MapUtils.putAll(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MapUtils.putAll(null, (Object[])new Object[0]);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Map test = MapUtils.putAll(new HashMap(), (Object[])new String[0]);
        Assert.assertEquals((long)0L, (long)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, {"GREEN", "#00FF00"}, {"BLUE", "#0000FF"}});
        Assert.assertEquals((Object)true, (Object)test.containsKey("RED"));
        Assert.assertEquals((Object)"#FF0000", test.get("RED"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("GREEN"));
        Assert.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("BLUE"));
        Assert.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assert.assertEquals((long)3L, (long)test.size());
        try {
            MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, null, {"BLUE", "#0000FF"}});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, {"GREEN"}, {"BLUE", "#0000FF"}});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, new String[0], {"BLUE", "#0000FF"}});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        test = MapUtils.putAll(new HashMap(), (Object[])new String[]{"RED", "#FF0000", "GREEN", "#00FF00", "BLUE", "#0000FF"});
        Assert.assertEquals((Object)true, (Object)test.containsKey("RED"));
        Assert.assertEquals((Object)"#FF0000", test.get("RED"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("GREEN"));
        Assert.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("BLUE"));
        Assert.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assert.assertEquals((long)3L, (long)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new String[]{"RED", "#FF0000", "GREEN", "#00FF00", "BLUE", "#0000FF", "PURPLE"});
        Assert.assertEquals((Object)true, (Object)test.containsKey("RED"));
        Assert.assertEquals((Object)"#FF0000", test.get("RED"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("GREEN"));
        Assert.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("BLUE"));
        Assert.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assert.assertEquals((long)3L, (long)test.size());
        test = MapUtils.putAll(new HashMap(), null);
        Assert.assertEquals((long)0L, (long)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new Object[]{new DefaultMapEntry((Object)"RED", (Object)"#FF0000"), new DefaultMapEntry((Object)"GREEN", (Object)"#00FF00"), new DefaultMapEntry((Object)"BLUE", (Object)"#0000FF")});
        Assert.assertEquals((Object)true, (Object)test.containsKey("RED"));
        Assert.assertEquals((Object)"#FF0000", test.get("RED"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("GREEN"));
        Assert.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("BLUE"));
        Assert.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assert.assertEquals((long)3L, (long)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new Object[]{new DefaultKeyValue((Object)"RED", (Object)"#FF0000"), new DefaultKeyValue((Object)"GREEN", (Object)"#00FF00"), new DefaultKeyValue((Object)"BLUE", (Object)"#0000FF")});
        Assert.assertEquals((Object)true, (Object)test.containsKey("RED"));
        Assert.assertEquals((Object)"#FF0000", test.get("RED"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("GREEN"));
        Assert.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("BLUE"));
        Assert.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assert.assertEquals((long)3L, (long)test.size());
    }

    @Test
    public void testConvertResourceBundle() {
        final HashMap<String, String> in = new HashMap<String, String>(5, 1.0f);
        in.put("1", "A");
        in.put("2", "B");
        in.put("3", "C");
        in.put("4", "D");
        in.put("5", "E");
        ListResourceBundle b = new ListResourceBundle(){

            @Override
            public Object[][] getContents() {
                Object[][] contents = new Object[in.size()][2];
                Iterator i = in.keySet().iterator();
                int n = 0;
                while (i.hasNext()) {
                    Object key = i.next();
                    Object val = in.get(key);
                    contents[n][0] = key;
                    contents[n][1] = val;
                    ++n;
                }
                return contents;
            }
        };
        Map out = MapUtils.toMap((ResourceBundle)b);
        Assert.assertTrue((boolean)in.equals(out));
    }

    @Test
    public void testDebugAndVerbosePrintCasting() {
        HashMap<Integer, String> inner = new HashMap<Integer, String>(2, 1.0f);
        inner.put(2, "B");
        inner.put(3, "C");
        HashMap<Integer, Object> outer = new HashMap<Integer, Object>(2, 1.0f);
        outer.put(0, inner);
        outer.put(1, "A");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        try {
            MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", outer);
        }
        catch (ClassCastException e) {
            Assert.fail((String)"No Casting should be occurring!");
        }
    }

    @Test
    public void testDebugAndVerbosePrintNullMap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        outPrint.println("Print Map = " + String.valueOf(null));
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", null);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, (Object)"Print Map", null);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullLabel() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(2, "B");
        map.put(3, "C");
        map.put(4, null);
        outPrint.println("{");
        outPrint.println("    2 = B");
        outPrint.println("    3 = C");
        outPrint.println("    4 = null");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullLabel() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(2, "B");
        map.put(3, "C");
        map.put(4, null);
        outPrint.println("{");
        outPrint.println("    2 = B " + String.class.getName());
        outPrint.println("    3 = C " + String.class.getName());
        outPrint.println("    4 = null");
        outPrint.println("} " + TreeMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullLabelAndMap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        outPrint.println("null");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, null);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullLabelAndMap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        outPrint.println("null");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, null);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullStream() {
        try {
            MapUtils.verbosePrint(null, (Object)"Map", new HashMap());
            Assert.fail((String)"Should generate NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testDebugPrintNullStream() {
        try {
            MapUtils.debugPrint(null, (Object)"Map", new HashMap());
            Assert.fail((String)"Should generate NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testDebugPrintNullKey() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "A");
        outPrint.println("{");
        outPrint.println("    null = A " + String.class.getName());
        outPrint.println("} " + HashMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullKey() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "A");
        outPrint.println("{");
        outPrint.println("    null = A");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullKeyToMap1() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        map.put(null, map);
        outPrint.println("{");
        outPrint.println("    null = (this Map) " + HashMap.class.getName());
        outPrint.println("} " + HashMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullKeyToMap1() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        map.put(null, map);
        outPrint.println("{");
        outPrint.println("    null = (this Map)");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullKeyToMap2() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map.put(null, map2);
        map2.put("2", "B");
        outPrint.println("{");
        outPrint.println("    null = ");
        outPrint.println("    {");
        outPrint.println("        2 = B " + String.class.getName());
        outPrint.println("    } " + HashMap.class.getName());
        outPrint.println("} " + HashMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullKeyToMap2() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map.put(null, map2);
        map2.put("2", "B");
        outPrint.println("{");
        outPrint.println("    null = ");
        outPrint.println("    {");
        outPrint.println("        2 = B");
        outPrint.println("    }");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrint() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A");
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B");
        outPrint.println("        3 = C");
        outPrint.println("    }");
        outPrint.println("    7 = (this Map)");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        TreeMap<Integer, String> inner = new TreeMap<Integer, String>();
        inner.put(2, "B");
        inner.put(3, "C");
        TreeMap<Integer, Object> outer = new TreeMap<Integer, Object>();
        outer.put(1, inner);
        outer.put(0, "A");
        outer.put(7, outer);
        MapUtils.verbosePrint((PrintStream)outPrint, (Object)"Print Map", outer);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrint() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A " + String.class.getName());
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B " + String.class.getName());
        outPrint.println("        3 = C " + String.class.getName());
        outPrint.println("    } " + TreeMap.class.getName());
        outPrint.println("    7 = (this Map) " + TreeMap.class.getName());
        outPrint.println("} " + TreeMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        TreeMap<Integer, String> inner = new TreeMap<Integer, String>();
        inner.put(2, "B");
        inner.put(3, "C");
        TreeMap<Integer, Object> outer = new TreeMap<Integer, Object>();
        outer.put(1, inner);
        outer.put(0, "A");
        outer.put(7, outer);
        MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", outer);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintSelfReference() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        TreeMap<Integer, Object> grandfather = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> father = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> son = new TreeMap<Integer, Object>();
        grandfather.put(0, "A");
        grandfather.put(1, father);
        father.put(2, "B");
        father.put(3, grandfather);
        father.put(4, son);
        son.put(5, "C");
        son.put(6, grandfather);
        son.put(7, father);
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A");
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B");
        outPrint.println("        3 = (ancestor[0] Map)");
        outPrint.println("        4 = ");
        outPrint.println("        {");
        outPrint.println("            5 = C");
        outPrint.println("            6 = (ancestor[1] Map)");
        outPrint.println("            7 = (ancestor[0] Map)");
        outPrint.println("        }");
        outPrint.println("    }");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, (Object)"Print Map", grandfather);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintSelfReference() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        TreeMap<Integer, Object> grandfather = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> father = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> son = new TreeMap<Integer, Object>();
        grandfather.put(0, "A");
        grandfather.put(1, father);
        father.put(2, "B");
        father.put(3, grandfather);
        father.put(4, son);
        son.put(5, "C");
        son.put(6, grandfather);
        son.put(7, father);
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A " + String.class.getName());
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B " + String.class.getName());
        outPrint.println("        3 = (ancestor[0] Map) " + TreeMap.class.getName());
        outPrint.println("        4 = ");
        outPrint.println("        {");
        outPrint.println("            5 = C " + String.class.getName());
        outPrint.println("            6 = (ancestor[1] Map) " + TreeMap.class.getName());
        outPrint.println("            7 = (ancestor[0] Map) " + TreeMap.class.getName());
        outPrint.println("        } " + TreeMap.class.getName());
        outPrint.println("    } " + TreeMap.class.getName());
        outPrint.println("} " + TreeMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", grandfather);
        Assert.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testEmptyIfNull() {
        Assert.assertTrue((boolean)MapUtils.emptyIfNull(null).isEmpty());
        HashMap map = new HashMap();
        Assert.assertSame(map, (Object)MapUtils.emptyIfNull(map));
    }

    @Test
    public void testIsEmptyWithEmptyMap() {
        HashMap map = new HashMap();
        Assert.assertEquals((Object)true, (Object)MapUtils.isEmpty(map));
    }

    @Test
    public void testIsEmptyWithNonEmptyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("item", "value");
        Assert.assertEquals((Object)false, (Object)MapUtils.isEmpty(map));
    }

    @Test
    public void testIsEmptyWithNull() {
        Map map = null;
        Assert.assertEquals((Object)true, (Object)MapUtils.isEmpty(map));
    }

    @Test
    public void testIsNotEmptyWithEmptyMap() {
        HashMap map = new HashMap();
        Assert.assertEquals((Object)false, (Object)MapUtils.isNotEmpty(map));
    }

    @Test
    public void testIsNotEmptyWithNonEmptyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("item", "value");
        Assert.assertEquals((Object)true, (Object)MapUtils.isNotEmpty(map));
    }

    @Test
    public void testIsNotEmptyWithNull() {
        Map map = null;
        Assert.assertEquals((Object)false, (Object)MapUtils.isNotEmpty(map));
    }

    @Test
    public void testPopulateMap() {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("3");
        list.add("5");
        list.add("7");
        list.add("2");
        list.add("4");
        list.add("6");
        HashMap map = new HashMap();
        MapUtils.populateMap(map, list, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assert.assertEquals((long)list.size(), (long)map.size());
        for (i = 0; i < list.size(); ++i) {
            Assert.assertEquals((Object)true, (Object)map.containsKey(Integer.valueOf((String)list.get(i))));
            Assert.assertEquals((Object)false, (Object)map.containsKey(list.get(i)));
            Assert.assertEquals((Object)true, (Object)map.containsValue(list.get(i)));
            Assert.assertEquals(list.get(i), map.get(Integer.valueOf((String)list.get(i))));
        }
        map = new HashMap();
        MapUtils.populateMap(map, list, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assert.assertEquals((long)list.size(), (long)map.size());
        for (i = 0; i < list.size(); ++i) {
            Assert.assertEquals((Object)true, (Object)map.containsKey(Integer.valueOf((String)list.get(i))));
            Assert.assertEquals((Object)false, (Object)map.containsKey(list.get(i)));
            Assert.assertEquals((Object)true, (Object)map.containsValue(Integer.valueOf((String)list.get(i))));
            Assert.assertEquals((Object)Integer.valueOf((String)list.get(i)), map.get(Integer.valueOf((String)list.get(i))));
        }
    }

    @Test
    public void testPopulateMultiMap() {
        ArrayList<X> list = new ArrayList<X>();
        list.add(new X(1, "x1"));
        list.add(new X(2, "x2"));
        list.add(new X(2, "x3"));
        list.add(new X(5, "x4"));
        list.add(new X(5, "x5"));
        MultiValueMap map = MultiValueMap.multiValueMap(new TreeMap());
        MapUtils.populateMap((MultiMap)map, list, (Transformer)new Transformer<X, Integer>(){

            public Integer transform(X input) {
                return input.key;
            }
        }, (Transformer)TransformerUtils.nopTransformer());
        Assert.assertEquals((long)list.size(), (long)map.totalSize());
        for (int i = 0; i < list.size(); ++i) {
            Assert.assertEquals((Object)true, (Object)map.containsKey((Object)((X)list.get((int)i)).key));
            Assert.assertEquals((Object)true, (Object)map.containsValue(list.get(i)));
        }
    }

    @Test
    public void testIterableMap() {
        try {
            MapUtils.iterableMap(null);
            Assert.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "foov");
        map.put("bar", "barv");
        map.put("baz", "bazv");
        IterableMap iMap = MapUtils.iterableMap(map);
        Assert.assertEquals(map, (Object)iMap);
        Assert.assertNotSame(map, (Object)iMap);
        HashedMap hMap = new HashedMap(map);
        Assert.assertSame((Object)hMap, (Object)MapUtils.iterableMap((Map)hMap));
    }

    @Test
    public void testIterableSortedMap() {
        try {
            MapUtils.iterableSortedMap(null);
            Assert.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("foo", "foov");
        map.put("bar", "barv");
        map.put("baz", "bazv");
        IterableSortedMap iMap = MapUtils.iterableSortedMap(map);
        Assert.assertEquals(map, (Object)iMap);
        Assert.assertNotSame(map, (Object)iMap);
        Assert.assertSame((Object)iMap, (Object)MapUtils.iterableMap((Map)iMap));
    }

    @Test
    public void testSize0() {
        Assert.assertEquals((long)0L, (long)MapUtils.size(new HashMap()));
    }

    @Test
    public void testSizeNull() {
        Assert.assertEquals((long)0L, (long)MapUtils.size(null));
    }

    @Test
    public void testSize() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "1");
        map.put("B", "2");
        Assert.assertEquals((long)2L, (long)MapUtils.size(map));
    }

    @Test
    public void testToProperties() {
        HashMap<String, String> in = new HashMap<String, String>();
        in.put("key1", "A");
        in.put("key2", "B");
        in.put("key3", "C");
        Properties out = MapUtils.toProperties(in);
        Assert.assertEquals(in.get("key1"), (Object)out.get("key1"));
        Assert.assertEquals(in.get("key2"), (Object)out.get("key2"));
        Assert.assertEquals(in.get("key3"), (Object)out.get("key3"));
    }

    @Test
    public void testToPropertiesEmpty() {
        Map in = null;
        Properties out = MapUtils.toProperties(in);
        Assert.assertEquals((long)out.size(), (long)0L);
    }

    @Test
    public void testgetDoubleValue() {
        HashMap<String, Double> in = new HashMap<String, Double>();
        in.put("key", 2.0);
        Assert.assertEquals((double)2.0, (double)MapUtils.getDoubleValue(in, (Object)"key", (double)0.0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)MapUtils.getDoubleValue(in, (Object)"key"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)MapUtils.getDoubleValue(in, (Object)"noKey", (double)1.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)MapUtils.getDoubleValue(in, (Object)"noKey"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)MapUtils.getDouble(in, (Object)"key", (Double)0.0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)MapUtils.getDouble(in, (Object)"noKey", (Double)1.0), (double)0.0);
        HashMap<String, String> inStr = new HashMap<String, String>();
        char decimalSeparator = this.getDecimalSeparator();
        inStr.put("str1", "2" + decimalSeparator + "0");
        Assert.assertEquals((double)MapUtils.getDoubleValue(inStr, (Object)"str1", (double)0.0), (double)2.0, (double)0.0);
    }

    @Test
    public void testgetFloatValue() {
        HashMap<String, Float> in = new HashMap<String, Float>();
        in.put("key", Float.valueOf(2.0f));
        Assert.assertEquals((double)2.0, (double)MapUtils.getFloatValue(in, (Object)"key", (float)0.0f), (double)0.0);
        Assert.assertEquals((double)2.0, (double)MapUtils.getFloatValue(in, (Object)"key"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)MapUtils.getFloatValue(in, (Object)"noKey", (float)1.0f), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)MapUtils.getFloatValue(in, (Object)"noKey"), (float)0.0f);
        Assert.assertEquals((double)2.0, (double)MapUtils.getFloat(in, (Object)"key", (Float)Float.valueOf(0.0f)).floatValue(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)MapUtils.getFloat(in, (Object)"noKey", (Float)Float.valueOf(1.0f)).floatValue(), (double)0.0);
        HashMap<String, String> inStr = new HashMap<String, String>();
        char decimalSeparator = this.getDecimalSeparator();
        inStr.put("str1", "2" + decimalSeparator + "0");
        Assert.assertEquals((double)MapUtils.getFloatValue(inStr, (Object)"str1", (float)0.0f), (double)2.0, (double)0.0);
    }

    @Test
    public void testgetLongValue() {
        HashMap<String, Long> in = new HashMap<String, Long>();
        in.put("key", 2L);
        Assert.assertEquals((double)2.0, (double)MapUtils.getLongValue(in, (Object)"key", (long)0L), (double)0.0);
        Assert.assertEquals((double)2.0, (double)MapUtils.getLongValue(in, (Object)"key"), (double)0.0);
        Assert.assertEquals((float)1.0f, (float)MapUtils.getLongValue(in, (Object)"noKey", (long)1L), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)MapUtils.getLongValue(in, (Object)"noKey"), (float)0.0f);
        Assert.assertEquals((double)2.0, (double)MapUtils.getLong(in, (Object)"key", (Long)0L).longValue(), (double)0.0);
        Assert.assertEquals((float)1.0f, (float)MapUtils.getLong(in, (Object)"noKey", (Long)1L).longValue(), (float)0.0f);
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "2");
        Assert.assertEquals((float)MapUtils.getLongValue(inStr, (Object)"str1", (long)0L), (float)2.0f, (float)0.0f);
        Assert.assertEquals((float)MapUtils.getLong(inStr, (Object)"str1", (Long)1L).longValue(), (float)2.0f, (float)0.0f);
    }

    @Test
    public void testgetIntValue() {
        HashMap<String, Integer> in = new HashMap<String, Integer>();
        in.put("key", 2);
        Assert.assertEquals((float)2.0f, (float)MapUtils.getIntValue(in, (Object)"key", (int)0), (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)MapUtils.getIntValue(in, (Object)"key"), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)MapUtils.getIntValue(in, (Object)"noKey", (int)0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)MapUtils.getIntValue(in, (Object)"noKey"), (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)MapUtils.getInteger(in, (Object)"key", (Integer)0).intValue(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)MapUtils.getInteger(in, (Object)"noKey", (Integer)0).intValue(), (float)0.0f);
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "2");
        Assert.assertEquals((float)MapUtils.getIntValue(inStr, (Object)"str1", (int)0), (float)2.0f, (float)0.0f);
    }

    @Test
    public void testgetShortValue() {
        HashMap<String, Short> in = new HashMap<String, Short>();
        int val = 10;
        in.put("key", (short)10);
        Assert.assertEquals((float)10.0f, (float)MapUtils.getShortValue(in, (Object)"key", (short)10), (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)MapUtils.getShortValue(in, (Object)"key"), (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)MapUtils.getShortValue(in, (Object)"noKey", (short)10), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)MapUtils.getShortValue(in, (Object)"noKey"), (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)MapUtils.getShort(in, (Object)"key", (Short)10).shortValue(), (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)MapUtils.getShort(in, (Object)"noKey", (Short)10).shortValue(), (float)0.0f);
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "10");
        Assert.assertEquals((float)MapUtils.getShortValue(inStr, (Object)"str1", (short)10), (float)10.0f, (float)0.0f);
    }

    @Test
    public void testgetByteValue() {
        HashMap<String, Byte> in = new HashMap<String, Byte>();
        int val = 100;
        in.put("key", (byte)100);
        Assert.assertEquals((float)100.0f, (float)MapUtils.getByteValue(in, (Object)"key", (byte)100), (float)0.0f);
        Assert.assertEquals((float)100.0f, (float)MapUtils.getByteValue(in, (Object)"key"), (float)0.0f);
        Assert.assertEquals((float)100.0f, (float)MapUtils.getByteValue(in, (Object)"noKey", (byte)100), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)MapUtils.getByteValue(in, (Object)"noKey"), (float)0.0f);
        Assert.assertEquals((float)100.0f, (float)MapUtils.getByte(in, (Object)"key", (Byte)100).byteValue(), (float)0.0f);
        Assert.assertEquals((float)100.0f, (float)MapUtils.getByte(in, (Object)"noKey", (Byte)100).byteValue(), (float)0.0f);
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "100");
        Assert.assertEquals((float)MapUtils.getByteValue(inStr, (Object)"str1", (byte)100), (float)100.0f, (float)0.0f);
    }

    @Test
    public void testgetNumber() {
        HashMap<String, Integer> in = new HashMap<String, Integer>();
        Integer val = 1000;
        in.put("key", val);
        Assert.assertEquals((float)((Number)val).intValue(), (float)MapUtils.getNumber(in, (Object)"key", (Number)val).intValue(), (float)0.0f);
        Assert.assertEquals((float)((Number)val).intValue(), (float)MapUtils.getNumber(in, (Object)"noKey", (Number)val).intValue(), (float)0.0f);
    }

    @Test
    public void testgetString() {
        HashMap<String, String> in = new HashMap<String, String>();
        in.put("key", "str");
        Assert.assertEquals((Object)"str", (Object)MapUtils.getString(in, (Object)"key", (String)"defualt"));
        Assert.assertEquals((Object)"str", (Object)MapUtils.getString(in, (Object)"key"));
        Assert.assertEquals(null, (Object)MapUtils.getString(null, (Object)"key"));
        Assert.assertEquals((Object)"default", (Object)MapUtils.getString(in, (Object)"noKey", (String)"default"));
        Assert.assertEquals((Object)"default", (Object)MapUtils.getString(null, (Object)"noKey", (String)"default"));
    }

    @Test
    public void testgetObject() {
        HashMap<String, String> in = new HashMap<String, String>();
        in.put("key", "str");
        Assert.assertEquals((Object)"str", (Object)MapUtils.getObject(in, (Object)"key", (Object)"defualt"));
        Assert.assertEquals((Object)"str", (Object)MapUtils.getObject(in, (Object)"key"));
        Assert.assertEquals(null, (Object[])((Object[])MapUtils.getObject(null, (Object)"key")));
        Assert.assertEquals((Object)"default", (Object)MapUtils.getObject(in, (Object)"noKey", (Object)"default"));
        Assert.assertEquals((Object)"default", (Object)MapUtils.getObject(null, (Object)"noKey", (Object)"default"));
    }

    @Test
    public void testgetBooleanValue() {
        HashMap<String, Boolean> in = new HashMap<String, Boolean>();
        in.put("key", true);
        Assert.assertTrue((boolean)MapUtils.getBooleanValue(in, (Object)"key", (boolean)true));
        Assert.assertTrue((boolean)MapUtils.getBooleanValue(in, (Object)"key"));
        Assert.assertTrue((boolean)MapUtils.getBooleanValue(in, (Object)"noKey", (boolean)true));
        Assert.assertTrue((!MapUtils.getBooleanValue(in, (Object)"noKey") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)MapUtils.getBoolean(in, (Object)"key", (Boolean)true));
        Assert.assertTrue((boolean)MapUtils.getBoolean(in, (Object)"noKey", (Boolean)true));
        Assert.assertEquals(null, (Object)MapUtils.getBoolean(null, (Object)"noKey"));
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "true");
        Assert.assertTrue((boolean)MapUtils.getBooleanValue(inStr, (Object)"str1", (boolean)true));
        Assert.assertTrue((boolean)MapUtils.getBoolean(inStr, (Object)"str1", (Boolean)true));
    }

    @Test
    public void testgetMap() {
        HashMap in = new HashMap();
        HashMap<String, String> valMap = new HashMap<String, String>();
        valMap.put("key1", "value1");
        in.put("key1", valMap);
        Map outValue = MapUtils.getMap(in, (Object)"key1", null);
        Assert.assertEquals((Object)"value1", outValue.get("key1"));
        Assert.assertEquals(null, outValue.get("key2"));
        Assert.assertEquals(null, (Object)MapUtils.getMap(in, (Object)"key2", null));
        Assert.assertEquals(null, (Object)MapUtils.getMap(null, (Object)"key2", null));
    }

    @Test
    public void testSafeAddToMap() {
        HashMap inMap = new HashMap();
        MapUtils.safeAddToMap(inMap, (Object)"key1", (Object)"value1");
        MapUtils.safeAddToMap(inMap, (Object)"key2", null);
        Assert.assertEquals((Object)"value1", inMap.get("key1"));
        Assert.assertEquals((Object)"", inMap.get("key2"));
    }

    @Test
    public void testOrderedMap() {
        HashMap<String, String> inMap = new HashMap<String, String>();
        inMap.put("key1", "value1");
        inMap.put("key2", "value2");
        OrderedMap map = MapUtils.orderedMap(inMap);
        Assert.assertTrue((String)"returned object should be a OrderedMap", (boolean)(map instanceof OrderedMap));
    }

    private char getDecimalSeparator() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            return ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator();
        }
        return '.';
    }

    public static class X
    implements Comparable<X> {
        int key;
        String name;

        public X(int key, String name) {
            this.key = key;
            this.name = name;
        }

        @Override
        public int compareTo(X o) {
            return this.key - o.key | this.name.compareTo(o.name);
        }
    }
}

