/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.trie;

import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Trie;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.commons.collections4.trie.UnmodifiableTrie;

public class UnmodifiableTrieTest<V>
extends AbstractSortedMapTest<String, V> {
    public UnmodifiableTrieTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableTrieTest.class);
    }

    @Override
    public Trie<String, V> makeObject() {
        return UnmodifiableTrie.unmodifiableTrie((Trie)new PatriciaTrie());
    }

    @Override
    public boolean isPutChangeSupported() {
        return false;
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public Trie<String, V> makeFullMap() {
        PatriciaTrie m = new PatriciaTrie();
        this.addSampleMappings(m);
        return UnmodifiableTrie.unmodifiableTrie((Trie)m);
    }

    public void testUnmodifiable() {
        UnmodifiableTrieTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableTrieTest.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        Trie<String, V> trie = this.makeFullMap();
        UnmodifiableTrieTest.assertSame(trie, (Object)UnmodifiableTrie.unmodifiableTrie(trie));
        try {
            UnmodifiableTrie.unmodifiableTrie(null);
            UnmodifiableTrieTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String[] ignoredTests() {
        return null;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

