/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.splitmap;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.util.HashMap;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.NOPTransformer;
import org.apache.commons.collections4.splitmap.TransformedSplitMap;

public class TransformedSplitMapTest
extends BulkTest {
    private final Transformer<Integer, String> intToString = new Transformer<Integer, String>(){

        public String transform(Integer input) {
            return String.valueOf(input);
        }
    };
    private final Transformer<Object, Class<?>> objectToClass = new Transformer<Object, Class<?>>(){

        public Class<?> transform(Object input) {
            return input == null ? null : input.getClass();
        }
    };
    private final Transformer<String, Integer> stringToInt = new Transformer<String, Integer>(){

        public Integer transform(String input) {
            return Integer.valueOf(input);
        }
    };

    public TransformedSplitMapTest(String testName) {
        super(testName);
    }

    public void testTransformedMap() {
        TransformedSplitMap map = TransformedSplitMap.transformingMap(new HashMap(), this.intToString, this.objectToClass);
        Integer[] k = new Integer[]{0, 1, 2, 3, 4, 5, 6};
        Object[] v = new Object[]{"", new Object(), new HashMap(), 0, BigInteger.TEN, null, new Object[0]};
        TransformedSplitMapTest.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < k.length; ++i) {
            map.put((Object)k[i], v[i]);
            TransformedSplitMapTest.assertEquals((int)(i + 1), (int)map.size());
            TransformedSplitMapTest.assertTrue((boolean)map.containsKey(this.intToString.transform((Object)k[i])));
            TransformedSplitMapTest.assertFalse((boolean)map.containsKey((Object)k[i]));
            TransformedSplitMapTest.assertTrue((boolean)map.containsValue(this.objectToClass.transform(v[i])));
            TransformedSplitMapTest.assertTrue((boolean)(this.objectToClass.transform(v[i]) != v[i] ^ map.containsValue(v[i])));
            TransformedSplitMapTest.assertEquals((Object)this.objectToClass.transform(v[i]), (Object)map.get(this.intToString.transform((Object)k[i])));
        }
        int sz = map.size();
        TransformedSplitMapTest.assertEquals(null, (Object)map.remove((Object)k[0]));
        TransformedSplitMapTest.assertEquals((int)sz, (int)map.size());
        TransformedSplitMapTest.assertEquals((Object)this.objectToClass.transform(v[0]), (Object)map.remove(this.intToString.transform((Object)k[0])));
        TransformedSplitMapTest.assertEquals((int)(--sz), (int)map.size());
        TransformedSplitMap map2 = TransformedSplitMap.transformingMap(new HashMap(), (Transformer)NOPTransformer.nopTransformer(), this.stringToInt);
        TransformedSplitMapTest.assertEquals((int)0, (int)map2.size());
        for (int i = 0; i < 6; ++i) {
            map2.put((Object)String.valueOf(i), (Object)String.valueOf(i));
            TransformedSplitMapTest.assertEquals((int)(i + 1), (int)map2.size());
            TransformedSplitMapTest.assertTrue((boolean)map2.containsValue((Object)i));
            TransformedSplitMapTest.assertFalse((boolean)map2.containsValue((Object)String.valueOf(i)));
            TransformedSplitMapTest.assertTrue((boolean)map2.containsKey((Object)String.valueOf(i)));
            TransformedSplitMapTest.assertEquals((int)i, (int)((Integer)map2.get((Object)String.valueOf(i))));
        }
        int sz2 = map2.size();
        TransformedSplitMapTest.assertEquals((Object)0, (Object)map2.remove((Object)"0"));
        TransformedSplitMapTest.assertEquals((int)(--sz2), (int)map2.size());
    }

    public void testMapIterator() {
        TransformedSplitMap map = TransformedSplitMap.transformingMap(new HashMap(), (Transformer)NOPTransformer.nopTransformer(), this.stringToInt);
        TransformedSplitMapTest.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < 6; ++i) {
            map.put((Object)String.valueOf(i), (Object)String.valueOf(i));
        }
        MapIterator it = map.mapIterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            TransformedSplitMapTest.assertEquals((String)k, (String)((String)it.getKey()));
            TransformedSplitMapTest.assertEquals((Object)map.get((Object)k), (Object)it.getValue());
        }
    }

    public void testEmptyMap() throws IOException, ClassNotFoundException {
        TransformedSplitMap map = TransformedSplitMap.transformingMap(new HashMap(), (Transformer)NOPTransformer.nopTransformer(), (Transformer)NOPTransformer.nopTransformer());
        ObjectInputStream in = new ObjectInputStream(new FileInputStream("src/test/resources/data/test//TransformedSplitMap.emptyCollection.version4.obj"));
        Object readObject = in.readObject();
        in.close();
        TransformedSplitMap readMap = (TransformedSplitMap)readObject;
        TransformedSplitMapTest.assertTrue((String)"Map should be empty", (readMap.size() == 0 ? 1 : 0) != 0);
        TransformedSplitMapTest.assertEquals((Object)map.entrySet(), (Object)readMap.entrySet());
    }

    public void testFullMap() throws IOException, ClassNotFoundException {
        TransformedSplitMap map = TransformedSplitMap.transformingMap(new HashMap(), (Transformer)NOPTransformer.nopTransformer(), (Transformer)NOPTransformer.nopTransformer());
        map.put((Object)"a", (Object)"b");
        map.put((Object)"c", (Object)"d");
        map.put((Object)"e", (Object)"f");
        map.put((Object)"g", (Object)"h");
        ObjectInputStream in = new ObjectInputStream(new FileInputStream("src/test/resources/data/test/TransformedSplitMap.fullCollection.version4.obj"));
        Object readObject = in.readObject();
        in.close();
        TransformedSplitMap readMap = (TransformedSplitMap)readObject;
        TransformedSplitMapTest.assertFalse((String)"Map should not be empty", (readMap.size() == 0 ? 1 : 0) != 0);
        TransformedSplitMapTest.assertEquals((Object)map.entrySet(), (Object)readMap.entrySet());
    }
}

