/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.set.AbstractNavigableSetTest;
import org.apache.commons.collections4.set.TransformedNavigableSet;
import org.apache.commons.collections4.set.TransformedSet;

public class TransformedNavigableSetTest<E>
extends AbstractNavigableSetTest<E> {
    public TransformedNavigableSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(TransformedNavigableSetTest.class);
    }

    @Override
    public NavigableSet<E> makeObject() {
        return TransformedNavigableSet.transformingNavigableSet(new TreeSet(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Override
    public NavigableSet<E> makeFullCollection() {
        TreeSet set = new TreeSet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return TransformedNavigableSet.transformingNavigableSet(set, TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    public void testTransformedSet() {
        TransformedNavigableSet set = TransformedNavigableSet.transformingNavigableSet(new TreeSet(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedNavigableSetTest.assertEquals((int)0, (int)set.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < els.length; ++i) {
            set.add(els[i]);
            TransformedNavigableSetTest.assertEquals((int)(i + 1), (int)set.size());
            TransformedNavigableSetTest.assertEquals((boolean)true, (boolean)set.contains(Integer.valueOf((String)els[i])));
        }
        TransformedNavigableSetTest.assertEquals((boolean)true, (boolean)set.remove(Integer.valueOf((String)els[0])));
    }

    public void testTransformedSet_decorateTransform() {
        TreeSet originalSet = new TreeSet();
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        Collections.addAll(originalSet, els);
        Set set = TransformedSet.transformedSet(originalSet, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedNavigableSetTest.assertEquals((int)els.length, (int)set.size());
        for (Object el : els) {
            TransformedNavigableSetTest.assertEquals((boolean)true, (boolean)set.contains(Integer.valueOf((String)el)));
        }
        TransformedNavigableSetTest.assertEquals((boolean)true, (boolean)set.remove(Integer.valueOf((String)els[0])));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }
}

