/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.queue.AbstractQueueTest;
import org.apache.commons.collections4.queue.PredicatedQueue;

public class PredicatedQueueTest<E>
extends AbstractQueueTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = new Predicate<E>(){

        public boolean evaluate(E o) {
            return o instanceof String;
        }
    };

    public PredicatedQueueTest(String testName) {
        super(testName);
    }

    protected Queue<E> decorateCollection(Queue<E> queue, Predicate<E> predicate) {
        return PredicatedQueue.predicatedQueue(queue, predicate);
    }

    @Override
    public Queue<E> makeObject() {
        return this.decorateCollection(new LinkedList(), this.truePredicate);
    }

    @Override
    public Queue<E> makeFullCollection() {
        LinkedList queue = new LinkedList();
        queue.addAll(Arrays.asList(this.getFullElements()));
        return this.decorateCollection(queue, this.truePredicate);
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new LinkedList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        LinkedList list = new LinkedList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    public Queue<E> makeTestQueue() {
        return this.decorateCollection(new LinkedList(), this.testPredicate);
    }

    public void testGet() {
        Queue<String> queue = this.makeTestQueue();
        PredicatedQueueTest.assertNull(queue.peek());
        queue.add("one");
        queue.add("two");
        queue.add("three");
        PredicatedQueueTest.assertEquals((String)"Queue get", (Object)"one", queue.peek());
    }

    public void testRemove() {
        Queue<String> queue = this.makeTestQueue();
        queue.add("one");
        PredicatedQueueTest.assertEquals((String)"Queue get", (Object)"one", queue.poll());
        PredicatedQueueTest.assertNull(queue.peek());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

