/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;

public class ReferenceMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    WeakReference<K> keyReference;
    WeakReference<V> valueReference;

    public ReferenceMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(ReferenceMapTest.class);
    }

    @Override
    public ReferenceMap<K, V> makeObject() {
        return new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK);
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public boolean isAllowNullValue() {
        return false;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testNullHandling() {
        this.resetFull();
        ReferenceMapTest.assertEquals(null, this.map.get(null));
        ReferenceMapTest.assertEquals((boolean)false, (boolean)this.map.containsKey(null));
        ReferenceMapTest.assertEquals((boolean)false, (boolean)this.map.containsValue(null));
        ReferenceMapTest.assertEquals(null, this.map.remove(null));
        ReferenceMapTest.assertEquals((boolean)false, (boolean)this.map.entrySet().contains(null));
        ReferenceMapTest.assertEquals((boolean)false, (boolean)this.map.keySet().contains(null));
        ReferenceMapTest.assertEquals((boolean)false, (boolean)this.map.values().contains(null));
        try {
            this.map.put(null, null);
            ReferenceMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.map.put(new Object(), null);
            ReferenceMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.map.put(null, new Object());
            ReferenceMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Map<K, V> buildRefMap() {
        Object key = new Object();
        Object value = new Object();
        this.keyReference = new WeakReference<Object>(key);
        this.valueReference = new WeakReference<Object>(value);
        ReferenceMap testMap = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD, true);
        testMap.put(key, value);
        ReferenceMapTest.assertEquals((String)"In map", (Object)value, testMap.get(key));
        ReferenceMapTest.assertNotNull((String)"Weak reference released early (1)", this.keyReference.get());
        ReferenceMapTest.assertNotNull((String)"Weak reference released early (2)", this.valueReference.get());
        return testMap;
    }

    public void testPurgeValues() throws Exception {
        Map<K, V> testMap = this.buildRefMap();
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                ReferenceMapTest.fail((String)"Max iterations reached before resource released.");
            }
            testMap.isEmpty();
            if (this.keyReference.get() == null && this.valueReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    public void testCustomPurge() {
        ArrayList expiredValues = new ArrayList();
        final Consumer consumer = (Consumer<Integer> & Serializable)v -> expiredValues.add(v);
        ReferenceMap<Integer, Integer> map = new ReferenceMap<Integer, Integer>(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD, false){
            private static final long serialVersionUID = 1L;

            protected AbstractReferenceMap.ReferenceEntry<Integer, Integer> createEntry(AbstractHashedMap.HashEntry<Integer, Integer> next, int hashCode, Integer key, Integer value) {
                return new AccessibleEntry<Integer, Integer>((AbstractReferenceMap<Integer, Integer>)this, next, hashCode, key, value, consumer);
            }
        };
        for (int i = 100000; i < 100010; ++i) {
            map.put(i, i);
        }
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50 || bytz < 0) {
                ReferenceMapTest.fail((String)"Max iterations reached before resource released.");
            }
            map.isEmpty();
            if (!expiredValues.isEmpty()) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
        ReferenceMapTest.assertFalse((String)"Value should be stored", (boolean)expiredValues.isEmpty());
    }

    public void testDataSizeAfterSerialization() throws IOException, ClassNotFoundException {
        ReferenceMap serialiseMap = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK, true);
        serialiseMap.put((Object)"KEY", (Object)"VALUE");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(baos);){
            out.writeObject(serialiseMap);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream in = new ObjectInputStream(bais);){
            ReferenceMap deserialisedMap = (ReferenceMap)in.readObject();
            ReferenceMapTest.assertEquals((int)1, (int)deserialisedMap.size());
            ReferenceMapTest.assertEquals((int)serialiseMap.data.length, (int)deserialisedMap.data.length);
        }
    }

    private static void gc() {
        try {
            byte[][] tooLarge = new byte[1000000000][1000000000];
            ReferenceMapTest.fail((String)"you have too much RAM");
        }
        catch (OutOfMemoryError ex) {
            System.gc();
        }
    }

    private static class AccessibleEntry<K, V>
    extends AbstractReferenceMap.ReferenceEntry<K, V> {
        final AbstractReferenceMap<K, V> parent;
        final Consumer<V> consumer;

        public AccessibleEntry(AbstractReferenceMap<K, V> parent, AbstractHashedMap.HashEntry<K, V> next, int hashCode, K key, V value, Consumer<V> consumer) {
            super(parent, next, hashCode, key, value);
            this.parent = parent;
            this.consumer = consumer;
        }

        protected void onPurge() {
            if (this.parent.isValueType(AbstractReferenceMap.ReferenceStrength.HARD)) {
                this.consumer.accept(this.getValue());
            }
        }
    }
}

