/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;

public abstract class AbstractListIteratorTest<E>
extends AbstractIteratorTest<E> {
    public AbstractListIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public abstract ListIterator<E> makeEmptyIterator();

    @Override
    public abstract ListIterator<E> makeObject();

    public boolean supportsAdd() {
        return true;
    }

    public boolean supportsSet() {
        return true;
    }

    public E addSetValue() {
        return null;
    }

    public void testEmptyListIteratorIsIndeedEmpty() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        Iterator it = this.makeEmptyIterator();
        AbstractListIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        AbstractListIteratorTest.assertEquals((int)0, (int)it.nextIndex());
        AbstractListIteratorTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        AbstractListIteratorTest.assertEquals((int)-1, (int)it.previousIndex());
        try {
            it.next();
            AbstractListIteratorTest.fail((String)"NoSuchElementException must be thrown from empty ListIterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            it.previous();
            AbstractListIteratorTest.fail((String)"NoSuchElementException must be thrown from empty ListIterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testWalkForwardAndBack() {
        ArrayList list = new ArrayList();
        Iterator it = this.makeObject();
        while (it.hasNext()) {
            list.add(it.next());
        }
        AbstractListIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        AbstractListIteratorTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
        try {
            it.next();
            AbstractListIteratorTest.fail((String)"NoSuchElementException must be thrown from next at end of ListIterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            AbstractListIteratorTest.assertEquals((int)(i + 1), (int)it.nextIndex());
            AbstractListIteratorTest.assertEquals((int)i, (int)it.previousIndex());
            Object obj = list.get(i);
            AbstractListIteratorTest.assertEquals(obj, it.previous());
        }
        AbstractListIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        AbstractListIteratorTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        try {
            it.previous();
            AbstractListIteratorTest.fail((String)"NoSuchElementException must be thrown from previous at start of ListIterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testAdd() {
        Iterator it = this.makeObject();
        E addValue = this.addSetValue();
        if (!this.supportsAdd()) {
            try {
                it.add(addValue);
                AbstractListIteratorTest.fail((String)("UnsupportedOperationException must be thrown from add of " + it.getClass().getSimpleName()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        it = this.makeObject();
        it.add(addValue);
        AbstractListIteratorTest.assertEquals(addValue, it.previous());
        it = this.makeObject();
        it.add(addValue);
        AbstractListIteratorTest.assertTrue((addValue != it.next() ? 1 : 0) != 0);
        it = this.makeObject();
        while (it.hasNext()) {
            it.next();
            it.add(addValue);
            AbstractListIteratorTest.assertEquals(addValue, it.previous());
            it.next();
        }
    }

    public void testSet() {
        Iterator it = this.makeObject();
        if (!this.supportsSet()) {
            try {
                it.set(this.addSetValue());
                AbstractListIteratorTest.fail((String)("UnsupportedOperationException must be thrown from set in " + it.getClass().getSimpleName()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        try {
            it.set(this.addSetValue());
            AbstractListIteratorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        it.next();
        it.set(this.addSetValue());
        it.set(this.addSetValue());
    }

    public void testRemoveThenSet() {
        Iterator it = this.makeObject();
        if (this.supportsRemove() && this.supportsSet()) {
            it.next();
            it.remove();
            try {
                it.set(this.addSetValue());
                AbstractListIteratorTest.fail((String)"IllegalStateException must be thrown from set after remove");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void testAddThenSet() {
        Iterator it = this.makeObject();
        if (this.supportsAdd() && this.supportsSet()) {
            it.next();
            it.add(this.addSetValue());
            try {
                it.set(this.addSetValue());
                AbstractListIteratorTest.fail((String)"IllegalStateException must be thrown from set after add");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void testAddThenRemove() {
        Iterator it = this.makeObject();
        if (this.supportsAdd() && this.supportsRemove()) {
            it.next();
            it.add(this.addSetValue());
            try {
                it.remove();
                AbstractListIteratorTest.fail((String)"IllegalStateException must be thrown from remove after add");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

