/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.AbstractObjectTest;

public abstract class AbstractIteratorTest<E>
extends AbstractObjectTest {
    public AbstractIteratorTest(String testName) {
        super(testName);
    }

    public abstract Iterator<E> makeEmptyIterator();

    @Override
    public abstract Iterator<E> makeObject();

    public boolean supportsEmptyIterator() {
        return true;
    }

    public boolean supportsFullIterator() {
        return true;
    }

    public boolean supportsRemove() {
        return true;
    }

    public void verify() {
    }

    public void testEmptyIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        Iterator<E> it = this.makeEmptyIterator();
        AbstractIteratorTest.assertEquals((String)"hasNext() should return false for empty iterators", (boolean)false, (boolean)it.hasNext());
        try {
            it.next();
            AbstractIteratorTest.fail((String)"NoSuchElementException must be thrown when Iterator is exhausted");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.verify();
        AbstractIteratorTest.assertNotNull((Object)it.toString());
    }

    public void testFullIterator() {
        if (!this.supportsFullIterator()) {
            return;
        }
        Object it = this.makeObject();
        AbstractIteratorTest.assertEquals((String)"hasNext() should return true for at least one element", (boolean)true, (boolean)it.hasNext());
        try {
            it.next();
        }
        catch (NoSuchElementException e) {
            AbstractIteratorTest.fail((String)"Full iterators must have at least one element");
        }
        while (it.hasNext()) {
            it.next();
            this.verify();
        }
        try {
            it.next();
            AbstractIteratorTest.fail((String)"NoSuchElementException must be thrown when Iterator is exhausted");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        AbstractIteratorTest.assertNotNull((Object)it.toString());
    }

    public void testRemove() {
        Object it = this.makeObject();
        if (!this.supportsRemove()) {
            try {
                it.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        try {
            it.remove();
            AbstractIteratorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.verify();
        it.next();
        it.remove();
        try {
            it.remove();
            AbstractIteratorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

