/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.UnmodifiableCollection;

public class UnmodifiableCollectionTest<E>
extends AbstractCollectionTest<E> {
    public UnmodifiableCollectionTest(String testName) {
        super(testName);
    }

    @Override
    public Collection<E> makeObject() {
        return UnmodifiableCollection.unmodifiableCollection(new ArrayList());
    }

    @Override
    public Collection<E> makeFullCollection() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return UnmodifiableCollection.unmodifiableCollection(list);
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    public void testUnmodifiable() {
        UnmodifiableCollectionTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableCollectionTest.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        Collection<E> coll = this.makeFullCollection();
        UnmodifiableCollectionTest.assertSame(coll, (Object)UnmodifiableCollection.unmodifiableCollection(coll));
        try {
            UnmodifiableCollection.unmodifiableCollection(null);
            UnmodifiableCollectionTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

