/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.OrderedBidiMap;
import org.apache.commons.collections4.bidimap.AbstractBidiMapTest;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;

public abstract class AbstractOrderedBidiMapTest<K, V>
extends AbstractBidiMapTest<K, V> {
    public AbstractOrderedBidiMapTest(String testName) {
        super(testName);
    }

    public AbstractOrderedBidiMapTest() {
    }

    public void testFirstKey() {
        this.resetEmpty();
        OrderedBidiMap<K, V> bidi = this.getMap();
        try {
            bidi.firstKey();
            AbstractOrderedBidiMapTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.resetFull();
        bidi = this.getMap();
        Object confirmedFirst = this.confirmed.keySet().iterator().next();
        AbstractOrderedBidiMapTest.assertEquals(confirmedFirst, (Object)bidi.firstKey());
    }

    public void testLastKey() {
        this.resetEmpty();
        OrderedBidiMap<K, V> bidi = this.getMap();
        try {
            bidi.lastKey();
            AbstractOrderedBidiMapTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.resetFull();
        bidi = this.getMap();
        Object confirmedLast2 = null;
        for (Object confirmedLast2 : this.confirmed.keySet()) {
        }
        AbstractOrderedBidiMapTest.assertEquals(confirmedLast2, (Object)bidi.lastKey());
    }

    public void testNextKey() {
        this.resetEmpty();
        OrderedBidiMap bidi = (OrderedBidiMap)this.map;
        AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.nextKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.nextKey(null));
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.nextKey(null));
        }
        this.resetFull();
        bidi = (OrderedBidiMap)this.map;
        Iterator it = this.confirmed.keySet().iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            AbstractOrderedBidiMapTest.assertEquals(confirmedObject, (Object)bidi.nextKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.nextKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            try {
                bidi.nextKey(null);
                AbstractOrderedBidiMapTest.fail();
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.nextKey(null));
        }
    }

    public void testPreviousKey() {
        this.resetEmpty();
        OrderedBidiMap<K, V> bidi = this.getMap();
        AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.previousKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.previousKey(null));
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.previousKey(null));
        }
        this.resetFull();
        bidi = this.getMap();
        ArrayList list = new ArrayList(this.confirmed.keySet());
        Collections.reverse(list);
        Iterator it = list.iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            AbstractOrderedBidiMapTest.assertEquals(confirmedObject, (Object)bidi.previousKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.previousKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            try {
                bidi.previousKey(null);
                AbstractOrderedBidiMapTest.fail();
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            AbstractOrderedBidiMapTest.assertEquals(null, (Object)bidi.previousKey(null));
        }
    }

    public BulkTest bulkTestOrderedMapIterator() {
        return new TestBidiOrderedMapIterator();
    }

    @Override
    public OrderedBidiMap<K, V> getMap() {
        return (OrderedBidiMap)super.getMap();
    }

    public class TestBidiOrderedMapIterator
    extends AbstractMapIteratorTest<K, V> {
        public TestBidiOrderedMapIterator() {
            super("TestBidiOrderedMapIterator");
        }

        @Override
        public V[] addSetValues() {
            return AbstractOrderedBidiMapTest.this.getNewSampleValues();
        }

        @Override
        public boolean supportsRemove() {
            return AbstractOrderedBidiMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsSetValue() {
            return AbstractOrderedBidiMapTest.this.isSetValueSupported();
        }

        @Override
        public MapIterator<K, V> makeEmptyIterator() {
            AbstractOrderedBidiMapTest.this.resetEmpty();
            return AbstractOrderedBidiMapTest.this.getMap().mapIterator();
        }

        @Override
        public MapIterator<K, V> makeObject() {
            AbstractOrderedBidiMapTest.this.resetFull();
            return AbstractOrderedBidiMapTest.this.getMap().mapIterator();
        }

        @Override
        public Map<K, V> getMap() {
            return AbstractOrderedBidiMapTest.this.map;
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return AbstractOrderedBidiMapTest.this.confirmed;
        }

        @Override
        public void verify() {
            super.verify();
            AbstractOrderedBidiMapTest.this.verify();
        }
    }
}

