/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Arrays;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.MultiSetUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiSetUtilsTest {
    private String[] fullArray;
    private MultiSet<String> multiSet;

    @Before
    public void setUp() {
        this.fullArray = new String[]{"a", "a", "b", "c", "d", "d", "d"};
        this.multiSet = new HashMultiSet(Arrays.asList(this.fullArray));
    }

    @Test
    public void testEmptyMultiSet() {
        MultiSet empty = MultiSetUtils.emptyMultiSet();
        Assert.assertEquals((long)0L, (long)empty.size());
        try {
            empty.add((Object)55);
            Assert.fail((String)"Empty multi set must be read-only");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testUnmodifiableMultiSet() {
        MultiSet unmodifiable = MultiSetUtils.unmodifiableMultiSet(this.multiSet);
        Assert.assertEquals(this.multiSet, (Object)unmodifiable);
        try {
            unmodifiable.add((Object)"a");
            Assert.fail((String)"Empty multi set must be read-only");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            MultiSetUtils.unmodifiableMultiSet(null);
            Assert.fail((String)"Expecting NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testSynchronizedMultiSet() {
        MultiSet synced = MultiSetUtils.synchronizedMultiSet(this.multiSet);
        Assert.assertEquals(this.multiSet, (Object)synced);
        synced.add((Object)"a");
    }

    @Test
    public void testPredicatedMultiSet() {
        Predicate<String> predicate = new Predicate<String>(){

            public boolean evaluate(String object) {
                return object.length() == 1;
            }
        };
        MultiSet predicated = MultiSetUtils.predicatedMultiSet(this.multiSet, (Predicate)predicate);
        Assert.assertEquals((long)this.multiSet.size(), (long)predicated.size());
        Assert.assertEquals((long)this.multiSet.getCount((Object)"a"), (long)predicated.getCount((Object)"a"));
        try {
            MultiSetUtils.predicatedMultiSet(null, (Predicate)predicate);
            Assert.fail((String)"Expecting NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MultiSetUtils.predicatedMultiSet(this.multiSet, null);
            Assert.fail((String)"Expecting NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MultiSetUtils.predicatedMultiSet(this.multiSet, (Predicate)new Predicate<String>(){

                public boolean evaluate(String object) {
                    return object.equals("a");
                }
            });
            Assert.fail((String)"Predicate is violated for all elements not being 'a'");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

