/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.junit.Assert;
import org.junit.Test;

public class MultiMapUtilsTest {
    @Test
    public void testEmptyUnmodifiableMultiValuedMap() {
        MultiValuedMap map = MultiMapUtils.EMPTY_MULTI_VALUED_MAP;
        Assert.assertTrue((boolean)map.isEmpty());
        try {
            map.put((Object)"key", (Object)"value");
            Assert.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testTypeSafeEmptyMultiValuedMap() {
        MultiValuedMap map = MultiMapUtils.emptyMultiValuedMap();
        Assert.assertTrue((boolean)map.isEmpty());
        try {
            map.put((Object)"key", (Object)"value");
            Assert.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyIfNull() {
        Assert.assertTrue((boolean)MultiMapUtils.emptyIfNull(null).isEmpty());
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        map.put((Object)"item", (Object)"value");
        Assert.assertFalse((boolean)MultiMapUtils.emptyIfNull((MultiValuedMap)map).isEmpty());
    }

    @Test
    public void testIsEmptyWithEmptyMap() {
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        Assert.assertEquals((Object)true, (Object)MultiMapUtils.isEmpty((MultiValuedMap)map));
    }

    @Test
    public void testIsEmptyWithNonEmptyMap() {
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        map.put((Object)"item", (Object)"value");
        Assert.assertEquals((Object)false, (Object)MultiMapUtils.isEmpty((MultiValuedMap)map));
    }

    @Test
    public void testIsEmptyWithNull() {
        MultiValuedMap map = null;
        Assert.assertEquals((Object)true, (Object)MultiMapUtils.isEmpty(map));
    }

    @Test
    public void testGetCollection() {
        Assert.assertNull((Object)MultiMapUtils.getCollection(null, (Object)"key1"));
        String[] values = new String[]{"v1", "v2", "v3"};
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        for (String val : values) {
            map.put((Object)"key1", (Object)val);
        }
        Collection col = MultiMapUtils.getCollection((MultiValuedMap)map, (Object)"key1");
        for (String val : values) {
            Assert.assertTrue((boolean)col.contains(val));
        }
    }

    @Test
    public void testGetValuesAsList() {
        Assert.assertNull((Object)MultiMapUtils.getValuesAsList(null, (Object)"key1"));
        String[] values = new String[]{"v1", "v2", "v3"};
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        for (String val : values) {
            map.put((Object)"key1", (Object)val);
        }
        List list = MultiMapUtils.getValuesAsList((MultiValuedMap)map, (Object)"key1");
        int i = 0;
        for (String val : list) {
            Assert.assertTrue((boolean)val.equals(values[i++]));
        }
    }

    @Test
    public void testGetValuesAsSet() {
        Assert.assertNull((Object)MultiMapUtils.getValuesAsList(null, (Object)"key1"));
        String[] values = new String[]{"v1", "v2", "v3"};
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        for (String val : values) {
            map.put((Object)"key1", (Object)val);
            map.put((Object)"key1", (Object)val);
        }
        Set set = MultiMapUtils.getValuesAsSet((MultiValuedMap)map, (Object)"key1");
        Assert.assertEquals((long)3L, (long)set.size());
        for (String val : values) {
            Assert.assertTrue((boolean)set.contains(val));
        }
    }

    @Test
    public void testGetValuesAsBag() {
        Assert.assertNull((Object)MultiMapUtils.getValuesAsBag(null, (Object)"key1"));
        String[] values = new String[]{"v1", "v2", "v3"};
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        for (String val : values) {
            map.put((Object)"key1", (Object)val);
            map.put((Object)"key1", (Object)val);
        }
        Bag bag = MultiMapUtils.getValuesAsBag((MultiValuedMap)map, (Object)"key1");
        Assert.assertEquals((long)6L, (long)bag.size());
        for (String val : values) {
            Assert.assertTrue((boolean)bag.contains((Object)val));
            Assert.assertEquals((long)2L, (long)bag.getCount((Object)val));
        }
    }
}

