/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.collections4.ResettableListIterator;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.iterators.EmptyIterator;
import org.apache.commons.collections4.iterators.EmptyListIterator;
import org.apache.commons.collections4.iterators.EmptyMapIterator;
import org.apache.commons.collections4.iterators.EmptyOrderedIterator;
import org.apache.commons.collections4.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections4.iterators.EnumerationIterator;
import org.apache.commons.collections4.iterators.NodeListIterator;
import org.apache.commons.collections4.iterators.ObjectArrayIterator;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IteratorUtilsTest {
    private List<Integer> collectionA = null;
    private List<Integer> collectionEven = null;
    private List<Integer> collectionOdd = null;
    private final Collection<Integer> emptyCollection = new ArrayList<Integer>(1);
    private Iterable<Integer> iterableA = null;

    private NodeList createNodeList(final Node[] nodes) {
        return new NodeList(){

            @Override
            public int getLength() {
                return nodes.length;
            }

            @Override
            public Node item(int index) {
                return nodes[index];
            }
        };
    }

    private Node[] createNodes() {
        Node node1 = (Node)EasyMock.createMock(Node.class);
        Node node2 = (Node)EasyMock.createMock(Node.class);
        Node node3 = (Node)EasyMock.createMock(Node.class);
        Node node4 = (Node)EasyMock.createMock(Node.class);
        EasyMock.replay((Object[])new Object[]{node1});
        EasyMock.replay((Object[])new Object[]{node2});
        EasyMock.replay((Object[])new Object[]{node3});
        EasyMock.replay((Object[])new Object[]{node4});
        return new Node[]{node1, node2, node3, node4};
    }

    private Iterator<String> getImmutableIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        return IteratorUtils.unmodifiableIterator(list.iterator());
    }

    private ListIterator<String> getImmutableListIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        return IteratorUtils.unmodifiableListIterator(list.listIterator());
    }

    @Before
    public void setUp() {
        this.collectionA = new ArrayList<Integer>();
        this.collectionA.add(1);
        this.collectionA.add(2);
        this.collectionA.add(2);
        this.collectionA.add(3);
        this.collectionA.add(3);
        this.collectionA.add(3);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.iterableA = this.collectionA;
        this.collectionEven = Arrays.asList(2, 4, 6, 8, 10, 12);
        this.collectionOdd = Arrays.asList(1, 3, 5, 7, 9, 11);
    }

    @Test
    public void testArrayIterator() {
        Object[] objArray = new Object[]{"a", "b", "c"};
        ResettableIterator iterator = IteratorUtils.arrayIterator((Object[])objArray);
        Assert.assertTrue((boolean)iterator.next().equals("a"));
        Assert.assertTrue((boolean)iterator.next().equals("b"));
        iterator.reset();
        Assert.assertTrue((boolean)iterator.next().equals("a"));
        try {
            iterator = IteratorUtils.arrayIterator((Object)0);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object[])null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)1);
        Assert.assertTrue((boolean)iterator.next().equals("b"));
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)-1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)3);
        Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
        iterator.reset();
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)4);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)2, (int)3);
        Assert.assertTrue((boolean)iterator.next().equals("c"));
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)2, (int)4);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)-1, (int)1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)2, (int)1);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int[] intArray = new int[]{0, 1, 2};
        iterator = IteratorUtils.arrayIterator((Object)intArray);
        Assert.assertTrue((boolean)iterator.next().equals(0));
        Assert.assertTrue((boolean)iterator.next().equals(1));
        iterator.reset();
        Assert.assertTrue((boolean)iterator.next().equals(0));
        iterator = IteratorUtils.arrayIterator((Object)intArray, (int)1);
        Assert.assertTrue((boolean)iterator.next().equals(1));
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)-1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object)intArray, (int)3);
        Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
        iterator.reset();
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)4);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object)intArray, (int)2, (int)3);
        Assert.assertTrue((boolean)iterator.next().equals(2));
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)2, (int)4);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)-1, (int)1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)2, (int)1);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayListIterator() {
        Object[] objArray = new Object[]{"a", "b", "c", "d"};
        ResettableListIterator iterator = IteratorUtils.arrayListIterator((Object[])objArray);
        Assert.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        Assert.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.next().equals("a"));
        Assert.assertTrue((boolean)iterator.previous().equals("a"));
        Assert.assertTrue((boolean)iterator.next().equals("a"));
        Assert.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.next().equals("b"));
        Assert.assertTrue((boolean)iterator.next().equals("c"));
        Assert.assertTrue((boolean)iterator.next().equals("d"));
        Assert.assertTrue((iterator.nextIndex() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((iterator.previousIndex() == 3 ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object)0);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)1);
        Assert.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        Assert.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.next().equals("b"));
        Assert.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)-1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)3);
        Assert.assertTrue((boolean)iterator.hasNext());
        try {
            iterator.previous();
            Assert.fail((String)"Expecting NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)5);
            Assert.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)2, (int)3);
        Assert.assertTrue((boolean)iterator.next().equals("c"));
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)2, (int)5);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)-1, (int)1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)2, (int)1);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int[] intArray = new int[]{0, 1, 2};
        iterator = IteratorUtils.arrayListIterator((Object)intArray);
        Assert.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        Assert.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.next().equals(0));
        Assert.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.next().equals(1));
        Assert.assertTrue((iterator.previousIndex() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.previous().equals(1));
        Assert.assertTrue((boolean)iterator.next().equals(1));
        iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)1);
        Assert.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        Assert.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.next().equals(1));
        Assert.assertTrue((boolean)iterator.previous().equals(1));
        Assert.assertTrue((boolean)iterator.next().equals(1));
        Assert.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.next().equals(2));
        Assert.assertTrue((iterator.previousIndex() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.previous().equals(2));
        Assert.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((iterator.nextIndex() == 1 ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)-1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)3);
        Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)4);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)2, (int)3);
        Assert.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        Assert.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.next().equals(2));
        Assert.assertTrue((boolean)iterator.hasPrevious());
        Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)2, (int)4);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)-1, (int)1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)2, (int)1);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAsIterable() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        Iterator iterator = list.iterator();
        Iterable iterable = IteratorUtils.asIterable(iterator);
        int expected = 0;
        for (Integer actual : iterable) {
            Assert.assertEquals((long)expected, (long)actual.intValue());
            ++expected;
        }
        Assert.assertTrue((expected > 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"should not be able to iterate twice", (boolean)IteratorUtils.asIterable(iterator).iterator().hasNext());
    }

    @Test
    public void testAsIterableNull() {
        try {
            IteratorUtils.asIterable(null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAsMultipleIterable() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        Iterator iterator = list.iterator();
        Iterable iterable = IteratorUtils.asMultipleUseIterable(iterator);
        int expected = 0;
        for (Integer actual : iterable) {
            Assert.assertEquals((long)expected, (long)actual.intValue());
            ++expected;
        }
        Assert.assertTrue((expected > 0 ? 1 : 0) != 0);
        expected = 0;
        for (Integer actual : iterable) {
            Assert.assertEquals((long)expected, (long)actual.intValue());
            ++expected;
        }
        Assert.assertTrue((expected > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAsMultipleIterableNull() {
        try {
            IteratorUtils.asMultipleUseIterable(null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testCollatedIterator() {
        try {
            IteratorUtils.collatedIterator(null, this.collectionOdd.iterator(), null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IteratorUtils.collatedIterator(null, null, this.collectionEven.iterator());
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Iterator it = IteratorUtils.collatedIterator(null, this.collectionOdd.iterator(), this.collectionEven.iterator());
        List result = IteratorUtils.toList((Iterator)it);
        Assert.assertEquals((long)12L, (long)result.size());
        ArrayList<Integer> combinedList = new ArrayList<Integer>();
        combinedList.addAll(this.collectionOdd);
        combinedList.addAll(this.collectionEven);
        Collections.sort(combinedList);
        Assert.assertEquals(combinedList, (Object)result);
        it = IteratorUtils.collatedIterator(null, this.collectionOdd.iterator(), this.emptyCollection.iterator());
        result = IteratorUtils.toList((Iterator)it);
        Assert.assertEquals(this.collectionOdd, (Object)result);
        Comparator reverseComparator = ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator());
        Collections.reverse(this.collectionOdd);
        Collections.reverse(this.collectionEven);
        Collections.reverse(combinedList);
        it = IteratorUtils.collatedIterator((Comparator)reverseComparator, this.collectionOdd.iterator(), this.collectionEven.iterator());
        result = IteratorUtils.toList((Iterator)it);
        Assert.assertEquals(combinedList, (Object)result);
    }

    @Test
    public void testEmptyIterator() {
        Assert.assertSame((Object)EmptyIterator.INSTANCE, (Object)IteratorUtils.EMPTY_ITERATOR);
        Assert.assertSame((Object)EmptyIterator.RESETTABLE_INSTANCE, (Object)IteratorUtils.EMPTY_ITERATOR);
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_ITERATOR instanceof Iterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_ITERATOR instanceof ResettableIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_ITERATOR instanceof OrderedIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_ITERATOR instanceof ListIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_ITERATOR instanceof MapIterator));
        Assert.assertEquals((Object)false, (Object)IteratorUtils.EMPTY_ITERATOR.hasNext());
        IteratorUtils.EMPTY_ITERATOR.reset();
        Assert.assertSame((Object)IteratorUtils.EMPTY_ITERATOR, (Object)IteratorUtils.EMPTY_ITERATOR);
        Assert.assertSame((Object)IteratorUtils.EMPTY_ITERATOR, (Object)IteratorUtils.emptyIterator());
        try {
            IteratorUtils.EMPTY_ITERATOR.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ITERATOR.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyListIterator() {
        Assert.assertSame((Object)EmptyListIterator.INSTANCE, (Object)IteratorUtils.EMPTY_LIST_ITERATOR);
        Assert.assertSame((Object)EmptyListIterator.RESETTABLE_INSTANCE, (Object)IteratorUtils.EMPTY_LIST_ITERATOR);
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof Iterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof ListIterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof ResettableIterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof ResettableListIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof MapIterator));
        Assert.assertEquals((Object)false, (Object)IteratorUtils.EMPTY_LIST_ITERATOR.hasNext());
        Assert.assertEquals((long)0L, (long)IteratorUtils.EMPTY_LIST_ITERATOR.nextIndex());
        Assert.assertEquals((long)-1L, (long)IteratorUtils.EMPTY_LIST_ITERATOR.previousIndex());
        IteratorUtils.EMPTY_LIST_ITERATOR.reset();
        Assert.assertSame((Object)IteratorUtils.EMPTY_LIST_ITERATOR, (Object)IteratorUtils.EMPTY_LIST_ITERATOR);
        Assert.assertSame((Object)IteratorUtils.EMPTY_LIST_ITERATOR, (Object)IteratorUtils.emptyListIterator());
        try {
            IteratorUtils.EMPTY_LIST_ITERATOR.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_LIST_ITERATOR.previous();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_LIST_ITERATOR.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            IteratorUtils.emptyListIterator().set(null);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            IteratorUtils.emptyListIterator().add(null);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyMapIterator() {
        Assert.assertSame((Object)EmptyMapIterator.INSTANCE, (Object)IteratorUtils.EMPTY_MAP_ITERATOR);
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof Iterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof MapIterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof ResettableIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof ListIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof OrderedIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof OrderedMapIterator));
        Assert.assertEquals((Object)false, (Object)IteratorUtils.EMPTY_MAP_ITERATOR.hasNext());
        ((ResettableIterator)IteratorUtils.EMPTY_MAP_ITERATOR).reset();
        Assert.assertSame((Object)IteratorUtils.EMPTY_MAP_ITERATOR, (Object)IteratorUtils.EMPTY_MAP_ITERATOR);
        Assert.assertSame((Object)IteratorUtils.EMPTY_MAP_ITERATOR, (Object)IteratorUtils.emptyMapIterator());
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.getKey();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.getValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.setValue(null);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyOrderedIterator() {
        Assert.assertSame((Object)EmptyOrderedIterator.INSTANCE, (Object)IteratorUtils.EMPTY_ORDERED_ITERATOR);
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof Iterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof OrderedIterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof ResettableIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof ListIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof MapIterator));
        Assert.assertEquals((Object)false, (Object)IteratorUtils.EMPTY_ORDERED_ITERATOR.hasNext());
        Assert.assertEquals((Object)false, (Object)IteratorUtils.EMPTY_ORDERED_ITERATOR.hasPrevious());
        ((ResettableIterator)IteratorUtils.EMPTY_ORDERED_ITERATOR).reset();
        Assert.assertSame((Object)IteratorUtils.EMPTY_ORDERED_ITERATOR, (Object)IteratorUtils.EMPTY_ORDERED_ITERATOR);
        Assert.assertSame((Object)IteratorUtils.EMPTY_ORDERED_ITERATOR, (Object)IteratorUtils.emptyOrderedIterator());
        try {
            IteratorUtils.EMPTY_ORDERED_ITERATOR.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_ITERATOR.previous();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_ITERATOR.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyOrderedMapIterator() {
        Assert.assertSame((Object)EmptyOrderedMapIterator.INSTANCE, (Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR);
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof Iterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof MapIterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof OrderedMapIterator));
        Assert.assertEquals((Object)true, (Object)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof ResettableIterator));
        Assert.assertEquals((Object)false, (Object)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof ListIterator));
        Assert.assertEquals((Object)false, (Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.hasNext());
        Assert.assertEquals((Object)false, (Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.hasPrevious());
        ((ResettableIterator)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR).reset();
        Assert.assertSame((Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR, (Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR);
        Assert.assertSame((Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR, (Object)IteratorUtils.emptyOrderedMapIterator());
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.previous();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.getKey();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.getValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.setValue(null);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testFind() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        Integer test = (Integer)IteratorUtils.find(this.iterableA.iterator(), (Predicate)testPredicate);
        Assert.assertTrue((boolean)test.equals(4));
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        test = (Integer)IteratorUtils.find(this.iterableA.iterator(), (Predicate)testPredicate);
        Assert.assertTrue((test == null ? 1 : 0) != 0);
        Assert.assertNull((Object)IteratorUtils.find(null, (Predicate)testPredicate));
        try {
            Assert.assertNull((Object)IteratorUtils.find(this.iterableA.iterator(), null));
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testFirstFromIterator() throws Exception {
        Iterator<Integer> iterator = this.iterableA.iterator();
        Assert.assertEquals((long)1L, (long)((Integer)IteratorUtils.first(iterator)).intValue());
    }

    @Test
    public void testForEach() {
        ArrayList<Integer> listA = new ArrayList<Integer>();
        listA.add(1);
        ArrayList<Integer> listB = new ArrayList<Integer>();
        listB.add(2);
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<ArrayList<Integer>> col = new ArrayList<ArrayList<Integer>>();
        col.add(listA);
        col.add(listB);
        IteratorUtils.forEach(col.iterator(), (Closure)testClosure);
        Assert.assertTrue((listA.isEmpty() && listB.isEmpty() ? 1 : 0) != 0);
        try {
            IteratorUtils.forEach(col.iterator(), null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        IteratorUtils.forEach(null, (Closure)testClosure);
        col.add(null);
        IteratorUtils.forEach(col.iterator(), (Closure)testClosure);
    }

    @Test
    public void testForEachButLast() {
        ArrayList<Integer> listA = new ArrayList<Integer>();
        listA.add(1);
        ArrayList<Integer> listB = new ArrayList<Integer>();
        listB.add(2);
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<ArrayList<Integer>> col = new ArrayList<ArrayList<Integer>>();
        col.add(listA);
        col.add(listB);
        List last = (List)IteratorUtils.forEachButLast(col.iterator(), (Closure)testClosure);
        Assert.assertTrue((listA.isEmpty() && !listB.isEmpty() ? 1 : 0) != 0);
        Assert.assertSame(listB, (Object)last);
        try {
            IteratorUtils.forEachButLast(col.iterator(), null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        IteratorUtils.forEachButLast(null, (Closure)testClosure);
        col.add(null);
        col.add(null);
        last = (List)IteratorUtils.forEachButLast(col.iterator(), (Closure)testClosure);
        Assert.assertNull((Object)last);
    }

    @Test
    public void testGetAtIndexFromIterator() throws Exception {
        Iterator<Integer> iterator = this.iterableA.iterator();
        Assert.assertEquals((long)1L, (long)((Integer)IteratorUtils.get(iterator, (int)0)).intValue());
        iterator = this.iterableA.iterator();
        Assert.assertEquals((long)2L, (long)((Integer)IteratorUtils.get(iterator, (int)1)).intValue());
        try {
            IteratorUtils.get(iterator, (int)10);
            Assert.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testGetIterator() {
        Object[] objArray = new Object[]{"a", "b", "c"};
        HashMap inMap = new HashMap();
        Node[] nodes = this.createNodes();
        NodeList nodeList = this.createNodeList(nodes);
        Assert.assertTrue((String)"returns empty iterator when null passed", (boolean)(IteratorUtils.getIterator(null) instanceof EmptyIterator));
        Assert.assertTrue((String)"returns Iterator when Iterator directly ", (boolean)(IteratorUtils.getIterator(this.iterableA.iterator()) instanceof Iterator));
        Assert.assertTrue((String)"returns Iterator when iterable passed", (boolean)(IteratorUtils.getIterator(this.iterableA) instanceof Iterator));
        Assert.assertTrue((String)"returns ObjectArrayIterator when Object array passed", (boolean)(IteratorUtils.getIterator((Object)objArray) instanceof ObjectArrayIterator));
        Assert.assertTrue((String)"returns Iterator when Map passed", (boolean)(IteratorUtils.getIterator(inMap) instanceof Iterator));
        Assert.assertTrue((String)"returns NodeListIterator when nodeList passed", (boolean)(IteratorUtils.getIterator((Object)nodeList) instanceof NodeListIterator));
        Assert.assertTrue((String)"returns EnumerationIterator when Enumeration passed", (boolean)(IteratorUtils.getIterator(new Vector().elements()) instanceof EnumerationIterator));
    }

    @Test
    public void testIndexOf() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        int index = IteratorUtils.indexOf(this.iterableA.iterator(), (Predicate)testPredicate);
        Assert.assertEquals((long)6L, (long)index);
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        index = IteratorUtils.indexOf(this.iterableA.iterator(), (Predicate)testPredicate);
        Assert.assertEquals((long)-1L, (long)index);
        Assert.assertEquals((long)-1L, (long)IteratorUtils.indexOf(null, (Predicate)testPredicate));
        try {
            IteratorUtils.indexOf(this.iterableA.iterator(), null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testNodeIterator() {
        Node[] nodes = this.createNodes();
        NodeList nodeList = this.createNodeList(nodes);
        Node parentNode = (Node)EasyMock.createMock(Node.class);
        EasyMock.expect((Object)parentNode.getChildNodes()).andStubReturn((Object)nodeList);
        EasyMock.replay((Object[])new Object[]{parentNode});
        NodeListIterator iterator = IteratorUtils.nodeListIterator((Node)parentNode);
        int expectedNodeIndex = 0;
        for (Node actual : IteratorUtils.asIterable((Iterator)iterator)) {
            Assert.assertEquals((Object)nodes[expectedNodeIndex], (Object)actual);
            ++expectedNodeIndex;
        }
        Assert.assertTrue((expectedNodeIndex > 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"should not be able to iterate twice", (boolean)IteratorUtils.asIterable((Iterator)iterator).iterator().hasNext());
    }

    @Test
    public void testNodeListIterator() {
        Node[] nodes = this.createNodes();
        NodeList nodeList = this.createNodeList(nodes);
        NodeListIterator iterator = IteratorUtils.nodeListIterator((NodeList)nodeList);
        int expectedNodeIndex = 0;
        for (Node actual : IteratorUtils.asIterable((Iterator)iterator)) {
            Assert.assertEquals((Object)nodes[expectedNodeIndex], (Object)actual);
            ++expectedNodeIndex;
        }
        Assert.assertTrue((expectedNodeIndex > 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"should not be able to iterate twice", (boolean)IteratorUtils.asIterable((Iterator)iterator).iterator().hasNext());
    }

    @Test
    public void testToArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(1);
        list.add("Two");
        list.add(null);
        Object[] result = IteratorUtils.toArray(list.iterator());
        Assert.assertEquals(list, Arrays.asList(result));
        try {
            IteratorUtils.toArray(null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToArray2() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        list.add(null);
        String[] result = (String[])IteratorUtils.toArray(list.iterator(), String.class);
        Assert.assertEquals(list, Arrays.asList(result));
        try {
            IteratorUtils.toArray(list.iterator(), null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IteratorUtils.toArray(null, String.class);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(1);
        list.add("Two");
        list.add(null);
        List result = IteratorUtils.toList(list.iterator());
        Assert.assertEquals(list, (Object)result);
    }

    @Test
    public void testToListIterator() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        Iterator iterator = list.iterator();
        ListIterator liItr = IteratorUtils.toListIterator(iterator);
        int expected = 0;
        while (liItr.hasNext()) {
            Assert.assertEquals((long)expected, (long)((Integer)liItr.next()).intValue());
            ++expected;
        }
    }

    @Test
    public void testToListIteratorNull() {
        try {
            IteratorUtils.toListIterator(null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testUnmodifiableIteratorImmutability() {
        Iterator<String> iterator = this.getImmutableIterator();
        try {
            iterator.remove();
            Assert.fail((String)"remove() should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        iterator.next();
        try {
            iterator.remove();
            Assert.fail((String)"remove() should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testUnmodifiableIteratorIteration() {
        Iterator<String> iterator = this.getImmutableIterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"a", (Object)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"b", (Object)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"c", (Object)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"d", (Object)iterator.next());
        Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testUnmodifiableListIteratorImmutability() {
        ListIterator<String> listIterator = this.getImmutableListIterator();
        try {
            listIterator.remove();
            Assert.fail((String)"remove() should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            listIterator.set("a");
            Assert.fail((String)"set(Object) should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            listIterator.add("a");
            Assert.fail((String)"add(Object) should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        listIterator.next();
        try {
            listIterator.remove();
            Assert.fail((String)"remove() should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            listIterator.set("a");
            Assert.fail((String)"set(Object) should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            listIterator.add("a");
            Assert.fail((String)"add(Object) should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testUnmodifiableListIteratorIteration() {
        ListIterator<String> listIterator = this.getImmutableListIterator();
        Assert.assertTrue((!listIterator.hasPrevious() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)listIterator.hasNext());
        Assert.assertEquals((Object)"a", (Object)listIterator.next());
        Assert.assertTrue((boolean)listIterator.hasPrevious());
        Assert.assertTrue((boolean)listIterator.hasNext());
        Assert.assertEquals((Object)"b", (Object)listIterator.next());
        Assert.assertTrue((boolean)listIterator.hasPrevious());
        Assert.assertTrue((boolean)listIterator.hasNext());
        Assert.assertEquals((Object)"c", (Object)listIterator.next());
        Assert.assertTrue((boolean)listIterator.hasPrevious());
        Assert.assertTrue((boolean)listIterator.hasNext());
        Assert.assertEquals((Object)"d", (Object)listIterator.next());
        Assert.assertTrue((boolean)listIterator.hasPrevious());
        Assert.assertTrue((!listIterator.hasNext() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"d", (Object)listIterator.previous());
        Assert.assertTrue((boolean)listIterator.hasPrevious());
        Assert.assertTrue((boolean)listIterator.hasNext());
        Assert.assertEquals((Object)"c", (Object)listIterator.previous());
        Assert.assertTrue((boolean)listIterator.hasPrevious());
        Assert.assertTrue((boolean)listIterator.hasNext());
        Assert.assertEquals((Object)"b", (Object)listIterator.previous());
        Assert.assertTrue((boolean)listIterator.hasPrevious());
        Assert.assertTrue((boolean)listIterator.hasNext());
        Assert.assertEquals((Object)"a", (Object)listIterator.previous());
        Assert.assertTrue((!listIterator.hasPrevious() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)listIterator.hasNext());
    }
}

