/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.ListOrderedSet;

public class ListOrderedSet2Test<E>
extends AbstractSetTest<E> {
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer THREE = 3;

    public ListOrderedSet2Test(String testName) {
        super(testName);
    }

    @Override
    public ListOrderedSet<E> makeObject() {
        return new ListOrderedSet();
    }

    protected ListOrderedSet<E> setupSet() {
        ListOrderedSet<E> set = this.makeObject();
        for (int i = 0; i < 10; ++i) {
            set.add((Object)Integer.toString(i));
        }
        return set;
    }

    public void testOrdering() {
        int i;
        ListOrderedSet<E> set = this.setupSet();
        OrderedIterator it = set.iterator();
        for (i = 0; i < 10; ++i) {
            ListOrderedSet2Test.assertEquals((String)"Sequence is wrong", (Object)Integer.toString(i), it.next());
        }
        for (i = 0; i < 10; i += 2) {
            ListOrderedSet2Test.assertTrue((String)"Must be able to remove int", (boolean)set.remove((Object)Integer.toString(i)));
        }
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            ListOrderedSet2Test.assertEquals((String)"Sequence is wrong after remove ", (Object)Integer.toString(i), it.next());
        }
        for (i = 0; i < 10; ++i) {
            set.add((Object)Integer.toString(i));
        }
        ListOrderedSet2Test.assertEquals((String)"Size of set is wrong!", (int)10, (int)set.size());
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            ListOrderedSet2Test.assertEquals((String)"Sequence is wrong", (Object)Integer.toString(i), it.next());
        }
        for (i = 0; i < 10; i += 2) {
            ListOrderedSet2Test.assertEquals((String)"Sequence is wrong", (Object)Integer.toString(i), it.next());
        }
    }

    public void testListAddRemove() {
        ListOrderedSet<E> set = this.makeObject();
        List view = set.asList();
        set.add((Object)ZERO);
        set.add((Object)ONE);
        set.add((Object)TWO);
        ListOrderedSet2Test.assertEquals((int)3, (int)set.size());
        ListOrderedSet2Test.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSet2Test.assertSame((Object)ONE, (Object)set.get(1));
        ListOrderedSet2Test.assertSame((Object)TWO, (Object)set.get(2));
        ListOrderedSet2Test.assertEquals((int)3, (int)view.size());
        ListOrderedSet2Test.assertSame((Object)ZERO, view.get(0));
        ListOrderedSet2Test.assertSame((Object)ONE, view.get(1));
        ListOrderedSet2Test.assertSame((Object)TWO, view.get(2));
        ListOrderedSet2Test.assertEquals((int)0, (int)set.indexOf((Object)ZERO));
        ListOrderedSet2Test.assertEquals((int)1, (int)set.indexOf((Object)ONE));
        ListOrderedSet2Test.assertEquals((int)2, (int)set.indexOf((Object)TWO));
        set.remove(1);
        ListOrderedSet2Test.assertEquals((int)2, (int)set.size());
        ListOrderedSet2Test.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSet2Test.assertSame((Object)TWO, (Object)set.get(1));
        ListOrderedSet2Test.assertEquals((int)2, (int)view.size());
        ListOrderedSet2Test.assertSame((Object)ZERO, view.get(0));
        ListOrderedSet2Test.assertSame((Object)TWO, view.get(1));
    }

    public void testListAddIndexed() {
        ListOrderedSet<E> set = this.makeObject();
        set.add((Object)ZERO);
        set.add((Object)TWO);
        set.add(1, (Object)ONE);
        ListOrderedSet2Test.assertEquals((int)3, (int)set.size());
        ListOrderedSet2Test.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSet2Test.assertSame((Object)ONE, (Object)set.get(1));
        ListOrderedSet2Test.assertSame((Object)TWO, (Object)set.get(2));
        set.add(0, (Object)ONE);
        ListOrderedSet2Test.assertEquals((int)3, (int)set.size());
        ListOrderedSet2Test.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSet2Test.assertSame((Object)ONE, (Object)set.get(1));
        ListOrderedSet2Test.assertSame((Object)TWO, (Object)set.get(2));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(ZERO);
        list.add(TWO);
        set.addAll(0, list);
        ListOrderedSet2Test.assertEquals((int)3, (int)set.size());
        ListOrderedSet2Test.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSet2Test.assertSame((Object)ONE, (Object)set.get(1));
        ListOrderedSet2Test.assertSame((Object)TWO, (Object)set.get(2));
        list.add(0, THREE);
        set.remove((Object)TWO);
        set.addAll(1, list);
        ListOrderedSet2Test.assertEquals((int)4, (int)set.size());
        ListOrderedSet2Test.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSet2Test.assertSame((Object)THREE, (Object)set.get(1));
        ListOrderedSet2Test.assertSame((Object)TWO, (Object)set.get(2));
        ListOrderedSet2Test.assertSame((Object)ONE, (Object)set.get(3));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

