/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.set.AbstractSortedSetTest;

public abstract class AbstractNavigableSetTest<E>
extends AbstractSortedSetTest<E> {
    public AbstractNavigableSetTest(String name) {
        super(name);
    }

    @Override
    public abstract NavigableSet<E> makeObject();

    @Override
    public NavigableSet<E> makeFullCollection() {
        return (NavigableSet)super.makeFullCollection();
    }

    @Override
    public NavigableSet<E> makeConfirmedCollection() {
        return new TreeSet();
    }

    @Override
    public void verify() {
        super.verify();
        Iterator colliter = this.getCollection().descendingIterator();
        Iterator confiter = this.getConfirmed().descendingIterator();
        while (colliter.hasNext()) {
            Object element = colliter.next();
            Object confelement = confiter.next();
            AbstractNavigableSetTest.assertEquals((String)"Element appears to be out of order.", confelement, element);
            AbstractNavigableSetTest.assertEquals((String)"Incorrect element returned by higher().", this.getConfirmed().higher(element), this.getCollection().higher(element));
            AbstractNavigableSetTest.assertEquals((String)"Incorrect element returned by lower().", this.getConfirmed().lower(element), this.getCollection().lower(element));
            AbstractNavigableSetTest.assertEquals((String)"Incorrect element returned by floor().", this.getConfirmed().floor(element), this.getCollection().floor(element));
            AbstractNavigableSetTest.assertEquals((String)"Incorrect element returned by ceiling().", this.getConfirmed().ceiling(element), this.getCollection().ceiling(element));
        }
    }

    @Override
    public E[] getFullNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 1;
        }
        return elements;
    }

    @Override
    public E[] getOtherNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 2;
        }
        return elements;
    }

    public BulkTest bulkTestNavigableSetSubSet() {
        int length = this.getFullElements().length;
        int lobound = length / 3;
        int hibound = lobound * 2;
        return new TestNavigableSetSubSet(lobound, hibound, false);
    }

    public BulkTest bulkTestNavigableSetHeadSet() {
        int length = this.getFullElements().length;
        int lobound = length / 3;
        int hibound = lobound * 2;
        return new TestNavigableSetSubSet(hibound, true, true);
    }

    public BulkTest bulkTestNavigableSetTailSet() {
        int length = this.getFullElements().length;
        int lobound = length / 3;
        return new TestNavigableSetSubSet(lobound, false, false);
    }

    @Override
    public NavigableSet<E> getCollection() {
        return (NavigableSet)super.getCollection();
    }

    @Override
    public NavigableSet<E> getConfirmed() {
        return (NavigableSet)super.getConfirmed();
    }

    public class TestNavigableSetSubSet
    extends AbstractNavigableSetTest<E> {
        private int m_Type;
        private int m_LowBound;
        private int m_HighBound;
        private E[] m_FullElements;
        private E[] m_OtherElements;
        private boolean m_Inclusive;
        static final int TYPE_SUBSET = 0;
        static final int TYPE_TAILSET = 1;
        static final int TYPE_HEADSET = 2;

        public TestNavigableSetSubSet(int bound, boolean head, boolean inclusive) {
            super("TestNavigableSetSubSet");
            if (head) {
                this.m_Type = 2;
                this.m_Inclusive = inclusive;
                this.m_HighBound = bound;
                int realBound = inclusive ? bound + 1 : bound;
                this.m_FullElements = new Object[realBound];
                System.arraycopy(AbstractNavigableSetTest.this.getFullElements(), 0, this.m_FullElements, 0, realBound);
                this.m_OtherElements = new Object[bound - 1];
                System.arraycopy(AbstractNavigableSetTest.this.getOtherElements(), 0, this.m_OtherElements, 0, bound - 1);
            } else {
                this.m_Type = 1;
                this.m_Inclusive = inclusive;
                this.m_LowBound = bound;
                E[] allelements = AbstractNavigableSetTest.this.getFullElements();
                int realBound = inclusive ? bound : bound + 1;
                this.m_FullElements = new Object[allelements.length - realBound];
                System.arraycopy(allelements, realBound, this.m_FullElements, 0, allelements.length - realBound);
                this.m_OtherElements = new Object[allelements.length - bound - 1];
                System.arraycopy(AbstractNavigableSetTest.this.getOtherElements(), bound, this.m_OtherElements, 0, allelements.length - bound - 1);
            }
        }

        public TestNavigableSetSubSet(int lobound, int hibound, boolean inclusive) {
            super("TestNavigableSetSubSet");
            this.m_Type = 0;
            this.m_LowBound = lobound;
            this.m_HighBound = hibound;
            this.m_Inclusive = inclusive;
            int fullLoBound = inclusive ? lobound : lobound + 1;
            int length = hibound - lobound + 1 - (inclusive ? 0 : 2);
            this.m_FullElements = new Object[length];
            System.arraycopy(AbstractNavigableSetTest.this.getFullElements(), fullLoBound, this.m_FullElements, 0, length);
            int otherLength = hibound - lobound;
            this.m_OtherElements = new Object[otherLength - 1];
            System.arraycopy(AbstractNavigableSetTest.this.getOtherElements(), lobound, this.m_OtherElements, 0, otherLength - 1);
        }

        @Override
        public boolean isNullSupported() {
            return AbstractNavigableSetTest.this.isNullSupported();
        }

        @Override
        public boolean isAddSupported() {
            return AbstractNavigableSetTest.this.isAddSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractNavigableSetTest.this.isRemoveSupported();
        }

        @Override
        public boolean isFailFastSupported() {
            return AbstractNavigableSetTest.this.isFailFastSupported();
        }

        @Override
        public E[] getFullElements() {
            return this.m_FullElements;
        }

        @Override
        public E[] getOtherElements() {
            return this.m_OtherElements;
        }

        private NavigableSet<E> getSubSet(NavigableSet<E> set) {
            E[] elements = AbstractNavigableSetTest.this.getFullElements();
            switch (this.m_Type) {
                case 0: {
                    return set.subSet(elements[this.m_LowBound], this.m_Inclusive, elements[this.m_HighBound], this.m_Inclusive);
                }
                case 2: {
                    return set.headSet(elements[this.m_HighBound], this.m_Inclusive);
                }
                case 1: {
                    return set.tailSet(elements[this.m_LowBound], this.m_Inclusive);
                }
            }
            return null;
        }

        @Override
        public NavigableSet<E> makeObject() {
            return this.getSubSet((NavigableSet)AbstractNavigableSetTest.this.makeObject());
        }

        @Override
        public NavigableSet<E> makeFullCollection() {
            return this.getSubSet((NavigableSet)AbstractNavigableSetTest.this.makeFullCollection());
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public BulkTest bulkTestSortedSetSubSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestSortedSetHeadSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestSortedSetTailSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestNavigableSetSubSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestNavigableSetHeadSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestNavigableSetTailSet() {
            return null;
        }
    }
}

