/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.Collection;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMapTest;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.collections4.multimap.TransformedMultiValuedMap;

public class TransformedMultiValuedMapTest<K, V>
extends AbstractMultiValuedMapTest<K, V> {
    public TransformedMultiValuedMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(TransformedMultiValuedMapTest.class);
    }

    @Override
    public MultiValuedMap<K, V> makeObject() {
        return TransformedMultiValuedMap.transformingMap((MultiValuedMap)new ArrayListValuedHashMap(), (Transformer)TransformerUtils.nopTransformer(), (Transformer)TransformerUtils.nopTransformer());
    }

    public void testKeyTransformedMap() {
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        TransformedMultiValuedMap map = TransformedMultiValuedMap.transformingMap((MultiValuedMap)new ArrayListValuedHashMap(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER, null);
        TransformedMultiValuedMapTest.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            TransformedMultiValuedMapTest.assertEquals((int)(i + 1), (int)map.size());
            TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)Integer.valueOf((String)els[i])));
            TransformedMultiValuedMapTest.assertEquals((boolean)false, (boolean)map.containsKey(els[i]));
            TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsValue(els[i]));
            TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.get((Object)Integer.valueOf((String)els[i])).contains(els[i]));
        }
        Collection coll = map.remove(els[0]);
        TransformedMultiValuedMapTest.assertNotNull((Object)coll);
        TransformedMultiValuedMapTest.assertEquals((int)0, (int)coll.size());
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.remove((Object)Integer.valueOf((String)els[0])).contains(els[0]));
    }

    public void testValueTransformedMap() {
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        TransformedMultiValuedMap map = TransformedMultiValuedMap.transformingMap((MultiValuedMap)new ArrayListValuedHashMap(), null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedMultiValuedMapTest.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            TransformedMultiValuedMapTest.assertEquals((int)(i + 1), (int)map.size());
            TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)Integer.valueOf((String)els[i])));
            TransformedMultiValuedMapTest.assertEquals((boolean)false, (boolean)map.containsValue(els[i]));
            TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsKey(els[i]));
            TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.get(els[i]).contains(Integer.valueOf((String)els[i])));
        }
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.remove(els[0]).contains(Integer.valueOf((String)els[0])));
    }

    public void testFactory_Decorate() {
        ArrayListValuedHashMap base = new ArrayListValuedHashMap();
        base.put((Object)"A", (Object)"1");
        base.put((Object)"B", (Object)"2");
        base.put((Object)"C", (Object)"3");
        TransformedMultiValuedMap trans = TransformedMultiValuedMap.transformingMap((MultiValuedMap)base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedMultiValuedMapTest.assertEquals((int)3, (int)trans.size());
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)trans.get((Object)"A").contains("1"));
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)trans.get((Object)"B").contains("2"));
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)trans.get((Object)"C").contains("3"));
        trans.put((Object)"D", (Object)"4");
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)trans.get((Object)"D").contains(4));
    }

    public void testFactory_decorateTransform() {
        ArrayListValuedHashMap base = new ArrayListValuedHashMap();
        base.put((Object)"A", (Object)"1");
        base.put((Object)"B", (Object)"2");
        base.put((Object)"C", (Object)"3");
        TransformedMultiValuedMap trans = TransformedMultiValuedMap.transformedMap((MultiValuedMap)base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedMultiValuedMapTest.assertEquals((int)3, (int)trans.size());
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)trans.get((Object)"A").contains(1));
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)trans.get((Object)"B").contains(2));
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)trans.get((Object)"C").contains(3));
        trans.put((Object)"D", (Object)"4");
        TransformedMultiValuedMapTest.assertEquals((boolean)true, (boolean)trans.get((Object)"D").contains(4));
    }
}

