/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.UnmodifiableMap;

public class UnmodifiableMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public UnmodifiableMapTest(String testName) {
        super(testName);
    }

    @Override
    public IterableMap<K, V> makeObject() {
        return (IterableMap)UnmodifiableMap.unmodifiableMap(new HashMap());
    }

    @Override
    public boolean isPutChangeSupported() {
        return false;
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public IterableMap<K, V> makeFullMap() {
        HashMap m = new HashMap();
        this.addSampleMappings(m);
        return (IterableMap)UnmodifiableMap.unmodifiableMap(m);
    }

    public void testUnmodifiable() {
        UnmodifiableMapTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableMapTest.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        IterableMap<K, V> map = this.makeFullMap();
        UnmodifiableMapTest.assertSame(map, (Object)UnmodifiableMap.unmodifiableMap(map));
        try {
            UnmodifiableMap.unmodifiableMap(null);
            UnmodifiableMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

