/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.SetUniqueList;

public class SetUniqueListTest<E>
extends AbstractListTest<E> {
    boolean extraVerify = true;

    public SetUniqueListTest(String testName) {
        super(testName);
    }

    @Override
    public List<E> makeObject() {
        return new SetUniqueList(new ArrayList(), new HashSet());
    }

    @Override
    public void testListIteratorSet() {
        this.resetFull();
        ListIterator it = this.getCollection().listIterator();
        it.next();
        try {
            it.set(null);
            SetUniqueListTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public E[] getFullNonNullElements() {
        return new Object[]{new String(""), new String("One"), 2, "Three", 4, new Double(5.0), new Float(6.0f), "Seven", "Eight", new String("Nine"), 10, new Short(11), new Long(12L), "Thirteen", "14", "15", new Byte(16)};
    }

    @Override
    public void testListIteratorAdd() {
        this.resetEmpty();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        E[] elements = this.getOtherElements();
        ListIterator iter1 = list1.listIterator();
        ListIterator iter2 = list2.listIterator();
        for (Object element : elements) {
            iter1.add(element);
            iter2.add(element);
            super.verify();
        }
        this.resetFull();
        iter1 = this.getCollection().listIterator();
        iter2 = this.getConfirmed().listIterator();
        for (Object element : elements) {
            iter1.next();
            iter2.next();
            iter1.add(element);
            iter2.add(element);
            super.verify();
        }
    }

    @Override
    public void testCollectionAddAll() {
        this.resetEmpty();
        E[] elements = this.getFullElements();
        boolean r = this.getCollection().addAll(Arrays.asList(elements));
        this.getConfirmed().addAll(Arrays.asList(elements));
        this.verify();
        SetUniqueListTest.assertTrue((String)"Empty collection should change after addAll", (boolean)r);
        for (Object element : elements) {
            SetUniqueListTest.assertTrue((String)"Collection should contain added element", (boolean)this.getCollection().contains(element));
        }
        this.resetFull();
        int size = this.getCollection().size();
        elements = this.getOtherElements();
        r = this.getCollection().addAll(Arrays.asList(elements));
        this.getConfirmed().addAll(Arrays.asList(elements));
        this.verify();
        SetUniqueListTest.assertTrue((String)"Full collection should change after addAll", (boolean)r);
        for (int i = 0; i < elements.length; ++i) {
            SetUniqueListTest.assertTrue((String)("Full collection should contain added element " + i), (boolean)this.getCollection().contains(elements[i]));
        }
        SetUniqueListTest.assertEquals((String)"Size should increase after addAll", (int)(size + elements.length), (int)this.getCollection().size());
    }

    public void testIntCollectionAddAll() {
        SetUniqueList list = new SetUniqueList(new ArrayList(), new HashSet());
        Integer existingElement = 1;
        list.add(existingElement);
        Integer firstNewElement = 2;
        Integer secondNewElement = 3;
        List<Integer> collection = Arrays.asList(firstNewElement, secondNewElement);
        list.addAll(0, collection);
        SetUniqueListTest.assertEquals((String)"Unique elements should be added.", (int)3, (int)list.size());
        SetUniqueListTest.assertEquals((String)"First new element should be at index 0", (Object)firstNewElement, list.get(0));
        SetUniqueListTest.assertEquals((String)"Second new element should be at index 1", (Object)secondNewElement, list.get(1));
        SetUniqueListTest.assertEquals((String)"Existing element should shift to index 2", (Object)existingElement, list.get(2));
        Integer thirdNewElement = 4;
        collection = Arrays.asList(existingElement, thirdNewElement);
        list.addAll(0, collection);
        SetUniqueListTest.assertEquals((String)"Duplicate element should not be added, unique element should be added.", (int)4, (int)list.size());
        SetUniqueListTest.assertEquals((String)"Third new element should be at index 0", (Object)thirdNewElement, list.get(0));
    }

    @Override
    public void testListSetByIndex() {
        this.resetFull();
        int size = this.getCollection().size();
        this.getCollection().set(0, new Long(1000L));
        SetUniqueListTest.assertEquals((int)size, (int)this.getCollection().size());
        this.getCollection().set(2, new Long(1000L));
        SetUniqueListTest.assertEquals((int)(size - 1), (int)this.getCollection().size());
        SetUniqueListTest.assertEquals((Object)new Long(1000L), this.getCollection().get(1));
    }

    @Override
    public void testCollectionIteratorRemove() {
        try {
            this.extraVerify = false;
            super.testCollectionIteratorRemove();
        }
        finally {
            this.extraVerify = true;
        }
    }

    @Override
    public void verify() {
        super.verify();
        if (this.extraVerify) {
            int size = this.getCollection().size();
            this.getCollection().add(new Long(1000L));
            SetUniqueListTest.assertEquals((int)(size + 1), (int)this.getCollection().size());
            this.getCollection().add(new Long(1000L));
            SetUniqueListTest.assertEquals((int)(size + 1), (int)this.getCollection().size());
            SetUniqueListTest.assertEquals((Object)new Long(1000L), this.getCollection().get(size));
            this.getCollection().remove(size);
        }
    }

    public void testFactory() {
        Integer[] array = new Integer[]{1, 2, 1};
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(array));
        SetUniqueList lset = SetUniqueList.setUniqueList(list);
        SetUniqueListTest.assertEquals((String)"Duplicate element was added.", (int)2, (int)lset.size());
        SetUniqueListTest.assertEquals((Object)1, (Object)lset.get(0));
        SetUniqueListTest.assertEquals((Object)2, (Object)lset.get(1));
        SetUniqueListTest.assertEquals((Object)1, (Object)list.get(0));
        SetUniqueListTest.assertEquals((Object)2, (Object)list.get(1));
    }

    public void testAdd() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        Integer obj = 1;
        lset.add((Object)obj);
        lset.add((Object)obj);
        SetUniqueListTest.assertEquals((String)"Duplicate element was added.", (int)1, (int)lset.size());
        lset.add((Object)2);
        SetUniqueListTest.assertEquals((String)"Unique element was not added.", (int)2, (int)lset.size());
    }

    public void testAddAll() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        lset.addAll(Arrays.asList((Object[])new Integer[]{1, 1}));
        SetUniqueListTest.assertEquals((String)"Duplicate element was added.", (int)1, (int)lset.size());
    }

    public void testSet() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        Integer obj1 = 1;
        Integer obj2 = 2;
        Integer obj3 = 3;
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(0, (Object)obj1);
        SetUniqueListTest.assertEquals((int)2, (int)lset.size());
        SetUniqueListTest.assertSame((Object)obj1, (Object)lset.get(0));
        SetUniqueListTest.assertSame((Object)obj2, (Object)lset.get(1));
        lset.clear();
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(0, (Object)obj2);
        SetUniqueListTest.assertEquals((int)1, (int)lset.size());
        SetUniqueListTest.assertSame((Object)obj2, (Object)lset.get(0));
        lset.clear();
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(0, (Object)obj3);
        SetUniqueListTest.assertEquals((int)2, (int)lset.size());
        SetUniqueListTest.assertSame((Object)obj3, (Object)lset.get(0));
        SetUniqueListTest.assertSame((Object)obj2, (Object)lset.get(1));
        lset.clear();
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(1, (Object)obj1);
        SetUniqueListTest.assertEquals((int)1, (int)lset.size());
        SetUniqueListTest.assertSame((Object)obj1, (Object)lset.get(0));
    }

    public void testListIterator() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        Integer obj1 = 1;
        Integer obj2 = 2;
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        ListIterator it = lset.listIterator();
        while (it.hasNext()) {
            it.next();
            if (it.hasNext()) continue;
            it.add(obj1);
            break;
        }
        SetUniqueListTest.assertEquals((String)"Duplicate element was added", (int)2, (int)lset.size());
    }

    public void testUniqueListReInsert() {
        SetUniqueList l = SetUniqueList.setUniqueList(new LinkedList());
        l.add(new Object());
        l.add(new Object());
        Object a = l.get(0);
        l.set(0, l.get(1));
        SetUniqueListTest.assertEquals((int)1, (int)l.size());
        l.add(1, a);
        SetUniqueListTest.assertEquals((int)2, (int)l.size());
    }

    public void testUniqueListDoubleInsert() {
        SetUniqueList l = SetUniqueList.setUniqueList(new LinkedList());
        l.add(new Object());
        l.add(new Object());
        l.set(0, l.get(1));
        SetUniqueListTest.assertEquals((int)1, (int)l.size());
        l.add(1, l.get(0));
        SetUniqueListTest.assertEquals((int)1, (int)l.size());
    }

    public void testSetDownwardsInList() {
        ArrayList l = new ArrayList();
        HashSet s = new HashSet();
        SetUniqueList ul = new SetUniqueList(l, s);
        Object a = new Object();
        Object b = new Object();
        ul.add(a);
        ul.add(b);
        SetUniqueListTest.assertEquals((Object)a, l.get(0));
        SetUniqueListTest.assertEquals((Object)b, l.get(1));
        SetUniqueListTest.assertTrue((boolean)s.contains(a));
        SetUniqueListTest.assertTrue((boolean)s.contains(b));
        SetUniqueListTest.assertEquals((Object)a, (Object)ul.set(0, b));
        SetUniqueListTest.assertEquals((int)1, (int)s.size());
        SetUniqueListTest.assertEquals((int)1, (int)l.size());
        SetUniqueListTest.assertEquals((Object)b, l.get(0));
        SetUniqueListTest.assertTrue((boolean)s.contains(b));
        SetUniqueListTest.assertFalse((boolean)s.contains(a));
    }

    public void testSetInBiggerList() {
        ArrayList l = new ArrayList();
        HashSet s = new HashSet();
        SetUniqueList ul = new SetUniqueList(l, s);
        Object a = new Object();
        Object b = new Object();
        Object c = new Object();
        ul.add(a);
        ul.add(b);
        ul.add(c);
        SetUniqueListTest.assertEquals((Object)a, l.get(0));
        SetUniqueListTest.assertEquals((Object)b, l.get(1));
        SetUniqueListTest.assertEquals((Object)c, l.get(2));
        SetUniqueListTest.assertTrue((boolean)s.contains(a));
        SetUniqueListTest.assertTrue((boolean)s.contains(b));
        SetUniqueListTest.assertTrue((boolean)s.contains(c));
        SetUniqueListTest.assertEquals((Object)a, (Object)ul.set(0, b));
        SetUniqueListTest.assertEquals((int)2, (int)s.size());
        SetUniqueListTest.assertEquals((int)2, (int)l.size());
        SetUniqueListTest.assertEquals((Object)b, l.get(0));
        SetUniqueListTest.assertEquals((Object)c, l.get(1));
        SetUniqueListTest.assertFalse((boolean)s.contains(a));
        SetUniqueListTest.assertTrue((boolean)s.contains(b));
        SetUniqueListTest.assertTrue((boolean)s.contains(c));
    }

    public void testSetUpwardsInList() {
        ArrayList l = new ArrayList();
        HashSet s = new HashSet();
        SetUniqueList ul = new SetUniqueList(l, s);
        String a = new String("A");
        String b = new String("B");
        String c = new String("C");
        ul.add((Object)a);
        ul.add((Object)b);
        ul.add((Object)c);
        SetUniqueListTest.assertEquals((Object)a, l.get(0));
        SetUniqueListTest.assertEquals((Object)b, l.get(1));
        SetUniqueListTest.assertEquals((Object)c, l.get(2));
        SetUniqueListTest.assertTrue((boolean)s.contains(a));
        SetUniqueListTest.assertTrue((boolean)s.contains(b));
        SetUniqueListTest.assertTrue((boolean)s.contains(c));
        SetUniqueListTest.assertEquals((Object)b, (Object)ul.set(1, (Object)a));
        SetUniqueListTest.assertEquals((int)2, (int)s.size());
        SetUniqueListTest.assertEquals((int)2, (int)l.size());
        SetUniqueListTest.assertEquals((Object)a, l.get(0));
        SetUniqueListTest.assertEquals((Object)c, l.get(1));
        SetUniqueListTest.assertTrue((boolean)s.contains(a));
        SetUniqueListTest.assertFalse((boolean)s.contains(b));
        SetUniqueListTest.assertTrue((boolean)s.contains(c));
    }

    public void testCollections304() {
        LinkedList list = new LinkedList();
        SetUniqueList decoratedList = SetUniqueList.setUniqueList(list);
        String s1 = "Apple";
        String s2 = "Lemon";
        String s3 = "Orange";
        String s4 = "Strawberry";
        decoratedList.add((Object)"Apple");
        decoratedList.add((Object)"Lemon");
        decoratedList.add((Object)"Orange");
        SetUniqueListTest.assertEquals((int)3, (int)decoratedList.size());
        decoratedList.set(1, (Object)"Strawberry");
        SetUniqueListTest.assertEquals((int)3, (int)decoratedList.size());
        decoratedList.add(1, (Object)"Strawberry");
        SetUniqueListTest.assertEquals((int)3, (int)decoratedList.size());
        decoratedList.add(1, (Object)"Lemon");
        SetUniqueListTest.assertEquals((int)4, (int)decoratedList.size());
    }

    public void testSubListIsUnmodifiable() {
        this.resetFull();
        List subList = this.getCollection().subList(1, 3);
        try {
            subList.remove(0);
            SetUniqueListTest.fail((String)"subList should be unmodifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testCollections307() {
        ArrayList list = new ArrayList();
        SetUniqueList uniqueList = SetUniqueList.setUniqueList(list);
        String hello = "Hello";
        String world = "World";
        uniqueList.add("Hello");
        uniqueList.add("World");
        List subList = list.subList(0, 0);
        List subUniqueList = uniqueList.subList(0, 0);
        SetUniqueListTest.assertFalse((boolean)subList.contains("World"));
        SetUniqueListTest.assertFalse((boolean)subUniqueList.contains("World"));
        ArrayList<String> worldList = new ArrayList<String>();
        worldList.add("World");
        SetUniqueListTest.assertFalse((boolean)subList.contains("World"));
        SetUniqueListTest.assertFalse((boolean)subUniqueList.contains("World"));
        list = new ArrayList();
        uniqueList = new SetUniqueList307(list, new TreeSet());
        uniqueList.add("Hello");
        uniqueList.add("World");
        subList = list.subList(0, 0);
        subUniqueList = uniqueList.subList(0, 0);
        SetUniqueListTest.assertFalse((boolean)subList.contains("World"));
        SetUniqueListTest.assertFalse((boolean)subUniqueList.contains("World"));
        worldList = new ArrayList();
        worldList.add("World");
        SetUniqueListTest.assertFalse((boolean)subList.contains("World"));
        SetUniqueListTest.assertFalse((boolean)subUniqueList.contains("World"));
    }

    public void testRetainAll() {
        ArrayList list = new ArrayList(10);
        SetUniqueList uniqueList = SetUniqueList.setUniqueList(list);
        for (int i = 0; i < 10; ++i) {
            uniqueList.add((Object)i);
        }
        ArrayList<Integer> retained = new ArrayList<Integer>(5);
        for (int i = 0; i < 5; ++i) {
            retained.add(i * 2);
        }
        SetUniqueListTest.assertTrue((boolean)uniqueList.retainAll(retained));
        SetUniqueListTest.assertEquals((int)5, (int)uniqueList.size());
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)0));
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)2));
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)4));
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)6));
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)8));
    }

    public void testRetainAllWithInitialList() {
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        for (int i = 0; i < 5; ++i) {
            list.add(i);
        }
        SetUniqueList uniqueList = SetUniqueList.setUniqueList(list);
        for (int i = 5; i < 10; ++i) {
            uniqueList.add((Object)i);
        }
        ArrayList<Integer> retained = new ArrayList<Integer>(5);
        for (int i = 0; i < 5; ++i) {
            retained.add(i * 2);
        }
        SetUniqueListTest.assertTrue((boolean)uniqueList.retainAll(retained));
        SetUniqueListTest.assertEquals((int)5, (int)uniqueList.size());
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)0));
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)2));
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)4));
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)6));
        SetUniqueListTest.assertTrue((boolean)uniqueList.contains((Object)8));
    }

    public void testSetCollections444() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        Integer obj1 = 1;
        Integer obj2 = 2;
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(0, (Object)obj1);
        SetUniqueListTest.assertEquals((int)2, (int)lset.size());
        SetUniqueListTest.assertSame((Object)obj1, (Object)lset.get(0));
        SetUniqueListTest.assertSame((Object)obj2, (Object)lset.get(1));
        SetUniqueListTest.assertTrue((boolean)lset.contains((Object)obj1));
        SetUniqueListTest.assertTrue((boolean)lset.contains((Object)obj2));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    class SetUniqueList307
    extends SetUniqueList<E> {
        private static final long serialVersionUID = 1415013031022962158L;

        public SetUniqueList307(List<E> list, Set<E> set) {
            super(list, set);
        }
    }
}

