/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.junit.Assert;
import org.junit.Test;

public class MultiKeyTest {
    Integer ONE = 1;
    Integer TWO = 2;
    Integer THREE = 3;
    Integer FOUR = 4;
    Integer FIVE = 5;

    @Test
    public void testConstructors() throws Exception {
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)this.TWO);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.ONE, this.TWO}, mk.getKeys()));
        mk = new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.ONE, this.TWO, this.THREE}, mk.getKeys()));
        mk = new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.ONE, this.TWO, this.THREE, this.FOUR}, mk.getKeys()));
        mk = new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR, (Object)this.FIVE);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.ONE, this.TWO, this.THREE, this.FOUR, this.FIVE}, mk.getKeys()));
        mk = new MultiKey((Object[])new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO}, false);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
    }

    @Test
    public void testConstructorsByArray() throws Exception {
        Object[] keys = new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO};
        MultiKey mk = new MultiKey(keys);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys[3] = this.FIVE;
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys = new Integer[]{};
        mk = new MultiKey(keys);
        Assert.assertTrue((boolean)Arrays.equals(new Object[0], mk.getKeys()));
        keys = new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO};
        mk = new MultiKey(keys, true);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys[3] = this.FIVE;
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys = new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO};
        mk = new MultiKey(keys, false);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, mk.getKeys()));
        keys[3] = this.FIVE;
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.THREE, this.FOUR, this.ONE, this.FIVE}, mk.getKeys()));
    }

    @Test
    public void testConstructorsByArrayNull() throws Exception {
        Object[] keys = null;
        try {
            new MultiKey(keys);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new MultiKey(keys, true);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new MultiKey(keys, false);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)2L, (long)new MultiKey((Object)this.ONE, (Object)this.TWO).size());
        Assert.assertEquals((long)2L, (long)new MultiKey(null, null).size());
        Assert.assertEquals((long)3L, (long)new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE).size());
        Assert.assertEquals((long)3L, (long)new MultiKey(null, null, null).size());
        Assert.assertEquals((long)4L, (long)new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR).size());
        Assert.assertEquals((long)4L, (long)new MultiKey(null, null, null, null).size());
        Assert.assertEquals((long)5L, (long)new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR, (Object)this.FIVE).size());
        Assert.assertEquals((long)5L, (long)new MultiKey(null, null, null, null, null).size());
        Assert.assertEquals((long)0L, (long)new MultiKey(new Object[0]).size());
        Assert.assertEquals((long)1L, (long)new MultiKey((Object[])new Integer[]{this.ONE}).size());
        Assert.assertEquals((long)2L, (long)new MultiKey((Object[])new Integer[]{this.ONE, this.TWO}).size());
        Assert.assertEquals((long)7L, (long)new MultiKey((Object[])new Integer[]{this.ONE, this.TWO, this.ONE, this.TWO, this.ONE, this.TWO, this.ONE}).size());
    }

    @Test
    public void testGetIndexed() {
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)this.TWO);
        Assert.assertSame((Object)this.ONE, (Object)mk.getKey(0));
        Assert.assertSame((Object)this.TWO, (Object)mk.getKey(1));
        try {
            mk.getKey(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            mk.getKey(2);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetKeysSimpleConstructor() {
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)this.TWO);
        Object[] array = mk.getKeys();
        Assert.assertSame((Object)this.ONE, (Object)array[0]);
        Assert.assertSame((Object)this.TWO, (Object)array[1]);
        Assert.assertEquals((long)2L, (long)array.length);
    }

    @Test
    public void testGetKeysArrayConstructorCloned() {
        Object[] keys = new Integer[]{this.ONE, this.TWO};
        MultiKey mk = new MultiKey(keys, true);
        Object[] array = mk.getKeys();
        Assert.assertTrue((array != keys ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(array, keys));
        Assert.assertSame((Object)this.ONE, (Object)array[0]);
        Assert.assertSame((Object)this.TWO, (Object)array[1]);
        Assert.assertEquals((long)2L, (long)array.length);
    }

    @Test
    public void testGetKeysArrayConstructorNonCloned() {
        Object[] keys = new Integer[]{this.ONE, this.TWO};
        MultiKey mk = new MultiKey(keys, false);
        Object[] array = mk.getKeys();
        Assert.assertTrue((array != keys ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(array, keys));
        Assert.assertSame((Object)this.ONE, (Object)array[0]);
        Assert.assertSame((Object)this.TWO, (Object)array[1]);
        Assert.assertEquals((long)2L, (long)array.length);
    }

    @Test
    public void testHashCode() {
        MultiKey mk1 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk2 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk3 = new MultiKey((Object)this.ONE, (Object)"TWO");
        Assert.assertTrue((mk1.hashCode() == mk1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mk1.hashCode() == mk2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mk1.hashCode() != mk3.hashCode() ? 1 : 0) != 0);
        int total = 0 ^ this.ONE.hashCode() ^ this.TWO.hashCode();
        Assert.assertEquals((long)total, (long)mk1.hashCode());
    }

    @Test
    public void testEquals() {
        MultiKey mk1 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk2 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk3 = new MultiKey((Object)this.ONE, (Object)"TWO");
        Assert.assertEquals((Object)mk1, (Object)mk1);
        Assert.assertEquals((Object)mk1, (Object)mk2);
        Assert.assertFalse((boolean)mk1.equals((Object)mk3));
        Assert.assertFalse((boolean)mk1.equals((Object)""));
        Assert.assertFalse((boolean)mk1.equals(null));
    }

    @Test
    public void testEqualsAfterSerialization() throws IOException, ClassNotFoundException {
        SystemHashCodeSimulatingKey sysKey = new SystemHashCodeSimulatingKey("test");
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)sysKey);
        HashMap<MultiKey, Integer> map = new HashMap<MultiKey, Integer>();
        map.put(mk, this.TWO);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(sysKey);
        out.writeObject(map);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        sysKey = (SystemHashCodeSimulatingKey)in.readObject();
        Map map2 = (Map)in.readObject();
        in.close();
        Assert.assertEquals((long)2L, (long)sysKey.hashCode());
        MultiKey mk2 = new MultiKey((Object)this.ONE, (Object)sysKey);
        Assert.assertEquals((Object)this.TWO, map2.get(mk2));
    }

    @Test
    public void testEqualsAfterSerializationOfDerivedClass() throws IOException, ClassNotFoundException {
        DerivedMultiKey<String> mk = new DerivedMultiKey<String>("A", "B");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(mk);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        DerivedMultiKey mk2 = (DerivedMultiKey)((Object)in.readObject());
        in.close();
        Assert.assertEquals((long)mk.hashCode(), (long)mk2.hashCode());
    }

    static class DerivedMultiKey<T>
    extends MultiKey<T> {
        private static final long serialVersionUID = 1928896152249821416L;

        public DerivedMultiKey(T key1, T key2) {
            super(key1, key2);
        }

        public T getFirst() {
            return (T)this.getKey(0);
        }

        public T getSecond() {
            return (T)this.getKey(1);
        }
    }

    static class SystemHashCodeSimulatingKey
    implements Serializable {
        private static final long serialVersionUID = -1736147315703444603L;
        private final String name;
        private int hashCode = 1;

        public SystemHashCodeSimulatingKey(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            return obj instanceof SystemHashCodeSimulatingKey && this.name.equals(((SystemHashCodeSimulatingKey)obj).name);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private Object readResolve() {
            this.hashCode = 2;
            return this;
        }
    }
}

