/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.iterators.FilterListIterator;
import org.apache.commons.collections4.list.GrowthList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterListIteratorTest {
    private ArrayList<Integer> list = null;
    private ArrayList<Integer> odds = null;
    private ArrayList<Integer> evens = null;
    private ArrayList<Integer> threes = null;
    private ArrayList<Integer> fours = null;
    private ArrayList<Integer> sixes = null;
    private Predicate<Integer> truePred = null;
    private Predicate<Integer> falsePred = null;
    private Predicate<Integer> evenPred = null;
    private Predicate<Integer> oddPred = null;
    private Predicate<Integer> threePred = null;
    private Predicate<Integer> fourPred = null;
    private final Random random = new Random();

    @Before
    public void setUp() {
        this.list = new ArrayList();
        this.odds = new ArrayList();
        this.evens = new ArrayList();
        this.threes = new ArrayList();
        this.fours = new ArrayList();
        this.sixes = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            this.list.add(i);
            if (i % 2 == 0) {
                this.evens.add(i);
            }
            if (i % 2 != 0) {
                this.odds.add(i);
            }
            if (i % 3 == 0) {
                this.threes.add(i);
            }
            if (i % 4 == 0) {
                this.fours.add(i);
            }
            if (i % 6 != 0) continue;
            this.sixes.add(i);
        }
        this.truePred = new Predicate<Integer>(){

            public boolean evaluate(Integer x) {
                return true;
            }
        };
        this.falsePred = new Predicate<Integer>(){

            public boolean evaluate(Integer x) {
                return true;
            }
        };
        this.evenPred = new Predicate<Integer>(){

            public boolean evaluate(Integer x) {
                return x % 2 == 0;
            }
        };
        this.oddPred = new Predicate<Integer>(){

            public boolean evaluate(Integer x) {
                return x % 2 != 0;
            }
        };
        this.threePred = new Predicate<Integer>(){

            public boolean evaluate(Integer x) {
                return x % 3 == 0;
            }
        };
        this.fourPred = new Predicate<Integer>(){

            public boolean evaluate(Integer x) {
                return x % 4 == 0;
            }
        };
    }

    @After
    public void tearDown() throws Exception {
        this.list = null;
        this.odds = null;
        this.evens = null;
        this.threes = null;
        this.fours = null;
        this.sixes = null;
        this.truePred = null;
        this.falsePred = null;
        this.evenPred = null;
        this.oddPred = null;
        this.threePred = null;
        this.fourPred = null;
    }

    @Test
    public void testWalkLists() {
        this.walkLists(this.list, this.list.listIterator());
    }

    @Test
    public void testManual() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.threePred);
        Assert.assertEquals((Object)0, (Object)filtered.next());
        Assert.assertEquals((Object)3, (Object)filtered.next());
        Assert.assertEquals((Object)6, (Object)filtered.next());
        Assert.assertEquals((Object)9, (Object)filtered.next());
        Assert.assertEquals((Object)12, (Object)filtered.next());
        Assert.assertEquals((Object)15, (Object)filtered.next());
        Assert.assertEquals((Object)18, (Object)filtered.next());
        Assert.assertEquals((Object)18, (Object)filtered.previous());
        Assert.assertEquals((Object)15, (Object)filtered.previous());
        Assert.assertEquals((Object)12, (Object)filtered.previous());
        Assert.assertEquals((Object)9, (Object)filtered.previous());
        Assert.assertEquals((Object)6, (Object)filtered.previous());
        Assert.assertEquals((Object)3, (Object)filtered.previous());
        Assert.assertEquals((Object)0, (Object)filtered.previous());
        Assert.assertTrue((!filtered.hasPrevious() ? 1 : 0) != 0);
        Assert.assertEquals((Object)0, (Object)filtered.next());
        Assert.assertEquals((Object)3, (Object)filtered.next());
        Assert.assertEquals((Object)6, (Object)filtered.next());
        Assert.assertEquals((Object)9, (Object)filtered.next());
        Assert.assertEquals((Object)12, (Object)filtered.next());
        Assert.assertEquals((Object)15, (Object)filtered.next());
        Assert.assertEquals((Object)18, (Object)filtered.next());
        Assert.assertTrue((!filtered.hasNext() ? 1 : 0) != 0);
        Assert.assertEquals((Object)18, (Object)filtered.previous());
        Assert.assertEquals((Object)15, (Object)filtered.previous());
        Assert.assertEquals((Object)12, (Object)filtered.previous());
        Assert.assertEquals((Object)9, (Object)filtered.previous());
        Assert.assertEquals((Object)6, (Object)filtered.previous());
        Assert.assertEquals((Object)3, (Object)filtered.previous());
        Assert.assertEquals((Object)0, (Object)filtered.previous());
        Assert.assertEquals((Object)0, (Object)filtered.next());
        Assert.assertEquals((Object)0, (Object)filtered.previous());
        Assert.assertEquals((Object)0, (Object)filtered.next());
        Assert.assertEquals((Object)3, (Object)filtered.next());
        Assert.assertEquals((Object)6, (Object)filtered.next());
        Assert.assertEquals((Object)6, (Object)filtered.previous());
        Assert.assertEquals((Object)3, (Object)filtered.previous());
        Assert.assertEquals((Object)3, (Object)filtered.next());
        Assert.assertEquals((Object)6, (Object)filtered.next());
        Assert.assertEquals((Object)9, (Object)filtered.next());
        Assert.assertEquals((Object)12, (Object)filtered.next());
        Assert.assertEquals((Object)15, (Object)filtered.next());
        Assert.assertEquals((Object)15, (Object)filtered.previous());
        Assert.assertEquals((Object)12, (Object)filtered.previous());
        Assert.assertEquals((Object)9, (Object)filtered.previous());
    }

    @Test
    public void testTruePredicate() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.truePred);
        this.walkLists(this.list, (ListIterator)filtered);
    }

    @Test
    public void testFalsePredicate() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.falsePred);
        this.walkLists(new ArrayList(), (ListIterator)filtered);
    }

    @Test
    public void testEvens() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.evenPred);
        this.walkLists(this.evens, (ListIterator)filtered);
    }

    @Test
    public void testOdds() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.oddPred);
        this.walkLists(this.odds, (ListIterator)filtered);
    }

    @Test
    public void testThrees() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.threePred);
        this.walkLists(this.threes, (ListIterator)filtered);
    }

    @Test
    public void testFours() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.fourPred);
        this.walkLists(this.fours, (ListIterator)filtered);
    }

    @Test
    public void testNestedSixes() {
        FilterListIterator filtered = new FilterListIterator((ListIterator)new FilterListIterator(this.list.listIterator(), this.threePred), this.evenPred);
        this.walkLists(this.sixes, (ListIterator)filtered);
    }

    @Test
    public void testNestedSixes2() {
        FilterListIterator filtered = new FilterListIterator((ListIterator)new FilterListIterator(this.list.listIterator(), this.evenPred), this.threePred);
        this.walkLists(this.sixes, (ListIterator)filtered);
    }

    @Test
    public void testNestedSixes3() {
        FilterListIterator filtered = new FilterListIterator((ListIterator)new FilterListIterator(this.list.listIterator(), this.threePred), this.evenPred);
        this.walkLists(this.sixes, (ListIterator)new FilterListIterator((ListIterator)filtered, this.truePred));
    }

    @Test
    public void testNextChangesPrevious() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.threePred);
        this.nextNextPrevious(this.threes.listIterator(), (ListIterator<?>)filtered);
        filtered = new FilterListIterator(this.list.listIterator(), this.truePred);
        this.nextNextPrevious(this.list.listIterator(), (ListIterator<?>)filtered);
    }

    @Test
    public void testPreviousChangesNext() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.threePred);
        ListIterator<Integer> expected = this.threes.listIterator();
        this.walkForward(expected, (ListIterator<?>)filtered);
        this.previousPreviousNext(expected, (ListIterator<?>)filtered);
        filtered = new FilterListIterator(this.list.listIterator(), this.truePred);
        expected = this.list.listIterator();
        this.walkForward(expected, (ListIterator<?>)filtered);
        this.previousPreviousNext(expected, (ListIterator<?>)filtered);
    }

    @Test
    public void testFailingHasNextBug() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.fourPred);
        ListIterator<Integer> expected = this.fours.listIterator();
        while (expected.hasNext()) {
            expected.next();
            filtered.next();
        }
        Assert.assertTrue((boolean)filtered.hasPrevious());
        Assert.assertTrue((!filtered.hasNext() ? 1 : 0) != 0);
        Assert.assertEquals((Object)expected.previous(), (Object)filtered.previous());
    }

    @Test
    public void testCollections360() throws Throwable {
        GrowthList var7 = new GrowthList();
        Predicate var9 = PredicateUtils.anyPredicate((Collection)var7);
        FilterListIterator var13 = new FilterListIterator(var9);
        Assert.assertFalse((boolean)var13.hasNext());
        FilterListIterator var14 = new FilterListIterator(var9);
        Assert.assertFalse((boolean)var14.hasPrevious());
    }

    private void walkForward(ListIterator<?> expected, ListIterator<?> testing) {
        while (expected.hasNext()) {
            Assert.assertEquals((long)expected.nextIndex(), (long)testing.nextIndex());
            Assert.assertEquals((long)expected.previousIndex(), (long)testing.previousIndex());
            Assert.assertTrue((boolean)testing.hasNext());
            Assert.assertEquals(expected.next(), testing.next());
        }
    }

    private void walkBackward(ListIterator<?> expected, ListIterator<?> testing) {
        while (expected.hasPrevious()) {
            Assert.assertEquals((long)expected.nextIndex(), (long)testing.nextIndex());
            Assert.assertEquals((long)expected.previousIndex(), (long)testing.previousIndex());
            Assert.assertTrue((boolean)testing.hasPrevious());
            Assert.assertEquals(expected.previous(), testing.previous());
        }
    }

    private void nextNextPrevious(ListIterator<?> expected, ListIterator<?> testing) {
        Assert.assertEquals(expected.next(), testing.next());
        Assert.assertEquals((Object)expected.hasPrevious(), (Object)testing.hasPrevious());
        Object expecteda = expected.next();
        Object testinga = testing.next();
        Assert.assertEquals(expecteda, testinga);
        Object expectedb = expected.previous();
        Object testingb = testing.previous();
        Assert.assertEquals(expecteda, expectedb);
        Assert.assertEquals(testinga, testingb);
    }

    private void previousPreviousNext(ListIterator<?> expected, ListIterator<?> testing) {
        Assert.assertEquals(expected.previous(), testing.previous());
        Assert.assertEquals((Object)expected.hasNext(), (Object)testing.hasNext());
        Object expecteda = expected.previous();
        Object testinga = testing.previous();
        Assert.assertEquals(expecteda, testinga);
        Object expectedb = expected.next();
        Object testingb = testing.next();
        Assert.assertEquals(expecteda, testingb);
        Assert.assertEquals(expecteda, expectedb);
        Assert.assertEquals(testinga, testingb);
    }

    private <E> void walkLists(List<E> list, ListIterator<E> testing) {
        ListIterator<E> expected = list.listIterator();
        this.walkForward(expected, testing);
        this.walkBackward(expected, testing);
        while (expected.hasNext()) {
            Assert.assertEquals((long)expected.nextIndex(), (long)testing.nextIndex());
            Assert.assertEquals((long)expected.previousIndex(), (long)testing.previousIndex());
            Assert.assertTrue((boolean)testing.hasNext());
            Assert.assertEquals(expected.next(), testing.next());
            Assert.assertTrue((boolean)testing.hasPrevious());
            Assert.assertEquals(expected.previous(), testing.previous());
            Assert.assertTrue((boolean)testing.hasNext());
            Assert.assertEquals(expected.next(), testing.next());
        }
        this.walkBackward(expected, testing);
        for (int i = 0; i < list.size(); ++i) {
            int j;
            for (j = 0; j < i; ++j) {
                Assert.assertEquals((long)expected.nextIndex(), (long)testing.nextIndex());
                Assert.assertEquals((long)expected.previousIndex(), (long)testing.previousIndex());
                Assert.assertTrue((boolean)expected.hasNext());
                Assert.assertTrue((boolean)testing.hasNext());
                Assert.assertEquals(expected.next(), testing.next());
            }
            for (j = 0; j < i / 2; ++j) {
                Assert.assertEquals((long)expected.nextIndex(), (long)testing.nextIndex());
                Assert.assertEquals((long)expected.previousIndex(), (long)testing.previousIndex());
                Assert.assertTrue((boolean)expected.hasPrevious());
                Assert.assertTrue((boolean)testing.hasPrevious());
                Assert.assertEquals(expected.previous(), testing.previous());
            }
            for (j = 0; j < i / 2; ++j) {
                Assert.assertEquals((long)expected.nextIndex(), (long)testing.nextIndex());
                Assert.assertEquals((long)expected.previousIndex(), (long)testing.previousIndex());
                Assert.assertTrue((boolean)expected.hasNext());
                Assert.assertTrue((boolean)testing.hasNext());
                Assert.assertEquals(expected.next(), testing.next());
            }
            for (j = 0; j < i; ++j) {
                Assert.assertEquals((long)expected.nextIndex(), (long)testing.nextIndex());
                Assert.assertEquals((long)expected.previousIndex(), (long)testing.previousIndex());
                Assert.assertTrue((boolean)expected.hasPrevious());
                Assert.assertTrue((boolean)testing.hasPrevious());
                Assert.assertEquals(expected.previous(), testing.previous());
            }
        }
        StringBuilder walkdescr = new StringBuilder(500);
        for (int i = 0; i < 500; ++i) {
            if (this.random.nextBoolean()) {
                walkdescr.append("+");
                if (expected.hasNext()) {
                    Assert.assertEquals((String)walkdescr.toString(), expected.next(), testing.next());
                }
            } else {
                walkdescr.append("-");
                if (expected.hasPrevious()) {
                    Assert.assertEquals((String)walkdescr.toString(), expected.previous(), testing.previous());
                }
            }
            Assert.assertEquals((String)walkdescr.toString(), (long)expected.nextIndex(), (long)testing.nextIndex());
            Assert.assertEquals((String)walkdescr.toString(), (long)expected.previousIndex(), (long)testing.previousIndex());
        }
    }
}

