/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.comparators;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.AbstractObjectTest;
import org.junit.Test;

public abstract class AbstractComparatorTest<T>
extends AbstractObjectTest {
    public AbstractComparatorTest(String testName) {
        super(testName);
    }

    public abstract List<T> getComparableObjectsOrdered();

    @Override
    public abstract Comparator<T> makeObject();

    @Override
    public boolean supportsEmptyCollections() {
        return false;
    }

    @Override
    public boolean supportsFullCollections() {
        return false;
    }

    protected void reverseObjects(List<?> list) {
        Collections.reverse(list);
    }

    protected void randomizeObjects(List<?> list) {
        Collections.shuffle(list);
    }

    protected void sortObjects(List<T> list, Comparator<? super T> comparator) {
        Collections.sort(list, comparator);
    }

    @Test
    public void testEmptyListSort() {
        LinkedList list = new LinkedList();
        this.sortObjects(list, (Comparator<? super T>)this.makeObject());
        LinkedList list2 = new LinkedList();
        AbstractComparatorTest.assertTrue((String)"Comparator cannot sort empty lists", (boolean)list2.equals(list));
    }

    @Test
    public void testReverseListSort() {
        Object comparator = this.makeObject();
        List<T> randomList = this.getComparableObjectsOrdered();
        this.reverseObjects(randomList);
        this.sortObjects(randomList, (Comparator<? super T>)comparator);
        List<T> orderedList = this.getComparableObjectsOrdered();
        AbstractComparatorTest.assertTrue((String)"Comparator did not reorder the List correctly", (boolean)orderedList.equals(randomList));
    }

    @Test
    public void testRandomListSort() {
        Object comparator = this.makeObject();
        List<T> randomList = this.getComparableObjectsOrdered();
        this.randomizeObjects(randomList);
        this.sortObjects(randomList, (Comparator<? super T>)comparator);
        List<T> orderedList = this.getComparableObjectsOrdered();
        AbstractComparatorTest.assertTrue((String)"Comparator did not reorder the List correctly", (boolean)orderedList.equals(randomList));
    }

    @Test
    public void testComparatorIsSerializable() {
        Object comparator = this.makeObject();
        AbstractComparatorTest.assertTrue((String)"This comparator should be Serializable.", (boolean)(comparator instanceof Serializable));
    }

    public String getCanonicalComparatorName(Object object) {
        StringBuilder retval = new StringBuilder();
        retval.append("src/test/resources/data/test/");
        String colName = object.getClass().getName();
        colName = colName.substring(colName.lastIndexOf(".") + 1, colName.length());
        retval.append(colName);
        retval.append(".version");
        retval.append(this.getCompatibilityVersion());
        retval.append(".obj");
        return retval.toString();
    }

    @Test
    public void testComparatorCompatibility() throws IOException, ClassNotFoundException {
        if (!this.skipSerializedCanonicalTests()) {
            Comparator comparator = null;
            try {
                comparator = (Comparator)this.readExternalFormFromDisk(this.getCanonicalComparatorName(this.makeObject()));
            }
            catch (FileNotFoundException exception) {
                boolean autoCreateSerialized = false;
                AbstractComparatorTest.fail((String)("The Serialized form could be located to test serialization compatibility: " + exception.getMessage()));
            }
            List<T> randomList = this.getComparableObjectsOrdered();
            this.reverseObjects(randomList);
            this.sortObjects(randomList, comparator);
            List<T> orderedList = this.getComparableObjectsOrdered();
            AbstractComparatorTest.assertTrue((String)"Comparator did not reorder the List correctly", (boolean)orderedList.equals(randomList));
        }
    }
}

