/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.collection.PredicatedCollection;
import org.junit.Assert;
import org.junit.Test;

public class PredicatedCollectionBuilderTest {
    @Test
    public void addPass() {
        PredicatedCollection.Builder builder = PredicatedCollection.notNullBuilder();
        builder.add((Object)"test");
        Assert.assertEquals((long)builder.createPredicatedList().size(), (long)1L);
    }

    @Test
    public void addFail() {
        PredicatedCollection.Builder builder = PredicatedCollection.notNullBuilder();
        builder.add((Object)null);
        Assert.assertTrue((boolean)builder.createPredicatedList().isEmpty());
        Assert.assertEquals((long)1L, (long)builder.rejectedElements().size());
    }

    @Test
    public void addAllPass() {
        PredicatedCollection.Builder builder = PredicatedCollection.notNullBuilder();
        builder.addAll(Arrays.asList("test1", null, "test2"));
        Assert.assertEquals((long)builder.createPredicatedList().size(), (long)2L);
    }

    @Test
    public void createPredicatedCollectionWithNotNullPredicate() {
        PredicatedCollection.Builder builder = PredicatedCollection.notNullBuilder();
        builder.add((Object)"test1");
        builder.add((Object)null);
        List predicatedList = builder.createPredicatedList();
        this.checkPredicatedCollection1(predicatedList);
        Set predicatedSet = builder.createPredicatedSet();
        this.checkPredicatedCollection1(predicatedSet);
        Bag predicatedBag = builder.createPredicatedBag();
        this.checkPredicatedCollection1((Collection<String>)predicatedBag);
        Queue predicatedQueue = builder.createPredicatedQueue();
        this.checkPredicatedCollection1(predicatedQueue);
    }

    private void checkPredicatedCollection1(Collection<String> collection) {
        Assert.assertEquals((long)1L, (long)collection.size());
        collection.add("test2");
        Assert.assertEquals((long)2L, (long)collection.size());
        try {
            collection.add(null);
            Assert.fail((String)"Expecting IllegalArgumentException for failing predicate!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createPredicatedCollectionWithPredicate() {
        OddPredicate p = new OddPredicate();
        PredicatedCollection.Builder builder = PredicatedCollection.builder((Predicate)p);
        builder.add((Object)1);
        builder.add((Object)2);
        builder.add((Object)3);
        List predicatedList = builder.createPredicatedList();
        this.checkPredicatedCollection2(predicatedList);
        Set predicatedSet = builder.createPredicatedSet();
        this.checkPredicatedCollection2(predicatedSet);
        Bag predicatedBag = builder.createPredicatedBag();
        this.checkPredicatedCollection2((Collection<Integer>)predicatedBag);
        Queue predicatedQueue = builder.createPredicatedQueue();
        this.checkPredicatedCollection2(predicatedQueue);
    }

    private void checkPredicatedCollection2(Collection<Integer> collection) {
        Assert.assertEquals((long)2L, (long)collection.size());
        try {
            collection.add(4);
            Assert.fail((String)"Expecting IllegalArgumentException for failing predicate!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)collection.size());
        collection.add(5);
        Assert.assertEquals((long)3L, (long)collection.size());
    }

    private static class OddPredicate
    implements Predicate<Integer> {
        private OddPredicate() {
        }

        public boolean evaluate(Integer value) {
            return value % 2 == 1;
        }
    }
}

