/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.SortedBidiMap;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.bidimap.AbstractSortedBidiMapTest;
import org.apache.commons.collections4.bidimap.DualTreeBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableSortedBidiMap;

public class UnmodifiableSortedBidiMapTest<K extends Comparable<K>, V extends Comparable<V>>
extends AbstractSortedBidiMapTest<K, V> {
    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableSortedBidiMapTest.class);
    }

    public UnmodifiableSortedBidiMapTest(String testName) {
        super(testName);
    }

    @Override
    public SortedBidiMap<K, V> makeObject() {
        return UnmodifiableSortedBidiMap.unmodifiableSortedBidiMap((SortedBidiMap)new DualTreeBidiMap());
    }

    @Override
    public SortedBidiMap<K, V> makeFullMap() {
        DualTreeBidiMap bidi = new DualTreeBidiMap();
        this.addSampleMappings(bidi);
        return UnmodifiableSortedBidiMap.unmodifiableSortedBidiMap((SortedBidiMap)bidi);
    }

    @Override
    public SortedMap<K, V> makeConfirmedMap() {
        return new TreeMap();
    }

    @Override
    public boolean isSubMapViewsSerializable() {
        return false;
    }

    @Override
    public String[] ignoredTests() {
        return new String[]{"UnmodifiableSortedBidiMapTest.bulkTestInverseMap.bulkTestInverseMap"};
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public boolean isAllowNullValue() {
        return false;
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isPutChangeSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    public void testUnmodifiable() {
        UnmodifiableSortedBidiMapTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableSortedBidiMapTest.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        SortedBidiMap<K, V> map = this.makeFullMap();
        UnmodifiableSortedBidiMapTest.assertSame(map, (Object)UnmodifiableSortedBidiMap.unmodifiableSortedBidiMap(map));
        try {
            UnmodifiableSortedBidiMap.unmodifiableSortedBidiMap(null);
            UnmodifiableSortedBidiMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

