/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.bag.CollectionBag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.set.AbstractSetTest;

public abstract class AbstractBagTest<T>
extends AbstractCollectionTest<T> {
    public AbstractBagTest(String testName) {
        super(testName);
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        Collection<T> coll = this.makeConfirmedCollection();
        coll.addAll(Arrays.asList(this.getFullElements()));
        return coll;
    }

    @Override
    public abstract Bag<T> makeObject();

    @Override
    public Bag<T> makeFullCollection() {
        Bag<T> bag = this.makeObject();
        bag.addAll(Arrays.asList(this.getFullElements()));
        return bag;
    }

    @Override
    public void resetEmpty() {
        this.setCollection(CollectionBag.collectionBag(this.makeObject()));
        this.setConfirmed(this.makeConfirmedCollection());
    }

    @Override
    public void resetFull() {
        this.setCollection(CollectionBag.collectionBag(this.makeFullCollection()));
        this.setConfirmed(this.makeConfirmedFullCollection());
    }

    @Override
    public Bag<T> getCollection() {
        return (Bag)super.getCollection();
    }

    public void testBagAdd() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        AbstractBagTest.assertTrue((String)"Should contain 'A'", (boolean)bag.contains((Object)"A"));
        AbstractBagTest.assertEquals((String)"Should have count of 1", (int)1, (int)bag.getCount((Object)"A"));
        bag.add((Object)"A");
        AbstractBagTest.assertTrue((String)"Should contain 'A'", (boolean)bag.contains((Object)"A"));
        AbstractBagTest.assertEquals((String)"Should have count of 2", (int)2, (int)bag.getCount((Object)"A"));
        bag.add((Object)"B");
        AbstractBagTest.assertTrue((boolean)bag.contains((Object)"A"));
        AbstractBagTest.assertTrue((boolean)bag.contains((Object)"B"));
    }

    public void testBagEqualsSelf() {
        Bag<T> bag = this.makeObject();
        AbstractBagTest.assertTrue((boolean)bag.equals(bag));
        if (!this.isAddSupported()) {
            return;
        }
        bag.add((Object)"elt");
        AbstractBagTest.assertTrue((boolean)bag.equals(bag));
        bag.add((Object)"elt");
        AbstractBagTest.assertTrue((boolean)bag.equals(bag));
        bag.add((Object)"elt2");
        AbstractBagTest.assertTrue((boolean)bag.equals(bag));
    }

    public void testBagRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Should have count of 1", (int)1, (int)bag.getCount((Object)"A"));
        bag.remove((Object)"A");
        AbstractBagTest.assertEquals((String)"Should have count of 0", (int)0, (int)bag.getCount((Object)"A"));
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Should have count of 4", (int)4, (int)bag.getCount((Object)"A"));
        bag.remove((Object)"A", 0);
        AbstractBagTest.assertEquals((String)"Should have count of 4", (int)4, (int)bag.getCount((Object)"A"));
        bag.remove((Object)"A", 2);
        AbstractBagTest.assertEquals((String)"Should have count of 2", (int)2, (int)bag.getCount((Object)"A"));
        bag.remove((Object)"A");
        AbstractBagTest.assertEquals((String)"Should have count of 0", (int)0, (int)bag.getCount((Object)"A"));
    }

    public void testBagRemoveAll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A", 2);
        AbstractBagTest.assertEquals((String)"Should have count of 2", (int)2, (int)bag.getCount((Object)"A"));
        bag.add((Object)"B");
        bag.add((Object)"C");
        AbstractBagTest.assertEquals((String)"Should have count of 4", (int)4, (int)bag.size());
        ArrayList<String> delete = new ArrayList<String>();
        delete.add("A");
        delete.add("B");
        bag.removeAll(delete);
        AbstractBagTest.assertEquals((String)"Should have count of 1", (int)1, (int)bag.getCount((Object)"A"));
        AbstractBagTest.assertEquals((String)"Should have count of 0", (int)0, (int)bag.getCount((Object)"B"));
        AbstractBagTest.assertEquals((String)"Should have count of 1", (int)1, (int)bag.getCount((Object)"C"));
        AbstractBagTest.assertEquals((String)"Should have count of 2", (int)2, (int)bag.size());
    }

    public void testBagContains() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        AbstractBagTest.assertEquals((String)"Bag does not have at least 1 'A'", (boolean)false, (boolean)bag.contains((Object)"A"));
        AbstractBagTest.assertEquals((String)"Bag does not have at least 1 'B'", (boolean)false, (boolean)bag.contains((Object)"B"));
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Bag has at least 1 'A'", (boolean)true, (boolean)bag.contains((Object)"A"));
        AbstractBagTest.assertEquals((String)"Bag does not have at least 1 'B'", (boolean)false, (boolean)bag.contains((Object)"B"));
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Bag has at least 1 'A'", (boolean)true, (boolean)bag.contains((Object)"A"));
        AbstractBagTest.assertEquals((String)"Bag does not have at least 1 'B'", (boolean)false, (boolean)bag.contains((Object)"B"));
        bag.add((Object)"B");
        AbstractBagTest.assertEquals((String)"Bag has at least 1 'A'", (boolean)true, (boolean)bag.contains((Object)"A"));
        AbstractBagTest.assertEquals((String)"Bag has at least 1 'B'", (boolean)true, (boolean)bag.contains((Object)"B"));
    }

    public void testBagContainsAll() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        ArrayList known = new ArrayList();
        ArrayList<String> known1A = new ArrayList<String>();
        known1A.add("A");
        ArrayList<String> known2A = new ArrayList<String>();
        known2A.add("A");
        known2A.add("A");
        ArrayList<String> known1B = new ArrayList<String>();
        known1B.add("B");
        ArrayList<String> known1A1B = new ArrayList<String>();
        known1A1B.add("A");
        known1A1B.add("B");
        AbstractBagTest.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 1 'A'", (boolean)false, (boolean)bag.containsAll(known1A));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 2 'A'", (boolean)false, (boolean)bag.containsAll(known2A));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 1 'B'", (boolean)false, (boolean)bag.containsAll(known1B));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)bag.containsAll(known1A1B));
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        AbstractBagTest.assertEquals((String)"Bag containsAll of 1 'A'", (boolean)true, (boolean)bag.containsAll(known1A));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 2 'A'", (boolean)false, (boolean)bag.containsAll(known2A));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 1 'B'", (boolean)false, (boolean)bag.containsAll(known1B));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)bag.containsAll(known1A1B));
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        AbstractBagTest.assertEquals((String)"Bag containsAll of 1 'A'", (boolean)true, (boolean)bag.containsAll(known1A));
        AbstractBagTest.assertEquals((String)"Bag containsAll of 2 'A'", (boolean)true, (boolean)bag.containsAll(known2A));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 1 'B'", (boolean)false, (boolean)bag.containsAll(known1B));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)bag.containsAll(known1A1B));
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        AbstractBagTest.assertEquals((String)"Bag containsAll of 1 'A'", (boolean)true, (boolean)bag.containsAll(known1A));
        AbstractBagTest.assertEquals((String)"Bag containsAll of 2 'A'", (boolean)true, (boolean)bag.containsAll(known2A));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 1 'B'", (boolean)false, (boolean)bag.containsAll(known1B));
        AbstractBagTest.assertEquals((String)"Bag does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)bag.containsAll(known1A1B));
        bag.add((Object)"B");
        AbstractBagTest.assertEquals((String)"Bag containsAll of empty", (boolean)true, (boolean)bag.containsAll(known));
        AbstractBagTest.assertEquals((String)"Bag containsAll of 1 'A'", (boolean)true, (boolean)bag.containsAll(known1A));
        AbstractBagTest.assertEquals((String)"Bag containsAll of 2 'A'", (boolean)true, (boolean)bag.containsAll(known2A));
        AbstractBagTest.assertEquals((String)"Bag containsAll of 1 'B'", (boolean)true, (boolean)bag.containsAll(known1B));
        AbstractBagTest.assertEquals((String)"Bag containsAll of 1 'A' 1 'B'", (boolean)true, (boolean)bag.containsAll(known1A1B));
    }

    public void testBagSize() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        AbstractBagTest.assertEquals((String)"Should have 0 total items", (int)0, (int)bag.size());
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Should have 1 total items", (int)1, (int)bag.size());
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Should have 2 total items", (int)2, (int)bag.size());
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((String)"Should have 3 total items", (int)3, (int)bag.size());
        bag.add((Object)"B");
        AbstractBagTest.assertEquals((String)"Should have 4 total items", (int)4, (int)bag.size());
        bag.add((Object)"B");
        AbstractBagTest.assertEquals((String)"Should have 5 total items", (int)5, (int)bag.size());
        bag.remove((Object)"A", 2);
        AbstractBagTest.assertEquals((String)"Should have 1 'A'", (int)1, (int)bag.getCount((Object)"A"));
        AbstractBagTest.assertEquals((String)"Should have 3 total items", (int)3, (int)bag.size());
        bag.remove((Object)"B");
        AbstractBagTest.assertEquals((String)"Should have 1 total item", (int)1, (int)bag.size());
    }

    public void testBagRetainAll() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        ArrayList<String> retains = new ArrayList<String>();
        retains.add("B");
        retains.add("C");
        bag.retainAll(retains);
        AbstractBagTest.assertEquals((String)"Should have 2 total items", (int)2, (int)bag.size());
    }

    public void testBagIterator() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        AbstractBagTest.assertEquals((String)"Bag should have 3 items", (int)3, (int)bag.size());
        Iterator i = bag.iterator();
        boolean foundA = false;
        while (i.hasNext()) {
            String element = (String)i.next();
            if (!element.equals("A")) continue;
            if (!foundA) {
                foundA = true;
                continue;
            }
            i.remove();
        }
        AbstractBagTest.assertTrue((String)"Bag should still contain 'A'", (boolean)bag.contains((Object)"A"));
        AbstractBagTest.assertEquals((String)"Bag should have 2 items", (int)2, (int)bag.size());
        AbstractBagTest.assertEquals((String)"Bag should have 1 'A'", (int)1, (int)bag.getCount((Object)"A"));
    }

    public void testBagIteratorFail() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Iterator it = bag.iterator();
        it.next();
        bag.remove((Object)"A");
        try {
            it.next();
            AbstractBagTest.fail((String)"Should throw ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void testBagIteratorFailNoMore() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Iterator it = bag.iterator();
        it.next();
        it.next();
        it.next();
        try {
            it.next();
            AbstractBagTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testBagIteratorFailDoubleRemove() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        Iterator it = bag.iterator();
        it.next();
        it.next();
        AbstractBagTest.assertEquals((int)3, (int)bag.size());
        it.remove();
        AbstractBagTest.assertEquals((int)2, (int)bag.size());
        try {
            it.remove();
            AbstractBagTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbstractBagTest.assertEquals((int)2, (int)bag.size());
        it.next();
        it.remove();
        AbstractBagTest.assertEquals((int)1, (int)bag.size());
    }

    public void testBagIteratorRemoveProtectsInvariants() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((int)2, (int)bag.size());
        Iterator it = bag.iterator();
        AbstractBagTest.assertEquals((Object)"A", it.next());
        AbstractBagTest.assertEquals((boolean)true, (boolean)it.hasNext());
        it.remove();
        AbstractBagTest.assertEquals((int)1, (int)bag.size());
        AbstractBagTest.assertEquals((boolean)true, (boolean)it.hasNext());
        AbstractBagTest.assertEquals((Object)"A", it.next());
        AbstractBagTest.assertEquals((boolean)false, (boolean)it.hasNext());
        it.remove();
        AbstractBagTest.assertEquals((int)0, (int)bag.size());
        AbstractBagTest.assertEquals((boolean)false, (boolean)it.hasNext());
        Iterator it2 = bag.iterator();
        AbstractBagTest.assertEquals((boolean)false, (boolean)it2.hasNext());
    }

    public void testBagToArray() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        Object[] array = bag.toArray();
        int a = 0;
        int b = 0;
        int c = 0;
        for (Object element : array) {
            a += element.equals("A") ? 1 : 0;
            b += element.equals("B") ? 1 : 0;
            c += element.equals("C") ? 1 : 0;
        }
        AbstractBagTest.assertEquals((int)2, (int)a);
        AbstractBagTest.assertEquals((int)2, (int)b);
        AbstractBagTest.assertEquals((int)1, (int)c);
    }

    public void testBagToArrayPopulate() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        String[] array = (String[])bag.toArray((Object[])new String[0]);
        int a = 0;
        int b = 0;
        int c = 0;
        for (String element : array) {
            a += element.equals("A") ? 1 : 0;
            b += element.equals("B") ? 1 : 0;
            c += element.equals("C") ? 1 : 0;
        }
        AbstractBagTest.assertEquals((int)2, (int)a);
        AbstractBagTest.assertEquals((int)2, (int)b);
        AbstractBagTest.assertEquals((int)1, (int)c);
    }

    public void testBagEquals() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        Bag<T> bag2 = this.makeObject();
        AbstractBagTest.assertEquals((boolean)true, (boolean)bag.equals(bag2));
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((boolean)false, (boolean)bag.equals(bag2));
        bag2.add((Object)"A");
        AbstractBagTest.assertEquals((boolean)true, (boolean)bag.equals(bag2));
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        bag2.add((Object)"A");
        bag2.add((Object)"B");
        bag2.add((Object)"B");
        bag2.add((Object)"C");
        AbstractBagTest.assertEquals((boolean)true, (boolean)bag.equals(bag2));
    }

    public void testBagEqualsHashBag() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        HashBag bag2 = new HashBag();
        AbstractBagTest.assertEquals((boolean)true, (boolean)bag.equals((Object)bag2));
        bag.add((Object)"A");
        AbstractBagTest.assertEquals((boolean)false, (boolean)bag.equals((Object)bag2));
        bag2.add((Object)"A");
        AbstractBagTest.assertEquals((boolean)true, (boolean)bag.equals((Object)bag2));
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        bag2.add((Object)"A");
        bag2.add((Object)"B");
        bag2.add((Object)"B");
        bag2.add((Object)"C");
        AbstractBagTest.assertEquals((boolean)true, (boolean)bag.equals((Object)bag2));
    }

    public void testBagHashCode() {
        if (!this.isAddSupported()) {
            return;
        }
        Bag<T> bag = this.makeObject();
        Bag<T> bag2 = this.makeObject();
        AbstractBagTest.assertEquals((int)0, (int)bag.hashCode());
        AbstractBagTest.assertEquals((int)0, (int)bag2.hashCode());
        AbstractBagTest.assertEquals((int)bag.hashCode(), (int)bag2.hashCode());
        bag.add((Object)"A");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"B");
        bag.add((Object)"C");
        bag2.add((Object)"A");
        bag2.add((Object)"A");
        bag2.add((Object)"B");
        bag2.add((Object)"B");
        bag2.add((Object)"C");
        AbstractBagTest.assertEquals((int)bag.hashCode(), (int)bag2.hashCode());
        int total = 0;
        total += "A".hashCode() ^ 2;
        total += "B".hashCode() ^ 2;
        AbstractBagTest.assertEquals((int)(total += "C".hashCode() ^ 1), (int)bag.hashCode());
        AbstractBagTest.assertEquals((int)total, (int)bag2.hashCode());
    }

    public BulkTest bulkTestBagUniqueSet() {
        return new TestBagUniqueSet();
    }

    public void testEmptyBagCompatibility() throws IOException, ClassNotFoundException {
        Bag<T> bag = this.makeObject();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(bag));
            AbstractBagTest.assertTrue((String)"Bag is empty", (bag2.size() == 0 ? 1 : 0) != 0);
            AbstractBagTest.assertEquals(bag, (Object)bag2);
        }
    }

    public void testFullBagCompatibility() throws IOException, ClassNotFoundException {
        Bag<T> bag = this.makeFullCollection();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(bag));
            AbstractBagTest.assertEquals((String)"Bag is the right size", (int)bag.size(), (int)bag2.size());
            AbstractBagTest.assertEquals(bag, (Object)bag2);
        }
    }

    public class TestBagUniqueSet
    extends AbstractSetTest<T> {
        public TestBagUniqueSet() {
            super("");
        }

        @Override
        public T[] getFullElements() {
            return AbstractBagTest.this.getFullElements();
        }

        @Override
        public T[] getOtherElements() {
            return AbstractBagTest.this.getOtherElements();
        }

        @Override
        public Set<T> makeObject() {
            return AbstractBagTest.this.makeObject().uniqueSet();
        }

        @Override
        public Set<T> makeFullCollection() {
            return AbstractBagTest.this.makeFullCollection().uniqueSet();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractBagTest.this.isNullSupported();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetEmpty() {
            AbstractBagTest.this.resetEmpty();
            this.setCollection(AbstractBagTest.this.getCollection().uniqueSet());
            this.setConfirmed(new HashSet(AbstractBagTest.this.getConfirmed()));
        }

        @Override
        public void resetFull() {
            AbstractBagTest.this.resetFull();
            this.setCollection(AbstractBagTest.this.getCollection().uniqueSet());
            this.setConfirmed(new HashSet(AbstractBagTest.this.getConfirmed()));
        }

        @Override
        public void verify() {
            super.verify();
        }
    }
}

