/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.list.PredicatedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListUtilsTest {
    private static final String a = "a";
    private static final String b = "b";
    private static final String c = "c";
    private static final String d = "d";
    private static final String e = "e";
    private static final String x = "x";
    private String[] fullArray;
    private List<String> fullList;
    private static Predicate<Number> EQUALS_TWO = new Predicate<Number>(){

        public boolean evaluate(Number input) {
            return input.intValue() == 2;
        }
    };

    @Before
    public void setUp() {
        this.fullArray = new String[]{a, b, c, d, e};
        this.fullList = new ArrayList<String>(Arrays.asList(this.fullArray));
    }

    @Test
    public void testIntersectNonEmptyWithEmptyList() {
        List empty = Collections.emptyList();
        Assert.assertTrue((String)"result not empty", (boolean)ListUtils.intersection(empty, this.fullList).isEmpty());
    }

    @Test
    public void testIntersectEmptyWithEmptyList() {
        List empty = Collections.EMPTY_LIST;
        Assert.assertTrue((String)"result not empty", (boolean)ListUtils.intersection((List)empty, (List)empty).isEmpty());
    }

    @Test
    public void testIntersectNonEmptySubset() {
        ArrayList<String> other = new ArrayList<String>(this.fullList);
        Assert.assertNotNull(other.remove(0));
        Assert.assertNotNull(other.remove(1));
        Assert.assertEquals(other, (Object)ListUtils.intersection(this.fullList, other));
    }

    @Test
    public void testIntersectListWithNoOverlapAndDifferentTypes() {
        List<Integer> other = Arrays.asList(1, 23);
        Assert.assertTrue((boolean)ListUtils.intersection(this.fullList, other).isEmpty());
    }

    @Test
    public void testIntersectListWithSelf() {
        Assert.assertEquals(this.fullList, (Object)ListUtils.intersection(this.fullList, this.fullList));
    }

    @Test
    public void testIntersectionOrderInsensitivity() {
        ArrayList<String> one = new ArrayList<String>();
        ArrayList<String> two = new ArrayList<String>();
        one.add(a);
        one.add(b);
        two.add(a);
        two.add(a);
        two.add(b);
        two.add(b);
        Assert.assertEquals((Object)ListUtils.intersection(one, two), (Object)ListUtils.intersection(two, one));
    }

    @Test
    public void testPredicatedList() {
        Predicate<Object> predicate = new Predicate<Object>(){

            public boolean evaluate(Object o) {
                return o instanceof String;
            }
        };
        List list = ListUtils.predicatedList(new ArrayList(), (Predicate)predicate);
        Assert.assertTrue((String)"returned object should be a PredicatedList", (boolean)(list instanceof PredicatedList));
        try {
            ListUtils.predicatedList(new ArrayList(), null);
            Assert.fail((String)"Expecting IllegalArgumentException for null predicate.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            ListUtils.predicatedList(null, (Predicate)predicate);
            Assert.fail((String)"Expecting IllegalArgumentException for null list.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testLazyList() {
        List list = ListUtils.lazyList(new ArrayList(), (Factory)new Factory<Integer>(){
            private int index;

            public Integer create() {
                ++this.index;
                return this.index;
            }
        });
        Assert.assertNotNull(list.get(5));
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertNotNull(list.get(5));
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testEmptyIfNull() {
        Assert.assertTrue((boolean)ListUtils.emptyIfNull(null).isEmpty());
        ArrayList list = new ArrayList();
        Assert.assertSame(list, (Object)ListUtils.emptyIfNull(list));
    }

    @Test
    public void testDefaultIfNull() {
        Assert.assertTrue((boolean)ListUtils.defaultIfNull(null, Collections.emptyList()).isEmpty());
        ArrayList list = new ArrayList();
        Assert.assertSame(list, (Object)ListUtils.defaultIfNull(list, Collections.emptyList()));
    }

    @Test
    public void testEquals() {
        List<String> data = Arrays.asList(a, b, c);
        ArrayList<String> a = new ArrayList<String>(data);
        ArrayList<String> b = new ArrayList<String>(data);
        Assert.assertEquals((Object)true, (Object)a.equals(b));
        Assert.assertEquals((Object)true, (Object)ListUtils.isEqualList(a, b));
        a.clear();
        Assert.assertEquals((Object)false, (Object)ListUtils.isEqualList(a, b));
        Assert.assertEquals((Object)false, (Object)ListUtils.isEqualList(a, null));
        Assert.assertEquals((Object)false, (Object)ListUtils.isEqualList(null, b));
        Assert.assertEquals((Object)true, (Object)ListUtils.isEqualList(null, null));
    }

    @Test
    public void testHashCode() {
        List<String> data = Arrays.asList(a, b, c);
        ArrayList<String> a = new ArrayList<String>(data);
        ArrayList<String> b = new ArrayList<String>(data);
        Assert.assertEquals((Object)true, (Object)(a.hashCode() == b.hashCode() ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(a.hashCode() == ListUtils.hashCodeForList(a) ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(b.hashCode() == ListUtils.hashCodeForList(b) ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(ListUtils.hashCodeForList(a) == ListUtils.hashCodeForList(b) ? 1 : 0));
        a.clear();
        Assert.assertEquals((Object)false, (Object)(ListUtils.hashCodeForList(a) == ListUtils.hashCodeForList(b) ? 1 : 0));
        Assert.assertEquals((long)0L, (long)ListUtils.hashCodeForList(null));
    }

    @Test
    public void testRetainAll() {
        ArrayList<String> sub = new ArrayList<String>();
        sub.add(a);
        sub.add(b);
        sub.add(x);
        List retained = ListUtils.retainAll(this.fullList, sub);
        Assert.assertTrue((retained.size() == 2 ? 1 : 0) != 0);
        sub.remove(x);
        Assert.assertTrue((boolean)retained.equals(sub));
        this.fullList.retainAll(sub);
        Assert.assertTrue((boolean)retained.equals(this.fullList));
        try {
            ListUtils.retainAll(null, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAll() {
        ArrayList<String> sub = new ArrayList<String>();
        sub.add(a);
        sub.add(b);
        sub.add(x);
        List remainder = ListUtils.removeAll(this.fullList, sub);
        Assert.assertTrue((remainder.size() == 3 ? 1 : 0) != 0);
        this.fullList.removeAll(sub);
        Assert.assertTrue((boolean)remainder.equals(this.fullList));
        try {
            ListUtils.removeAll(null, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testSubtract() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(a);
        list.add(b);
        list.add(a);
        list.add(x);
        ArrayList<String> sub = new ArrayList<String>();
        sub.add(a);
        List result = ListUtils.subtract(list, sub);
        Assert.assertTrue((result.size() == 3 ? 1 : 0) != 0);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(b);
        expected.add(a);
        expected.add(x);
        Assert.assertEquals(expected, (Object)result);
        try {
            ListUtils.subtract(list, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testSubtractNullElement() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(a);
        list.add(null);
        list.add(null);
        list.add(x);
        ArrayList<Object> sub = new ArrayList<Object>();
        sub.add(null);
        List result = ListUtils.subtract(list, sub);
        Assert.assertTrue((result.size() == 3 ? 1 : 0) != 0);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(a);
        expected.add(null);
        expected.add(x);
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testIndexOf() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)d);
        int index = ListUtils.indexOf(this.fullList, (Predicate)testPredicate);
        Assert.assertEquals((Object)d, (Object)this.fullList.get(index));
        testPredicate = EqualPredicate.equalPredicate((Object)"de");
        index = ListUtils.indexOf(this.fullList, (Predicate)testPredicate);
        Assert.assertEquals((long)index, (long)-1L);
        Assert.assertEquals((long)ListUtils.indexOf(null, (Predicate)testPredicate), (long)-1L);
        Assert.assertEquals((long)ListUtils.indexOf(this.fullList, null), (long)-1L);
    }

    @Test
    public void testLongestCommonSubsequence() {
        try {
            ListUtils.longestCommonSubsequence((List)null, null);
            Assert.fail((String)"failed to check for null argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            ListUtils.longestCommonSubsequence(Arrays.asList(Character.valueOf('A')), null);
            Assert.fail((String)"failed to check for null argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            ListUtils.longestCommonSubsequence(null, Arrays.asList(Character.valueOf('A')));
            Assert.fail((String)"failed to check for null argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        List lcs = ListUtils.longestCommonSubsequence((List)Collections.EMPTY_LIST, (List)Collections.EMPTY_LIST);
        Assert.assertEquals((long)0L, (long)lcs.size());
        List<Character> list1 = Arrays.asList(Character.valueOf('B'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        List<Character> list2 = Arrays.asList(Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('S'));
        lcs = ListUtils.longestCommonSubsequence(list1, list2);
        List<Character> expected = Arrays.asList(Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        Assert.assertEquals(expected, (Object)lcs);
        List<Character> list3 = Arrays.asList(Character.valueOf('A'), Character.valueOf('T'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        lcs = ListUtils.longestCommonSubsequence(list1, list3);
        expected = Arrays.asList(Character.valueOf('A'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        Assert.assertEquals(expected, (Object)lcs);
        List<Character> listZorro = Arrays.asList(Character.valueOf('Z'), Character.valueOf('O'), Character.valueOf('R'), Character.valueOf('R'), Character.valueOf('O'));
        lcs = ListUtils.longestCommonSubsequence(list1, listZorro);
        Assert.assertTrue((boolean)lcs.isEmpty());
    }

    @Test
    public void testLongestCommonSubsequenceWithString() {
        try {
            ListUtils.longestCommonSubsequence((CharSequence)null, null);
            Assert.fail((String)"failed to check for null argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            ListUtils.longestCommonSubsequence((CharSequence)"A", null);
            Assert.fail((String)"failed to check for null argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            ListUtils.longestCommonSubsequence(null, (CharSequence)"A");
            Assert.fail((String)"failed to check for null argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String lcs = ListUtils.longestCommonSubsequence((CharSequence)"", (CharSequence)"");
        Assert.assertEquals((long)0L, (long)lcs.length());
        String banana = "BANANA";
        String ananas = "ANANAS";
        lcs = ListUtils.longestCommonSubsequence((CharSequence)"BANANA", (CharSequence)"ANANAS");
        Assert.assertEquals((Object)"ANANA", (Object)lcs);
        String atana = "ATANA";
        lcs = ListUtils.longestCommonSubsequence((CharSequence)"BANANA", (CharSequence)"ATANA");
        Assert.assertEquals((Object)"AANA", (Object)lcs);
        String zorro = "ZORRO";
        lcs = ListUtils.longestCommonSubsequence((CharSequence)"BANANA", (CharSequence)"ZORRO");
        Assert.assertEquals((long)0L, (long)lcs.length());
    }

    @Test
    public void testPartition() {
        ArrayList<Integer> strings = new ArrayList<Integer>();
        for (int i = 0; i <= 6; ++i) {
            strings.add(i);
        }
        List partition = ListUtils.partition(strings, (int)3);
        Assert.assertNotNull((Object)partition);
        Assert.assertEquals((long)3L, (long)partition.size());
        Assert.assertEquals((long)1L, (long)((List)partition.get(2)).size());
        try {
            ListUtils.partition(null, (int)3);
            Assert.fail((String)"failed to check for null argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            ListUtils.partition(strings, (int)0);
            Assert.fail((String)"failed to check for size argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ListUtils.partition(strings, (int)-10);
            Assert.fail((String)"failed to check for size argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List partitionMax = ListUtils.partition(strings, (int)Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)partitionMax.size());
        Assert.assertEquals((long)strings.size(), (long)((List)partitionMax.get(0)).size());
        Assert.assertEquals(strings, partitionMax.get(0));
    }

    @Test
    public void testSelect() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        List output1 = ListUtils.select(list, EQUALS_TWO);
        List output2 = ListUtils.select(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.select(list, EQUALS_TWO, new HashSet());
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)output1.size());
        Assert.assertEquals((Object)2, output2.iterator().next());
    }

    @Test
    public void testSelectRejected() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(1L);
        list.add(2L);
        list.add(3L);
        list.add(4L);
        List output1 = ListUtils.selectRejected(list, EQUALS_TWO);
        List output2 = ListUtils.selectRejected(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.selectRejected(list, EQUALS_TWO, new HashSet());
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output2));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)3L, (long)output1.size());
        Assert.assertTrue((boolean)output1.contains(1L));
        Assert.assertTrue((boolean)output1.contains(3L));
        Assert.assertTrue((boolean)output1.contains(4L));
    }
}

