/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.set.AbstractNavigableSetTest;
import org.apache.commons.collections4.set.PredicatedNavigableSet;

public class PredicatedNavigableSetTest<E>
extends AbstractNavigableSetTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = new Predicate<E>(){

        public boolean evaluate(E o) {
            return o instanceof String && ((String)o).startsWith("A");
        }
    };

    public PredicatedNavigableSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(PredicatedNavigableSetTest.class);
    }

    @Override
    public NavigableSet<E> makeObject() {
        return PredicatedNavigableSet.predicatedNavigableSet(new TreeSet(), this.truePredicate);
    }

    @Override
    public NavigableSet<E> makeFullCollection() {
        TreeSet set = new TreeSet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return PredicatedNavigableSet.predicatedNavigableSet(set, this.truePredicate);
    }

    protected PredicatedNavigableSet<E> makeTestSet() {
        return PredicatedNavigableSet.predicatedNavigableSet(new TreeSet(), this.testPredicate);
    }

    public void testGetSet() {
        PredicatedNavigableSet<E> set = this.makeTestSet();
        PredicatedNavigableSetTest.assertTrue((String)"returned set should not be null", (set.decorated() != null ? 1 : 0) != 0);
    }

    public void testIllegalAdd() {
        PredicatedNavigableSet<String> set = this.makeTestSet();
        String testString = "B";
        try {
            set.add("B");
            PredicatedNavigableSetTest.fail((String)"Should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedNavigableSetTest.assertTrue((String)"Collection shouldn't contain illegal element", (!set.contains("B") ? 1 : 0) != 0);
    }

    public void testIllegalAddAll() {
        PredicatedNavigableSet set = this.makeTestSet();
        TreeSet<String> elements = new TreeSet<String>();
        elements.add("Aone");
        elements.add("Atwo");
        elements.add("Bthree");
        elements.add("Afour");
        try {
            set.addAll(elements);
            PredicatedNavigableSetTest.fail((String)"Should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedNavigableSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("Aone") ? 1 : 0) != 0);
        PredicatedNavigableSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("Atwo") ? 1 : 0) != 0);
        PredicatedNavigableSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("Bthree") ? 1 : 0) != 0);
        PredicatedNavigableSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("Afour") ? 1 : 0) != 0);
    }

    public void testComparator() {
        PredicatedNavigableSet<E> set = this.makeTestSet();
        Comparator c = set.comparator();
        PredicatedNavigableSetTest.assertTrue((String)"natural order, so comparator should be null", (c == null ? 1 : 0) != 0);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }
}

