/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.map.AbstractMapTest;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.collections4.multiset.AbstractMultiSetTest;
import org.apache.commons.collections4.set.AbstractSetTest;

public abstract class AbstractMultiValuedMapTest<K, V>
extends AbstractObjectTest {
    protected MultiValuedMap<K, V> map;
    protected MultiValuedMap<K, V> confirmed;

    public AbstractMultiValuedMapTest(String testName) {
        super(testName);
    }

    public abstract MultiValuedMap<K, V> makeObject();

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }

    public boolean isAddSupported() {
        return true;
    }

    public boolean isRemoveSupported() {
        return true;
    }

    public boolean isAllowNullKey() {
        return true;
    }

    @Override
    public boolean isTestSerialization() {
        return true;
    }

    public K[] getSampleKeys() {
        Object[] result = new Object[]{"one", "one", "two", "two", "three", "three"};
        return result;
    }

    public V[] getSampleValues() {
        Object[] result = new Object[]{"uno", "un", "dos", "deux", "tres", "trois"};
        return result;
    }

    protected MultiValuedMap<K, V> makeFullMap() {
        MultiValuedMap<K, V> map = this.makeObject();
        this.addSampleMappings(map);
        return map;
    }

    protected void addSampleMappings(MultiValuedMap<? super K, ? super V> map) {
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
    }

    public MultiValuedMap<K, V> makeConfirmedMap() {
        return new ArrayListValuedHashMap();
    }

    public MultiValuedMap<K, V> getConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(MultiValuedMap<K, V> map) {
        this.confirmed = map;
    }

    public MultiValuedMap<K, V> getMap() {
        return this.map;
    }

    public void resetEmpty() {
        this.map = this.makeObject();
        this.confirmed = this.makeConfirmedMap();
    }

    public void resetFull() {
        this.map = this.makeFullMap();
        this.confirmed = this.makeConfirmedMap();
        K[] k = this.getSampleKeys();
        V[] v = this.getSampleValues();
        for (int i = 0; i < k.length; ++i) {
            this.confirmed.put(k[i], v[i]);
        }
    }

    public void testNoMappingReturnsEmptyCol() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        AbstractMultiValuedMapTest.assertTrue((boolean)map.get((Object)"whatever").isEmpty());
    }

    public void testMultipleValues() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        Collection col = map.get((Object)"one");
        AbstractMultiValuedMapTest.assertTrue((boolean)col.contains("uno"));
        AbstractMultiValuedMapTest.assertTrue((boolean)col.contains("un"));
    }

    public void testGet() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        AbstractMultiValuedMapTest.assertTrue((boolean)map.get((Object)"one").contains("uno"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.get((Object)"one").contains("un"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.get((Object)"two").contains("dos"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.get((Object)"two").contains("deux"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.get((Object)"three").contains("tres"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.get((Object)"three").contains("trois"));
    }

    public void testAddMappingThroughGet() {
        if (!this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        MultiValuedMap<K, V> map = this.getMap();
        Collection col1 = map.get((Object)"one");
        Collection col2 = map.get((Object)"one");
        AbstractMultiValuedMapTest.assertTrue((boolean)col1.isEmpty());
        AbstractMultiValuedMapTest.assertTrue((boolean)col2.isEmpty());
        AbstractMultiValuedMapTest.assertEquals((int)0, (int)map.size());
        col1.add("uno");
        col2.add("un");
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsKey((Object)"one"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsMapping((Object)"one", (Object)"uno"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsMapping((Object)"one", (Object)"un"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsValue((Object)"uno"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsValue((Object)"un"));
        AbstractMultiValuedMapTest.assertTrue((boolean)col1.contains("un"));
        AbstractMultiValuedMapTest.assertTrue((boolean)col2.contains("uno"));
    }

    public void testRemoveMappingThroughGet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        MultiValuedMap<K, V> map = this.getMap();
        Collection col = map.get((Object)"one");
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)col.size());
        AbstractMultiValuedMapTest.assertEquals((int)6, (int)map.size());
        col.remove("uno");
        col.remove("un");
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsKey((Object)"one"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsMapping((Object)"one", (Object)"uno"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsMapping((Object)"one", (Object)"un"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsValue((Object)"uno"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsValue((Object)"un"));
        AbstractMultiValuedMapTest.assertEquals((int)4, (int)map.size());
        col = map.remove((Object)"one");
        AbstractMultiValuedMapTest.assertNotNull((Object)col);
        AbstractMultiValuedMapTest.assertEquals((int)0, (int)col.size());
    }

    public void testRemoveMappingThroughGetIterator() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        MultiValuedMap<K, V> map = this.getMap();
        Iterator it = map.get((Object)"one").iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsKey((Object)"one"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsMapping((Object)"one", (Object)"uno"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsMapping((Object)"one", (Object)"un"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsValue((Object)"uno"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsValue((Object)"un"));
        AbstractMultiValuedMapTest.assertEquals((int)4, (int)map.size());
        Collection coll = map.remove((Object)"one");
        AbstractMultiValuedMapTest.assertNotNull((Object)coll);
        AbstractMultiValuedMapTest.assertEquals((int)0, (int)coll.size());
    }

    public void testContainsValue() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsValue((Object)"uno"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsValue((Object)"un"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsValue((Object)"dos"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsValue((Object)"deux"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsValue((Object)"tres"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsValue((Object)"trois"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsValue((Object)"quatro"));
    }

    public void testKeyContainsValue() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsMapping((Object)"one", (Object)"uno"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsMapping((Object)"one", (Object)"un"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsMapping((Object)"two", (Object)"dos"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsMapping((Object)"two", (Object)"deux"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsMapping((Object)"three", (Object)"tres"));
        AbstractMultiValuedMapTest.assertTrue((boolean)map.containsMapping((Object)"three", (Object)"trois"));
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsMapping((Object)"four", (Object)"quatro"));
    }

    public void testValues() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        HashSet<String> expected = new HashSet<String>();
        expected.add("uno");
        expected.add("dos");
        expected.add("tres");
        expected.add("un");
        expected.add("deux");
        expected.add("trois");
        Collection c = map.values();
        AbstractMultiValuedMapTest.assertEquals((int)6, (int)c.size());
        AbstractMultiValuedMapTest.assertEquals(expected, new HashSet(c));
    }

    public void testRemoveAllViaValuesIterator() {
        if (!this.isRemoveSupported()) {
            return;
        }
        MultiValuedMap<K, V> map = this.makeFullMap();
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        AbstractMultiValuedMapTest.assertTrue((boolean)map.get((Object)"one").isEmpty());
        AbstractMultiValuedMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testRemoveViaValuesRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        MultiValuedMap<K, V> map = this.makeFullMap();
        Collection values = map.values();
        values.remove("uno");
        values.remove("un");
        AbstractMultiValuedMapTest.assertFalse((boolean)map.containsKey((Object)"one"));
        AbstractMultiValuedMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testEntriesCollectionIterator() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        ArrayList values = new ArrayList(map.values());
        for (Map.Entry entry : map.entries()) {
            AbstractMultiValuedMapTest.assertTrue((boolean)map.containsMapping(entry.getKey(), entry.getValue()));
            AbstractMultiValuedMapTest.assertTrue((boolean)values.contains(entry.getValue()));
            if (!this.isRemoveSupported()) continue;
            AbstractMultiValuedMapTest.assertTrue((boolean)values.remove(entry.getValue()));
        }
        if (this.isRemoveSupported()) {
            AbstractMultiValuedMapTest.assertTrue((boolean)values.isEmpty());
        }
    }

    public void testRemoveAllViaEntriesIterator() {
        if (!this.isRemoveSupported()) {
            return;
        }
        MultiValuedMap<K, V> map = this.makeFullMap();
        Iterator i = map.entries().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        AbstractMultiValuedMapTest.assertTrue((boolean)map.get((Object)"one").isEmpty());
        AbstractMultiValuedMapTest.assertEquals((int)0, (int)map.size());
    }

    public void testSize() {
        AbstractMultiValuedMapTest.assertEquals((int)6, (int)this.makeFullMap().size());
    }

    public void testMapEquals() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiValuedMap<K, V> one = this.makeObject();
        Integer value = 1;
        one.put((Object)"One", (Object)value);
        one.removeMapping((Object)"One", (Object)value);
        MultiValuedMap<K, V> two = this.makeObject();
        AbstractMultiValuedMapTest.assertEquals(two, one);
    }

    public void testSizeWithPutRemove() {
        if (!this.isRemoveSupported() || !this.isAddSupported()) {
            return;
        }
        MultiValuedMap<K, V> map = this.makeObject();
        AbstractMultiValuedMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)"AA");
        AbstractMultiValuedMapTest.assertEquals((int)1, (int)map.size());
        map.put((Object)"B", (Object)"BA");
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)map.size());
        map.put((Object)"B", (Object)"BB");
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)map.size());
        map.put((Object)"B", (Object)"BC");
        AbstractMultiValuedMapTest.assertEquals((int)4, (int)map.size());
        map.remove((Object)"A");
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)map.size());
        map.removeMapping((Object)"B", (Object)"BC");
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)map.size());
    }

    public void testKeySetSize() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)map.keySet().size());
    }

    public void testSize_Key() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)map.get((Object)"one").size());
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)map.get((Object)"two").size());
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)map.get((Object)"three").size());
        if (!this.isAddSupported()) {
            return;
        }
        map.put((Object)"A", (Object)"AA");
        AbstractMultiValuedMapTest.assertEquals((int)1, (int)map.get((Object)"A").size());
        map.put((Object)"B", (Object)"BA");
        AbstractMultiValuedMapTest.assertEquals((int)1, (int)map.get((Object)"A").size());
        AbstractMultiValuedMapTest.assertEquals((int)1, (int)map.get((Object)"B").size());
        map.put((Object)"B", (Object)"BB");
        AbstractMultiValuedMapTest.assertEquals((int)1, (int)map.get((Object)"A").size());
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)map.get((Object)"B").size());
        map.put((Object)"B", (Object)"BC");
        AbstractMultiValuedMapTest.assertEquals((int)1, (int)map.get((Object)"A").size());
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)map.get((Object)"B").size());
        if (!this.isRemoveSupported()) {
            return;
        }
        map.remove((Object)"A");
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)map.get((Object)"B").size());
        map.removeMapping((Object)"B", (Object)"BC");
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)map.get((Object)"B").size());
    }

    public void testContainsValue_Key() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"one", (Object)"uno"));
        AbstractMultiValuedMapTest.assertEquals((boolean)false, (boolean)map.containsMapping((Object)"two", (Object)"2"));
        if (!this.isAddSupported()) {
            return;
        }
        map.put((Object)"A", (Object)"AA");
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"AA"));
        AbstractMultiValuedMapTest.assertEquals((boolean)false, (boolean)map.containsMapping((Object)"A", (Object)"AB"));
    }

    public void testPutAll_Map1() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiValuedMap<K, V> original = this.makeObject();
        original.put((Object)"key", (Object)"object1");
        original.put((Object)"key", (Object)"object2");
        MultiValuedMap<K, V> test = this.makeObject();
        test.put((Object)"keyA", (Object)"objectA");
        test.put((Object)"key", (Object)"object0");
        test.putAll(original);
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)test.keySet().size());
        AbstractMultiValuedMapTest.assertEquals((int)4, (int)test.size());
        AbstractMultiValuedMapTest.assertEquals((int)1, (int)test.get((Object)"keyA").size());
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)test.get((Object)"key").size());
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"objectA"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object0"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object1"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object2"));
    }

    public void testPutAll_Map2() {
        if (!this.isAddSupported()) {
            return;
        }
        HashMap<String, String> original = new HashMap<String, String>();
        original.put("keyX", "object1");
        original.put("keyY", "object2");
        MultiValuedMap<K, V> test = this.makeObject();
        test.put((Object)"keyA", (Object)"objectA");
        test.put((Object)"keyX", (Object)"object0");
        test.putAll(original);
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)test.keySet().size());
        AbstractMultiValuedMapTest.assertEquals((int)4, (int)test.size());
        AbstractMultiValuedMapTest.assertEquals((int)1, (int)test.get((Object)"keyA").size());
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)test.get((Object)"keyX").size());
        AbstractMultiValuedMapTest.assertEquals((int)1, (int)test.get((Object)"keyY").size());
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"objectA"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object0"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object1"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object2"));
    }

    public void testPutAll_KeyIterable() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiValuedMap<K, V> map = this.makeObject();
        List<String> coll = Arrays.asList("X", "Y", "Z");
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.putAll((Object)"A", coll));
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)map.get((Object)"A").size());
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"X"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"Y"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"Z"));
        try {
            map.putAll((Object)"A", null);
            AbstractMultiValuedMapTest.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)map.get((Object)"A").size());
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"X"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"Y"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"Z"));
        AbstractMultiValuedMapTest.assertEquals((boolean)false, (boolean)map.putAll((Object)"A", new ArrayList()));
        AbstractMultiValuedMapTest.assertEquals((int)3, (int)map.get((Object)"A").size());
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"X"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"Y"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"Z"));
        coll = Arrays.asList("M");
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.putAll((Object)"A", coll));
        AbstractMultiValuedMapTest.assertEquals((int)4, (int)map.get((Object)"A").size());
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"X"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"Y"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"Z"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.containsMapping((Object)"A", (Object)"M"));
    }

    public void testRemove_KeyItem() {
        if (!this.isRemoveSupported() || !this.isAddSupported()) {
            return;
        }
        MultiValuedMap<K, V> map = this.makeObject();
        map.put((Object)"A", (Object)"AA");
        map.put((Object)"A", (Object)"AB");
        map.put((Object)"A", (Object)"AC");
        AbstractMultiValuedMapTest.assertEquals((boolean)false, (boolean)map.removeMapping((Object)"C", (Object)"CA"));
        AbstractMultiValuedMapTest.assertEquals((boolean)false, (boolean)map.removeMapping((Object)"A", (Object)"AD"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.removeMapping((Object)"A", (Object)"AC"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.removeMapping((Object)"A", (Object)"AB"));
        AbstractMultiValuedMapTest.assertEquals((boolean)true, (boolean)map.removeMapping((Object)"A", (Object)"AA"));
    }

    public void testKeysMultiSet() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        MultiSet keyMultiSet = map.keys();
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)keyMultiSet.getCount((Object)"one"));
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)keyMultiSet.getCount((Object)"two"));
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)keyMultiSet.getCount((Object)"three"));
        AbstractMultiValuedMapTest.assertEquals((int)6, (int)keyMultiSet.size());
    }

    public void testKeysBagIterator() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        ArrayList col = new ArrayList();
        Iterator it = map.keys().iterator();
        while (it.hasNext()) {
            col.add(it.next());
        }
        HashBag bag = new HashBag(col);
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)bag.getCount((Object)"one"));
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)bag.getCount((Object)"two"));
        AbstractMultiValuedMapTest.assertEquals((int)2, (int)bag.getCount((Object)"three"));
        AbstractMultiValuedMapTest.assertEquals((int)6, (int)bag.size());
    }

    public void testKeysBagContainsAll() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        MultiSet keyMultiSet = map.keys();
        List<String> col = Arrays.asList("one", "two", "three", "one", "two", "three");
        AbstractMultiValuedMapTest.assertTrue((boolean)keyMultiSet.containsAll(col));
    }

    public void testAsMapGet() {
        this.resetEmpty();
        Map mapCol = this.getMap().asMap();
        AbstractMultiValuedMapTest.assertNull(mapCol.get("one"));
        AbstractMultiValuedMapTest.assertEquals((int)0, (int)mapCol.size());
        this.resetFull();
        mapCol = this.getMap().asMap();
        Collection col = (Collection)mapCol.get("one");
        AbstractMultiValuedMapTest.assertNotNull((Object)col);
        AbstractMultiValuedMapTest.assertTrue((boolean)col.contains("un"));
        AbstractMultiValuedMapTest.assertTrue((boolean)col.contains("uno"));
    }

    public void testAsMapRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Map mapCol = this.getMap().asMap();
        mapCol.remove("one");
        AbstractMultiValuedMapTest.assertFalse((boolean)this.getMap().containsKey((Object)"one"));
        AbstractMultiValuedMapTest.assertEquals((int)4, (int)this.getMap().size());
    }

    public void testMapIterator() {
        this.resetEmpty();
        MapIterator mapIt = this.getMap().mapIterator();
        AbstractMultiValuedMapTest.assertFalse((boolean)mapIt.hasNext());
        this.resetFull();
        mapIt = this.getMap().mapIterator();
        while (mapIt.hasNext()) {
            Object key = mapIt.next();
            Object value = mapIt.getValue();
            AbstractMultiValuedMapTest.assertTrue((boolean)this.getMap().containsMapping(key, value));
        }
    }

    public void testMapIteratorRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        MapIterator mapIt = this.getMap().mapIterator();
        while (mapIt.hasNext()) {
            mapIt.next();
            mapIt.remove();
        }
        AbstractMultiValuedMapTest.assertTrue((boolean)this.getMap().isEmpty());
    }

    public void testMapIteratorUnsupportedSet() {
        this.resetFull();
        MapIterator mapIt = this.getMap().mapIterator();
        mapIt.next();
        try {
            mapIt.setValue((Object)"some value");
            AbstractMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testEmptyMapCompatibility() throws Exception {
        MultiValuedMap<K, V> map = this.makeObject();
        MultiValuedMap map2 = (MultiValuedMap)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(map));
        AbstractMultiValuedMapTest.assertEquals((String)"Map is empty", (int)0, (int)map2.size());
    }

    public void testFullMapCompatibility() throws Exception {
        MultiValuedMap<K, V> map = this.makeFullMap();
        MultiValuedMap map2 = (MultiValuedMap)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(map));
        AbstractMultiValuedMapTest.assertEquals((String)"Map is the right size", (int)map.size(), (int)map2.size());
        for (Object key : map.keySet()) {
            AbstractMultiValuedMapTest.assertTrue((String)"Map had inequal elements", (boolean)CollectionUtils.isEqualCollection((Collection)map.get(key), (Collection)map2.get(key)));
            if (!this.isRemoveSupported()) continue;
            map2.remove(key);
        }
        if (this.isRemoveSupported()) {
            AbstractMultiValuedMapTest.assertEquals((String)"Map had extra values", (int)0, (int)map2.size());
        }
    }

    public BulkTest bulkTestMultiValuedMapEntries() {
        return new TestMultiValuedMapEntries();
    }

    public BulkTest bulkTestMultiValuedMapKeySet() {
        return new TestMultiValuedMapKeySet();
    }

    public BulkTest bulkTestMultiValuedMapValues() {
        return new TestMultiValuedMapValues();
    }

    public BulkTest bulkTestMultiValuedMapKeys() {
        return new TestMultiValuedMapKeys();
    }

    public BulkTest bulkTestAsMap() {
        return new TestMultiValuedMapAsMap();
    }

    public class TestMultiValuedMapAsMap
    extends AbstractMapTest<K, Collection<V>> {
        public TestMultiValuedMapAsMap() {
            super("");
        }

        @Override
        public Map<K, Collection<V>> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().asMap();
        }

        @Override
        public Map<K, Collection<V>> makeFullMap() {
            return AbstractMultiValuedMapTest.this.makeFullMap().asMap();
        }

        @Override
        public K[] getSampleKeys() {
            K[] samplekeys = AbstractMultiValuedMapTest.this.getSampleKeys();
            Object[] finalKeys = new Object[3];
            for (int i = 0; i < 3; ++i) {
                finalKeys[i] = samplekeys[i * 2];
            }
            return finalKeys;
        }

        public Collection<V>[] getSampleValues() {
            boolean isSetValuedMap = AbstractMultiValuedMapTest.this.makeObject() instanceof SetValuedMap;
            V[] sampleValues = AbstractMultiValuedMapTest.this.getSampleValues();
            Collection[] colArr = new Collection[3];
            for (int i = 0; i < 3; ++i) {
                List<Object> coll = Arrays.asList(sampleValues[i * 2], sampleValues[i * 2 + 1]);
                colArr[i] = isSetValuedMap ? new HashSet<Object>(coll) : coll;
            }
            return colArr;
        }

        public Collection<V>[] getNewSampleValues() {
            boolean isSetValuedMap = AbstractMultiValuedMapTest.this.makeObject() instanceof SetValuedMap;
            Object[] sampleValues = new Object[]{"ein", "ek", "zwei", "duey", "drei", "teen"};
            Collection[] colArr = new Collection[3];
            for (int i = 0; i < 3; ++i) {
                List<Object> coll = Arrays.asList(sampleValues[i * 2], sampleValues[i * 2 + 1]);
                colArr[i] = isSetValuedMap ? new HashSet<Object>(coll) : coll;
            }
            return colArr;
        }

        @Override
        public boolean isAllowNullKey() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isPutAddSupported() {
            return false;
        }

        @Override
        public boolean isPutChangeSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiValuedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean areEqualElementsDistinguishable() {
            return true;
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }
    }

    public class TestMultiValuedMapKeys
    extends AbstractMultiSetTest<K> {
        public TestMultiValuedMapKeys() {
            super("");
        }

        @Override
        public K[] getFullElements() {
            return AbstractMultiValuedMapTest.this.getSampleKeys();
        }

        @Override
        public MultiSet<K> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().keys();
        }

        @Override
        public MultiSet<K> makeFullCollection() {
            return AbstractMultiValuedMapTest.this.makeFullMap().keys();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetFull() {
            AbstractMultiValuedMapTest.this.resetFull();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().keys());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().keys());
        }

        @Override
        public void resetEmpty() {
            AbstractMultiValuedMapTest.this.resetEmpty();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().keys());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().keys());
        }
    }

    public class TestMultiValuedMapValues
    extends AbstractCollectionTest<V> {
        public TestMultiValuedMapValues() {
            super("");
        }

        @Override
        public V[] getFullElements() {
            return AbstractMultiValuedMapTest.this.getSampleValues();
        }

        @Override
        public Collection<V> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().values();
        }

        @Override
        public Collection<V> makeFullCollection() {
            return AbstractMultiValuedMapTest.this.makeFullMap().values();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiValuedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetFull() {
            AbstractMultiValuedMapTest.this.resetFull();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().values());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().values());
        }

        @Override
        public void resetEmpty() {
            AbstractMultiValuedMapTest.this.resetEmpty();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().values());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().values());
        }

        @Override
        public Collection<V> makeConfirmedCollection() {
            return null;
        }

        @Override
        public Collection<V> makeConfirmedFullCollection() {
            return null;
        }
    }

    public class TestMultiValuedMapKeySet
    extends AbstractSetTest<K> {
        public TestMultiValuedMapKeySet() {
            super("");
        }

        @Override
        public K[] getFullElements() {
            return AbstractMultiValuedMapTest.this.makeFullMap().keySet().toArray();
        }

        @Override
        public Set<K> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().keySet();
        }

        @Override
        public Set<K> makeFullCollection() {
            return AbstractMultiValuedMapTest.this.makeFullMap().keySet();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiValuedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }
    }

    public class TestMultiValuedMapEntries
    extends AbstractCollectionTest<Map.Entry<K, V>> {
        public TestMultiValuedMapEntries() {
            super("");
        }

        public Map.Entry<K, V>[] getFullElements() {
            return AbstractMultiValuedMapTest.this.makeFullMap().entries().toArray(new Map.Entry[0]);
        }

        @Override
        public Collection<Map.Entry<K, V>> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().entries();
        }

        @Override
        public Collection<Map.Entry<K, V>> makeFullCollection() {
            return AbstractMultiValuedMapTest.this.makeFullMap().entries();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiValuedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetFull() {
            AbstractMultiValuedMapTest.this.resetFull();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().entries());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().entries());
        }

        @Override
        public void resetEmpty() {
            AbstractMultiValuedMapTest.this.resetEmpty();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().entries());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().entries());
        }

        @Override
        public Collection<Map.Entry<K, V>> makeConfirmedCollection() {
            return null;
        }

        @Override
        public Collection<Map.Entry<K, V>> makeConfirmedFullCollection() {
            return null;
        }
    }
}

