/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.map.UnmodifiableSortedMap;

public class UnmodifiableSortedMapTest<K, V>
extends AbstractSortedMapTest<K, V> {
    public UnmodifiableSortedMapTest(String testName) {
        super(testName);
    }

    @Override
    public SortedMap<K, V> makeObject() {
        return UnmodifiableSortedMap.unmodifiableSortedMap(new TreeMap());
    }

    @Override
    public boolean isPutChangeSupported() {
        return false;
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public SortedMap<K, V> makeFullMap() {
        TreeMap m = new TreeMap();
        this.addSampleMappings(m);
        return UnmodifiableSortedMap.unmodifiableSortedMap(m);
    }

    public void testUnmodifiable() {
        UnmodifiableSortedMapTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableSortedMapTest.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        Map map = this.makeFullMap();
        UnmodifiableSortedMapTest.assertSame((Object)map, (Object)UnmodifiableSortedMap.unmodifiableSortedMap((SortedMap)map));
        try {
            UnmodifiableSortedMap.unmodifiableSortedMap(null);
            UnmodifiableSortedMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

