/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.Map;
import org.apache.commons.collections4.keyvalue.AbstractMapEntryTest;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.junit.Assert;
import org.junit.Test;

public class DefaultMapEntryTest<K, V>
extends AbstractMapEntryTest<K, V> {
    @Override
    public Map.Entry<K, V> makeMapEntry() {
        return new DefaultMapEntry(null, null);
    }

    @Override
    public Map.Entry<K, V> makeMapEntry(K key, V value) {
        return new DefaultMapEntry(key, value);
    }

    @Override
    @Test
    public void testConstructors() {
        DefaultMapEntry entry = new DefaultMapEntry((Object)"name", (Object)"duke");
        Assert.assertSame((Object)"name", entry.getKey());
        Assert.assertSame((Object)"duke", entry.getValue());
        DefaultKeyValue pair = new DefaultKeyValue((Object)"name", (Object)"duke");
        Assert.assertSame((Object)"name", (Object)pair.getKey());
        Assert.assertSame((Object)"duke", (Object)pair.getValue());
        DefaultMapEntry entry2 = new DefaultMapEntry((Map.Entry)entry);
        Assert.assertSame((Object)"name", entry2.getKey());
        Assert.assertSame((Object)"duke", entry2.getValue());
        entry.setValue(null);
        Assert.assertSame((Object)"duke", entry2.getValue());
    }

    @Override
    public void testSelfReferenceHandling() {
        Map.Entry<K, Map.Entry<K, V>> entry = this.makeMapEntry();
        try {
            entry.setValue(entry);
            Assert.assertSame(entry, entry.getValue());
        }
        catch (Exception e) {
            Assert.fail((String)"This Map.Entry implementation supports value self-reference.");
        }
    }
}

