/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractMapEntryTest<K, V> {
    protected final String key = "name";
    protected final String value = "duke";

    public Map.Entry<K, V> makeMapEntry() {
        return this.makeMapEntry(null, null);
    }

    public abstract Map.Entry<K, V> makeMapEntry(K var1, V var2);

    public Map.Entry<K, V> makeKnownMapEntry() {
        return this.makeKnownMapEntry(null, null);
    }

    public Map.Entry<K, V> makeKnownMapEntry(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        Map.Entry entry = map.entrySet().iterator().next();
        return entry;
    }

    @Test
    public void testAccessorsAndMutators() {
        Map.Entry<String, String> entry = this.makeMapEntry("name", "duke");
        Assert.assertTrue((entry.getKey() == "name" ? 1 : 0) != 0);
        entry.setValue("duke");
        Assert.assertTrue((entry.getValue() == "duke" ? 1 : 0) != 0);
        entry = this.makeMapEntry(null, null);
        Assert.assertTrue((entry.getKey() == null ? 1 : 0) != 0);
        entry.setValue(null);
        Assert.assertTrue((entry.getValue() == null ? 1 : 0) != 0);
    }

    @Test
    public void testSelfReferenceHandling() {
        Map.Entry<K, Map.Entry<K, V>> entry = this.makeMapEntry();
        try {
            entry.setValue(entry);
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((entry.getKey() == null && entry.getValue() == null ? 1 : 0) != 0);
        }
    }

    public abstract void testConstructors();

    @Test
    public void testEqualsAndHashCode() {
        Map.Entry<String, String> e1 = this.makeMapEntry("name", "duke");
        Map.Entry<String, String> e2 = this.makeKnownMapEntry("name", "duke");
        Assert.assertTrue((boolean)e1.equals(e1));
        Assert.assertTrue((boolean)e2.equals(e1));
        Assert.assertTrue((boolean)e1.equals(e2));
        Assert.assertTrue((e1.hashCode() == e2.hashCode() ? 1 : 0) != 0);
        e1 = this.makeMapEntry();
        e2 = this.makeKnownMapEntry();
        Assert.assertTrue((boolean)e1.equals(e1));
        Assert.assertTrue((boolean)e2.equals(e1));
        Assert.assertTrue((boolean)e1.equals(e2));
        Assert.assertTrue((e1.hashCode() == e2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Map.Entry<String, String> entry = this.makeMapEntry("name", "duke");
        Assert.assertTrue((boolean)entry.toString().equals(entry.getKey() + "=" + entry.getValue()));
        entry = this.makeMapEntry();
        Assert.assertTrue((boolean)entry.toString().equals(entry.getKey() + "=" + entry.getValue()));
    }
}

