/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.PermutationIterator;

public class PermutationIteratorTest
extends AbstractIteratorTest<List<Character>> {
    protected Character[] testArray = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C')};
    protected List<Character> testList;

    public PermutationIteratorTest(String testName) {
        super(testName);
    }

    public void setUp() {
        this.testList = new ArrayList<Character>();
        this.testList.addAll(Arrays.asList(this.testArray));
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public boolean supportsEmptyIterator() {
        return false;
    }

    @Override
    public PermutationIterator<Character> makeEmptyIterator() {
        return new PermutationIterator(new ArrayList());
    }

    @Override
    public PermutationIterator<Character> makeObject() {
        return new PermutationIterator(this.testList);
    }

    public void testPermutationResultSize() {
        int factorial = 1;
        int i = 0;
        while (i < 8) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int j = 0; j < i; ++j) {
                list.add(j);
            }
            PermutationIterator it = new PermutationIterator(list);
            int count = 0;
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            PermutationIteratorTest.assertEquals((int)factorial, (int)count);
            factorial *= ++i;
        }
    }

    public void testPermutationExhaustivity() {
        ArrayList<Character> perm1 = new ArrayList<Character>();
        ArrayList<Character> perm2 = new ArrayList<Character>();
        ArrayList<Character> perm3 = new ArrayList<Character>();
        ArrayList<Character> perm4 = new ArrayList<Character>();
        ArrayList<Character> perm5 = new ArrayList<Character>();
        ArrayList<Character> perm6 = new ArrayList<Character>();
        perm1.add(Character.valueOf('A'));
        perm2.add(Character.valueOf('A'));
        perm3.add(Character.valueOf('B'));
        perm4.add(Character.valueOf('B'));
        perm5.add(Character.valueOf('C'));
        perm6.add(Character.valueOf('C'));
        perm1.add(Character.valueOf('B'));
        perm2.add(Character.valueOf('C'));
        perm3.add(Character.valueOf('A'));
        perm4.add(Character.valueOf('C'));
        perm5.add(Character.valueOf('A'));
        perm6.add(Character.valueOf('B'));
        perm1.add(Character.valueOf('C'));
        perm2.add(Character.valueOf('B'));
        perm3.add(Character.valueOf('C'));
        perm4.add(Character.valueOf('A'));
        perm5.add(Character.valueOf('B'));
        perm6.add(Character.valueOf('A'));
        ArrayList<List> results = new ArrayList<List>();
        PermutationIterator<Character> it = this.makeObject();
        while (it.hasNext()) {
            List next = it.next();
            results.add(next);
        }
        PermutationIteratorTest.assertEquals((int)6, (int)results.size());
        PermutationIteratorTest.assertTrue((boolean)results.contains(perm1));
        PermutationIteratorTest.assertTrue((boolean)results.contains(perm2));
        PermutationIteratorTest.assertTrue((boolean)results.contains(perm3));
        PermutationIteratorTest.assertTrue((boolean)results.contains(perm4));
        PermutationIteratorTest.assertTrue((boolean)results.contains(perm5));
        PermutationIteratorTest.assertTrue((boolean)results.contains(perm6));
    }

    public void testPermutationUnicity() {
        ArrayList<List> resultsList = new ArrayList<List>();
        HashSet<List> resultsSet = new HashSet<List>();
        PermutationIterator<Character> it = this.makeObject();
        while (it.hasNext()) {
            List permutation = it.next();
            resultsList.add(permutation);
            resultsSet.add(permutation);
        }
        PermutationIteratorTest.assertEquals((int)6, (int)resultsList.size());
        PermutationIteratorTest.assertEquals((int)6, (int)resultsSet.size());
    }

    public void testPermutationException() {
        ArrayList<List> resultsList = new ArrayList<List>();
        PermutationIterator<Character> it = this.makeObject();
        while (it.hasNext()) {
            List permutation = it.next();
            resultsList.add(permutation);
        }
        try {
            it.next();
            PermutationIteratorTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testPermutatorHasMore() {
        PermutationIterator<Character> it = this.makeObject();
        for (int i = 0; i < 6; ++i) {
            PermutationIteratorTest.assertTrue((boolean)it.hasNext());
            it.next();
        }
        PermutationIteratorTest.assertFalse((boolean)it.hasNext());
    }

    public void testEmptyCollection() {
        PermutationIterator<Character> it = this.makeEmptyIterator();
        PermutationIteratorTest.assertTrue((boolean)it.hasNext());
        List nextPermutation = it.next();
        PermutationIteratorTest.assertEquals((int)0, (int)nextPermutation.size());
        PermutationIteratorTest.assertFalse((boolean)it.hasNext());
    }
}

