/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.util.Map;
import java.util.TreeMap;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.OrderedBidiMap;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.bidimap.AbstractOrderedBidiMapTest;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableOrderedBidiMap;

public class UnmodifiableOrderedBidiMapTest<K extends Comparable<K>, V extends Comparable<V>>
extends AbstractOrderedBidiMapTest<K, V> {
    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableOrderedBidiMapTest.class);
    }

    public UnmodifiableOrderedBidiMapTest(String testName) {
        super(testName);
    }

    @Override
    public OrderedBidiMap<K, V> makeObject() {
        return UnmodifiableOrderedBidiMap.unmodifiableOrderedBidiMap((OrderedBidiMap)new TreeBidiMap());
    }

    @Override
    public OrderedBidiMap<K, V> makeFullMap() {
        TreeBidiMap bidi = new TreeBidiMap();
        this.addSampleMappings(bidi);
        return UnmodifiableOrderedBidiMap.unmodifiableOrderedBidiMap((OrderedBidiMap)bidi);
    }

    @Override
    public Map<K, V> makeConfirmedMap() {
        return new TreeMap();
    }

    @Override
    public String[] ignoredTests() {
        return new String[]{"UnmodifiableOrderedBidiMapTest.bulkTestInverseMap.bulkTestInverseMap"};
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public boolean isAllowNullValue() {
        return false;
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isPutChangeSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    public void testUnmodifiable() {
        UnmodifiableOrderedBidiMapTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableOrderedBidiMapTest.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        OrderedBidiMap<K, V> map = this.makeFullMap();
        UnmodifiableOrderedBidiMapTest.assertSame(map, (Object)UnmodifiableOrderedBidiMap.unmodifiableOrderedBidiMap(map));
        try {
            UnmodifiableOrderedBidiMap.unmodifiableOrderedBidiMap(null);
            UnmodifiableOrderedBidiMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

