/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.RFC1522Codec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RFC1522CodecTest {
    private void assertExpectedDecoderException(String s) {
        Assertions.assertThrows(DecoderException.class, () -> new RFC1522TestCodec().decodeText(s));
    }

    @Test
    public void testDecodeInvalid() throws Exception {
        this.assertExpectedDecoderException("whatever");
        this.assertExpectedDecoderException("=?");
        this.assertExpectedDecoderException("?=");
        this.assertExpectedDecoderException("==");
        this.assertExpectedDecoderException("=??=");
        this.assertExpectedDecoderException("=?stuff?=");
        this.assertExpectedDecoderException("=?UTF-8??=");
        this.assertExpectedDecoderException("=?UTF-8?stuff?=");
        this.assertExpectedDecoderException("=?UTF-8?T?stuff");
        this.assertExpectedDecoderException("=??T?stuff?=");
        this.assertExpectedDecoderException("=?UTF-8??stuff?=");
        this.assertExpectedDecoderException("=?UTF-8?W?stuff?=");
    }

    @Test
    public void testNullInput() throws Exception {
        RFC1522TestCodec testCodec = new RFC1522TestCodec();
        Assertions.assertNull((Object)testCodec.decodeText(null));
        Assertions.assertNull((Object)testCodec.encodeText(null, CharEncoding.UTF_8));
    }

    static class RFC1522TestCodec
    extends RFC1522Codec {
        RFC1522TestCodec() {
            super(StandardCharsets.UTF_8);
        }

        protected byte[] doDecoding(byte[] bytes) {
            return bytes;
        }

        protected byte[] doEncoding(byte[] bytes) {
            return bytes;
        }

        protected String getEncoding() {
            return "T";
        }
    }
}

