/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.digest.Crypt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CryptTest {
    public static void main(String[] args) {
        switch (args.length) {
            case 1: {
                String hash = Crypt.crypt((String)args[0]);
                System.out.println(hash.length() + ": " + hash);
                break;
            }
            case 2: {
                String hash = Crypt.crypt((String)args[0], (String)args[1]);
                System.out.println(hash.length() + "; " + hash);
                break;
            }
            default: {
                System.out.println("Enter key [salt (remember to quote this!)]");
            }
        }
    }

    private void startsWith(String string, String prefix) {
        Assertions.assertTrue((boolean)string.startsWith(prefix), (String)(string + " should start with " + prefix));
    }

    @Test
    public void testBadSalt() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)"$1$"));
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)"$5$"));
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)"$6$"));
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)"$1$%"));
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)"$5$!"));
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)"$6$_"));
    }

    @Test
    public void testBadType() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)"$2$xxxx"));
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)"$3$xxxx"));
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)"$4$"));
    }

    @Test
    public void testCrypt() {
        Assertions.assertNotNull((Object)new Crypt());
    }

    @Test
    public void testCryptWithBytes() {
        byte[] keyBytes = new byte[]{98, 121, 116, 101};
        String hash = Crypt.crypt((byte[])keyBytes);
        Assertions.assertEquals((Object)hash, (Object)Crypt.crypt((String)"byte", (String)hash));
    }

    @Test
    public void testCryptWithEmptySalt() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)""));
    }

    @Test
    public void testDefaultCryptVariant() {
        Assertions.assertTrue((boolean)Crypt.crypt((String)"secret").startsWith("$6$"));
        Assertions.assertTrue((boolean)Crypt.crypt((String)"secret", null).startsWith("$6$"));
    }

    @Test
    public void testSamples() {
        Assertions.assertEquals((Object)"$1$xxxx$aMkevjfEIpa35Bh3G4bAc.", (Object)Crypt.crypt((String)"secret", (String)"$1$xxxx"));
        Assertions.assertEquals((Object)"xxWAum7tHdIUw", (Object)Crypt.crypt((String)"secret", (String)"xx"));
    }

    @Test
    public void testStored() {
        Assertions.assertEquals((Object)"$1$xxxx$aMkevjfEIpa35Bh3G4bAc.", (Object)Crypt.crypt((String)"secret", (String)"$1$xxxx$aMkevjfEIpa35Bh3G4bAc."));
        Assertions.assertEquals((Object)"xxWAum7tHdIUw", (Object)Crypt.crypt((String)"secret", (String)"xxWAum7tHdIUw"));
    }

    @Test
    public void testType() {
        this.startsWith(Crypt.crypt((String)"secret", (String)"xxxx"), "xx");
        this.startsWith(Crypt.crypt((String)"secret", (String)"$1$xxxx"), "$1$xxxx$");
        this.startsWith(Crypt.crypt((String)"secret", (String)"$5$xxxx"), "$5$xxxx$");
        this.startsWith(Crypt.crypt((String)"secret", (String)"$6$xxxx"), "$6$xxxx$");
    }
}

