/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.binary.CharSequenceUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharSequenceUtilsTest {
    private static final TestData[] TEST_DATA = new TestData[]{new TestData("a", true, 0, "abc", 0, 0, true), new TestData("a", true, 0, "abc", 0, 1, true), new TestData("Abc", true, 0, "abc", 0, 3, true), new TestData("Abc", false, 0, "abc", 0, 3, false), new TestData("Abc", true, 1, "abc", 1, 2, true), new TestData("Abc", false, 1, "abc", 1, 2, true), new TestData("Abcd", true, 1, "abcD", 1, 2, true), new TestData("Abcd", false, 1, "abcD", 1, 2, true)};

    @Test
    public void testConstructor() {
        new CharSequenceUtils();
    }

    @Test
    public void testRegionMatches() {
        for (final TestData data : TEST_DATA) {
            new RunTest(){

                @Override
                boolean invoke() {
                    return data.source.regionMatches(data.ignoreCase, data.toffset, data.other, data.ooffset, data.len);
                }
            }.run(data, "String");
            new RunTest(){

                @Override
                boolean invoke() {
                    return CharSequenceUtils.regionMatches((CharSequence)data.source, (boolean)data.ignoreCase, (int)data.toffset, (CharSequence)data.other, (int)data.ooffset, (int)data.len);
                }
            }.run(data, "CSString");
            new RunTest(){

                @Override
                boolean invoke() {
                    return CharSequenceUtils.regionMatches((CharSequence)new StringBuilder(data.source), (boolean)data.ignoreCase, (int)data.toffset, (CharSequence)data.other, (int)data.ooffset, (int)data.len);
                }
            }.run(data, "CSNonString");
        }
    }

    static class TestData {
        final String source;
        final boolean ignoreCase;
        final int toffset;
        final String other;
        final int ooffset;
        final int len;
        final boolean expected;
        final Class<? extends Throwable> throwable;

        TestData(String source, boolean ignoreCase, int toffset, String other, int ooffset, int len, boolean expected) {
            this.source = source;
            this.ignoreCase = ignoreCase;
            this.toffset = toffset;
            this.other = other;
            this.ooffset = ooffset;
            this.len = len;
            this.expected = expected;
            this.throwable = null;
        }

        TestData(String source, boolean ignoreCase, int toffset, String other, int ooffset, int len, Class<? extends Throwable> throwable) {
            this.source = source;
            this.ignoreCase = ignoreCase;
            this.toffset = toffset;
            this.other = other;
            this.ooffset = ooffset;
            this.len = len;
            this.expected = false;
            this.throwable = throwable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.source).append("[").append(this.toffset).append("]");
            sb.append(this.ignoreCase ? " caseblind " : " samecase ");
            sb.append(this.other).append("[").append(this.ooffset).append("]");
            sb.append(" ").append(this.len).append(" => ");
            if (this.throwable != null) {
                sb.append(this.throwable);
            } else {
                sb.append(this.expected);
            }
            return sb.toString();
        }
    }

    private static abstract class RunTest {
        private RunTest() {
        }

        abstract boolean invoke();

        void run(TestData data, String id) {
            if (data.throwable != null) {
                String msg = id + " Expected " + data.throwable;
                try {
                    this.invoke();
                    Assertions.fail((String)(msg + " but nothing was thrown."));
                }
                catch (Exception ex) {
                    Assertions.assertTrue((boolean)data.throwable.isAssignableFrom(ex.getClass()), (String)(msg + " but was " + ex.getClass().getSimpleName()));
                }
            } else {
                boolean stringCheck = this.invoke();
                Assertions.assertEquals((Object)data.expected, (Object)stringCheck, (String)(id + " Failed test " + data));
            }
        }
    }
}

