/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.digest.Crypt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CryptTest {
    @Test
    public void testCrypt() {
        Assertions.assertNotNull((Object)new Crypt());
    }

    @Test
    public void testDefaultCryptVariant() {
        Assertions.assertTrue((boolean)Crypt.crypt((String)"secret").startsWith("$6$"));
        Assertions.assertTrue((boolean)Crypt.crypt((String)"secret", null).startsWith("$6$"));
    }

    @Test
    public void testCryptWithBytes() {
        byte[] keyBytes = new byte[]{98, 121, 116, 101};
        String hash = Crypt.crypt((byte[])keyBytes);
        Assertions.assertEquals((Object)hash, (Object)Crypt.crypt((String)"byte", (String)hash));
    }

    @Test
    public void testCryptWithEmptySalt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Crypt.crypt((String)"secret", (String)""));
    }
}

