/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base32InputStream;
import org.apache.commons.codec.binary.Base32OutputStream;
import org.apache.commons.codec.binary.Base32Test;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNTestData;
import org.apache.commons.codec.binary.Codec105ErrorInputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Base32InputStreamTest {
    private static final String ENCODED_FOO = "MZXW6===";
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] LF = new byte[]{10};
    private static final String STRING_FIXTURE = "Hello World";

    @Test
    public void testCodec130() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (Base32OutputStream base32os = new Base32OutputStream((OutputStream)bos);){
            base32os.write(StringUtils.getBytesUtf8((String)STRING_FIXTURE));
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        Base32InputStream ins = new Base32InputStream((InputStream)bis);
        ins.skip(1L);
        byte[] decodedBytes = BaseNTestData.streamToBytes((InputStream)ins, new byte[64]);
        String str = StringUtils.newStringUtf8((byte[])decodedBytes);
        Assertions.assertEquals((Object)STRING_FIXTURE.substring(1), (Object)str);
    }

    @Test
    public void testCodec105() throws IOException {
        try (Base32InputStream in = new Base32InputStream((InputStream)new Codec105ErrorInputStream(), true, 0, null);){
            for (int i = 0; i < 5; ++i) {
                in.read();
            }
        }
    }

    @Test
    public void testAvailable() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        try (Base32InputStream b32stream = new Base32InputStream((InputStream)ins);){
            Assertions.assertEquals((int)1, (int)b32stream.available());
            Assertions.assertEquals((long)3L, (long)b32stream.skip(10L));
            Assertions.assertEquals((int)0, (int)b32stream.available());
            Assertions.assertEquals((int)-1, (int)b32stream.read());
            Assertions.assertEquals((int)-1, (int)b32stream.read());
            Assertions.assertEquals((int)0, (int)b32stream.available());
        }
    }

    @Test
    public void testBase32EmptyInputStreamMimeChuckSize() throws Exception {
        this.testBase32EmptyInputStream(76);
    }

    @Test
    public void testBase32EmptyInputStreamPemChuckSize() throws Exception {
        this.testBase32EmptyInputStream(64);
    }

    private void testBase32EmptyInputStream(int chuckSize) throws Exception {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded, chuckSize, CRLF);
        this.testByChunk(emptyEncoded, emptyDecoded, chuckSize, CRLF);
    }

    @Test
    public void testBase32InputStreamByChunk() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"JBSWY3DPEBLW64TMMQ======\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByChunk(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA======\r\n");
        decoded = new byte[]{0};
        this.testByChunk(encoded, decoded, 76, CRLF);
        Base32 codec = new Base32();
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, 0, LF);
        }
    }

    @Test
    public void testBase32InputStreamByteByByte() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"JBSWY3DPEBLW64TMMQ======\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByteByByte(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA======\r\n");
        decoded = new byte[]{0};
        this.testByteByByte(encoded, decoded, 76, CRLF);
        Base32 codec = new Base32();
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, 0, LF);
        }
    }

    private void testByChunk(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        Object in = new Base32InputStream((InputStream)new ByteArrayInputStream(decoded), true, chunkSize, separator);
        byte[] output = BaseNTestData.streamToBytes((InputStream)in);
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
        Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming base32 encode");
        in = new Base32InputStream((InputStream)new ByteArrayInputStream(encoded));
        output = BaseNTestData.streamToBytes((InputStream)in);
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming base32 decode");
        in = new ByteArrayInputStream(decoded);
        for (int i = 0; i < 10; ++i) {
            in = new Base32InputStream((InputStream)in, true, chunkSize, separator);
            in = new Base32InputStream((InputStream)in, false);
        }
        output = BaseNTestData.streamToBytes((InputStream)in);
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming base32 wrap-wrap-wrap!");
        ((InputStream)in).close();
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        int i;
        Object in = new Base32InputStream((InputStream)new ByteArrayInputStream(decoded), true, chunkSize, separator);
        byte[] output = new byte[encoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
        Assertions.assertArrayEquals((byte[])encoded, (byte[])output, (String)"Streaming base32 encode");
        ((InputStream)in).close();
        in = new Base32InputStream((InputStream)new ByteArrayInputStream(encoded));
        output = new byte[decoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming base32 decode");
        ((InputStream)in).close();
        in = new ByteArrayInputStream(decoded);
        for (i = 0; i < 10; ++i) {
            in = new Base32InputStream((InputStream)in, true, chunkSize, separator);
            in = new Base32InputStream((InputStream)in, false);
        }
        output = new byte[decoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"EOF");
        Assertions.assertEquals((int)-1, (int)((InputStream)in).read(), (String)"Still EOF");
        Assertions.assertArrayEquals((byte[])decoded, (byte[])output, (String)"Streaming base32 wrap-wrap-wrap!");
    }

    @Test
    public void testMarkSupported() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base32InputStream in = new Base32InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            Assertions.assertFalse((boolean)in.markSupported(), (String)"Base32InputStream.markSupported() is false");
        }
    }

    @Test
    public void testRead0() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        int bytesRead = 0;
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base32InputStream in = new Base32InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            bytesRead = in.read(buf, 0, 0);
            Assertions.assertEquals((int)0, (int)bytesRead, (String)"Base32InputStream.read(buf, 0, 0) returns 0");
        }
    }

    @Test
    public void testReadNull() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base32InputStream in = new Base32InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            Assertions.assertThrows(NullPointerException.class, () -> in.read(null, 0, 0));
        }
    }

    @Test
    public void testReadOutOfBounds() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        try (Base32InputStream in = new Base32InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, -1, 0), (String)"Base32InputStream.read(buf, -1, 0)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, 0, -1), (String)"Base32InputStream.read(buf, 0, -1)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, buf.length + 1, 0), (String)"Base32InputStream.read(buf, buf.length + 1, 0)");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> in.read(buf, buf.length - 1, 2), (String)"Base32InputStream.read(buf, buf.length - 1, 2)");
        }
    }

    @Test
    public void testSkipNone() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        try (Base32InputStream b32stream = new Base32InputStream((InputStream)ins);){
            byte[] actualBytes = new byte[6];
            Assertions.assertEquals((long)0L, (long)b32stream.skip(0L));
            b32stream.read(actualBytes, 0, actualBytes.length);
            Assertions.assertArrayEquals((byte[])actualBytes, (byte[])new byte[]{102, 111, 111, 0, 0, 0});
            Assertions.assertEquals((int)-1, (int)b32stream.read());
        }
    }

    @Test
    public void testSkipBig() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        try (Base32InputStream b32stream = new Base32InputStream((InputStream)ins);){
            Assertions.assertEquals((long)3L, (long)b32stream.skip(1024L));
            Assertions.assertEquals((int)-1, (int)b32stream.read());
            Assertions.assertEquals((int)-1, (int)b32stream.read());
        }
    }

    @Test
    public void testSkipPastEnd() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        try (Base32InputStream b32stream = new Base32InputStream((InputStream)ins);){
            Assertions.assertEquals((long)3L, (long)b32stream.skip(10L));
            Assertions.assertEquals((int)-1, (int)b32stream.read());
            Assertions.assertEquals((int)-1, (int)b32stream.read());
        }
    }

    @Test
    public void testSkipToEnd() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        try (Base32InputStream b32stream = new Base32InputStream((InputStream)ins);){
            Assertions.assertEquals((long)3L, (long)b32stream.skip(3L));
            Assertions.assertEquals((int)-1, (int)b32stream.read());
            Assertions.assertEquals((int)-1, (int)b32stream.read());
        }
    }

    @Test
    public void testSkipWrongArgument() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        try (Base32InputStream b32stream = new Base32InputStream((InputStream)ins);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> b32stream.skip(-10L));
        }
    }

    @Test
    public void testStrictDecoding() throws Exception {
        for (String s : Base32Test.BASE32_IMPOSSIBLE_CASES) {
            byte[] encoded = StringUtils.getBytesUtf8((String)s);
            Base32InputStream in = new Base32InputStream((InputStream)new ByteArrayInputStream(encoded), false);
            Assertions.assertFalse((boolean)in.isStrictDecoding());
            BaseNTestData.streamToBytes((InputStream)in);
            Base32InputStream in2 = new Base32InputStream((InputStream)new ByteArrayInputStream(encoded), false, 0, null, CodecPolicy.STRICT);
            Assertions.assertTrue((boolean)in2.isStrictDecoding());
            Assertions.assertThrows(IllegalArgumentException.class, () -> BaseNTestData.streamToBytes((InputStream)in2));
        }
    }
}

