/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.Charsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharsetsTest {
    @Test
    public void testToCharset() {
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((String)null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharset((Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testIso8859_1() {
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)Charsets.ISO_8859_1.name());
    }

    @Test
    public void testUsAscii() {
        Assertions.assertEquals((Object)"US-ASCII", (Object)Charsets.US_ASCII.name());
    }

    @Test
    public void testUtf16() {
        Assertions.assertEquals((Object)"UTF-16", (Object)Charsets.UTF_16.name());
    }

    @Test
    public void testUtf16Be() {
        Assertions.assertEquals((Object)"UTF-16BE", (Object)Charsets.UTF_16BE.name());
    }

    @Test
    public void testUtf16Le() {
        Assertions.assertEquals((Object)"UTF-16LE", (Object)Charsets.UTF_16LE.name());
    }

    @Test
    public void testUtf8() {
        Assertions.assertEquals((Object)"UTF-8", (Object)Charsets.UTF_8.name());
    }
}

